/*
 * Decompiled with CFR 0.152.
 */
package com.jantursky.debugger.dbviewer.helpers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import android.util.Log;
import com.jantursky.debugger.dbviewer.db.CursorWrapper;
import com.jantursky.debugger.dbviewer.models.DbViewerDataModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DBViewerHelper {
    private static final String TAG = DBViewerHelper.class.getSimpleName();
    private static DBViewerHelper instance;
    private DatabaseHelper databaseHelper;
    private SQLiteDatabase db;

    private DBViewerHelper(Context context, File dbFile) {
        this.initDatabaseHelper(context, dbFile);
        this.initSQLiteDatabase();
    }

    public static void resetInstance() {
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBViewerHelper getInstance(Context context, File file) {
        if (instance != null) return instance;
        Class<DBViewerHelper> clazz = DBViewerHelper.class;
        synchronized (DBViewerHelper.class) {
            if (instance != null) return instance;
            instance = new DBViewerHelper(context, file);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    public static String[] getArgs(Object ... args) {
        String[] resultArgs = null;
        if (args != null && args.length > 0) {
            ArrayList<String> argsList = new ArrayList<String>();
            for (Object argument : args) {
                String argumentString;
                if (argument == null || (argumentString = argument.toString()).equals("")) continue;
                argsList.add(argumentString);
            }
            resultArgs = argsList.toArray(new String[argsList.size()]);
        }
        return resultArgs;
    }

    private void initDatabaseHelper(Context context, File file) {
        Log.w((String)TAG, (String)("##### INIT " + file.getPath()));
        SQLiteDatabase db = SQLiteDatabase.openDatabase((String)file.getPath(), null, (int)0);
        int version = db.getVersion();
        db.close();
        this.databaseHelper = new DatabaseHelper(context, file.getPath(), version);
    }

    private void initSQLiteDatabase() {
        try {
            this.db = this.databaseHelper.getWritableDatabase();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("### Failed to init DB " + e.getMessage()));
        }
    }

    public ArrayList<String> getAllTables() {
        Cursor cursor = this.db.rawQuery("SELECT name FROM sqlite_master WHERE type='table'", null);
        ArrayList<String> tables = new ArrayList<String>();
        if (cursor != null) {
            while (cursor.moveToNext()) {
                tables.add(cursor.getString(0));
            }
            cursor.close();
        }
        Collections.sort(tables);
        return tables;
    }

    public String[] getAllColumns(String table) {
        Cursor cursor = this.db.query(table, null, null, null, null, null, null);
        String[] names = null;
        if (cursor != null) {
            names = cursor.getColumnNames();
            cursor.close();
        }
        return names;
    }

    public ArrayList<DbViewerDataModel> getColumnsType(String table) {
        Cursor cursor = this.db.rawQuery("PRAGMA table_info(" + table + ")", null);
        ArrayList<DbViewerDataModel> headerRow = new ArrayList<DbViewerDataModel>();
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String name = cursor.getString(cursor.getColumnIndex("name"));
                String type = cursor.getString(cursor.getColumnIndex("type"));
                headerRow.add(new DbViewerDataModel(name, name, type, true));
            }
            cursor.close();
        }
        return headerRow;
    }

    public ArrayList<ArrayList<DbViewerDataModel>> getData(String table, String[] columns) {
        Cursor cursor = this.db.rawQuery("SELECT * FROM " + table, null);
        ArrayList<ArrayList<DbViewerDataModel>> arrayList = new ArrayList<ArrayList<DbViewerDataModel>>();
        if (cursor != null) {
            while (cursor.moveToNext()) {
                ArrayList<DbViewerDataModel> arrayRow = new ArrayList<DbViewerDataModel>();
                for (String column : columns) {
                    int index = cursor.getColumnIndex(column);
                    int type = cursor.getType(index);
                    if (type == 0) {
                        arrayRow.add(new DbViewerDataModel(column, type, "NULL"));
                        continue;
                    }
                    if (type == 3) {
                        arrayRow.add(new DbViewerDataModel(column, type, cursor.getString(index)));
                        continue;
                    }
                    if (type == 2) {
                        arrayRow.add(new DbViewerDataModel(column, type, cursor.getFloat(index)));
                        continue;
                    }
                    if (type == 1) {
                        arrayRow.add(new DbViewerDataModel(column, type, cursor.getInt(index)));
                        continue;
                    }
                    if (type != 4) continue;
                    arrayRow.add(new DbViewerDataModel(column, type, "BLOB"));
                }
                arrayList.add(arrayRow);
            }
            cursor.close();
        }
        return arrayList;
    }

    public int getCount(String tableName) {
        return this.getCount(tableName, null);
    }

    public int getCount(String tableName, String condition) {
        int count = -1;
        String query = "SELECT COUNT(*) AS cnt FROM " + tableName + (TextUtils.isEmpty((CharSequence)condition) ? "" : " WHERE " + condition);
        CursorWrapper cursor = this.rawQuery(query, null);
        if (cursor != null) {
            if (cursor.moveToNext()) {
                count = cursor.getInt("cnt");
            }
            cursor.close();
        }
        return count;
    }

    public void close() {
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
        if (this.databaseHelper != null) {
            this.databaseHelper.close();
            this.databaseHelper = null;
        }
    }

    public void execSql(String sql) {
        this.db.execSQL(sql);
    }

    public CursorWrapper rawQuery(String sql, String[] sqlArgs) {
        CursorWrapper cursorWrapper = null;
        try {
            Cursor cursor = this.db.rawQuery(sql, sqlArgs);
            cursorWrapper = new CursorWrapper(cursor);
        }
        catch (Exception ex) {
            Log.w((String)"Query error", (Throwable)ex);
        }
        return cursorWrapper;
    }

    public String queryValueAsString(String sql, String[] sqlArgs) {
        String val = "";
        try {
            Cursor cursor = this.db.rawQuery(sql, sqlArgs);
            if (cursor != null) {
                if (cursor.moveToNext()) {
                    val = cursor.getString(0);
                }
                cursor.close();
            }
        }
        catch (Exception ex) {
            Log.w((String)"Query error", (Throwable)ex);
        }
        return val;
    }

    public int queryValueAsInt(String sql, String[] sqlArgs) {
        int val = -1;
        try {
            Cursor cursor = this.db.rawQuery(sql, sqlArgs);
            if (cursor != null) {
                if (cursor.moveToNext()) {
                    val = cursor.getInt(0);
                }
                cursor.close();
            }
        }
        catch (Exception ex) {
            Log.w((String)"Query error", (Throwable)ex);
        }
        return val;
    }

    public float queryValueAsFloat(String sql, String[] sqlArgs) {
        float val = -1.0f;
        try {
            Cursor cursor = this.db.rawQuery(sql, sqlArgs);
            if (cursor != null) {
                if (cursor.moveToNext()) {
                    val = cursor.getFloat(0);
                }
                cursor.close();
            }
        }
        catch (Exception ex) {
            Log.w((String)"Query error", (Throwable)ex);
        }
        return val;
    }

    public List<String> queryStringList(String sql, String[] sqlArgs) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Cursor cursor = this.db.rawQuery(sql, sqlArgs);
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    list.add(cursor.getString(0));
                }
                cursor.close();
            }
        }
        catch (Exception ex) {
            Log.w((String)"Query error", (Throwable)ex);
        }
        return list;
    }

    public CursorWrapper query(String table, String[] columns) {
        return this.query(false, table, columns, null, null, null, null, null, null);
    }

    public CursorWrapper query(String table, String[] columns, String selection, String[] selectionArgs) {
        return this.query(false, table, columns, selection, selectionArgs, null, null, null, null);
    }

    public CursorWrapper query(boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        CursorWrapper cursorWrapper = null;
        try {
            Cursor cursor = this.db.query(distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
            cursorWrapper = new CursorWrapper(cursor);
        }
        catch (Exception ex) {
            Log.w((String)("Query error " + table), (Throwable)ex);
        }
        return cursorWrapper;
    }

    public int insert(String table, ContentValues values) {
        int rowId = -1;
        try {
            rowId = (int)this.db.insert(table, null, values);
        }
        catch (Exception ex) {
            Log.w((String)("Insert error " + table), (Throwable)ex);
        }
        return rowId;
    }

    public int update(String table, ContentValues values, String query, String[] queryArgs) {
        int affectedRows = 0;
        try {
            affectedRows = this.db.update(table, values, query, queryArgs);
        }
        catch (Exception ex) {
            Log.w((String)("Update error " + table), (Throwable)ex);
        }
        return affectedRows;
    }

    public int delete(String table, String query) {
        try {
            return this.db.delete(table, query, null);
        }
        catch (Exception ex) {
            Log.w((String)("Delete error " + table), (Throwable)ex);
            return 0;
        }
    }

    public int delete(String table, String query, String[] queryArgs) {
        try {
            return this.db.delete(table, query, queryArgs);
        }
        catch (Exception ex) {
            Log.w((String)("Delete error " + table), (Throwable)ex);
            return 0;
        }
    }

    public void beginTransaction() {
        this.db.beginTransactionNonExclusive();
    }

    public void setTransactionSuccessful() {
        this.db.setTransactionSuccessful();
    }

    public void endTransaction() {
        this.db.endTransaction();
    }

    public void endTransactionSuccessful() {
        this.setTransactionSuccessful();
        this.endTransaction();
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        DatabaseHelper(Context context, String dbFileName, int dbVersion) {
            super(context, dbFileName, null, dbVersion);
        }

        public void onCreate(SQLiteDatabase db) {
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }
}

