/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.view.View;
import android.widget.AdapterView;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class AdapterViewItemClickObservable
extends Observable<Integer> {
    private final AdapterView<?> view;

    AdapterViewItemClickObservable(AdapterView<?> view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super Integer> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnItemClickListener((AdapterView.OnItemClickListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements AdapterView.OnItemClickListener {
        private final AdapterView<?> view;
        private final Observer<? super Integer> observer;

        Listener(AdapterView<?> view, Observer<? super Integer> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onItemClick(AdapterView<?> adapterView, View view, int position, long id) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)position);
            }
        }

        protected void onDispose() {
            this.view.setOnItemClickListener(null);
        }
    }
}

