/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.view;

import android.support.annotation.RequiresApi;
import android.view.View;
import android.view.ViewTreeObserver;
import com.jakewharton.rxbinding2.internal.Notification;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

@RequiresApi(value=16)
final class ViewTreeObserverDrawObservable
extends Observable<Object> {
    private final View view;

    ViewTreeObserverDrawObservable(View view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super Object> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.getViewTreeObserver().addOnDrawListener((ViewTreeObserver.OnDrawListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements ViewTreeObserver.OnDrawListener {
        private final View view;
        private final Observer<? super Object> observer;

        Listener(View view, Observer<? super Object> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onDraw() {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)Notification.INSTANCE);
            }
        }

        protected void onDispose() {
            this.view.getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)this);
        }
    }
}

