/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.view;

import android.view.View;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class ViewSystemUiVisibilityChangeObservable
extends Observable<Integer> {
    private final View view;

    ViewSystemUiVisibilityChangeObservable(View view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super Integer> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnSystemUiVisibilityChangeListener((View.OnSystemUiVisibilityChangeListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements View.OnSystemUiVisibilityChangeListener {
        private final View view;
        private final Observer<? super Integer> observer;

        Listener(View view, Observer<? super Integer> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onSystemUiVisibilityChange(int visibility) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)visibility);
            }
        }

        protected void onDispose() {
            this.view.setOnSystemUiVisibilityChangeListener(null);
        }
    }
}

