/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.view;

import android.view.View;
import com.jakewharton.rxbinding2.InitialValueObservable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class ViewFocusChangeObservable
extends InitialValueObservable<Boolean> {
    private final View view;

    ViewFocusChangeObservable(View view) {
        this.view = view;
    }

    @Override
    protected void subscribeListener(Observer<? super Boolean> observer) {
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnFocusChangeListener((View.OnFocusChangeListener)listener);
    }

    @Override
    protected Boolean getInitialValue() {
        return this.view.hasFocus();
    }

    static final class Listener
    extends MainThreadDisposable
    implements View.OnFocusChangeListener {
        private final View view;
        private final Observer<? super Boolean> observer;

        Listener(View view, Observer<? super Boolean> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onFocusChange(View v, boolean hasFocus) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)hasFocus);
            }
        }

        protected void onDispose() {
            this.view.setOnFocusChangeListener(null);
        }
    }
}

