/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.view;

import android.view.View;
import android.view.ViewTreeObserver;
import com.jakewharton.rxbinding2.internal.Notification;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.Callable;

final class ViewTreeObserverPreDrawObservable
extends Observable<Object> {
    private final View view;
    private final Callable<Boolean> proceedDrawingPass;

    ViewTreeObserverPreDrawObservable(View view, Callable<Boolean> proceedDrawingPass) {
        this.view = view;
        this.proceedDrawingPass = proceedDrawingPass;
    }

    protected void subscribeActual(Observer<? super Object> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, this.proceedDrawingPass, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements ViewTreeObserver.OnPreDrawListener {
        private final View view;
        private final Callable<Boolean> proceedDrawingPass;
        private final Observer<? super Object> observer;

        Listener(View view, Callable<Boolean> proceedDrawingPass, Observer<? super Object> observer) {
            this.view = view;
            this.proceedDrawingPass = proceedDrawingPass;
            this.observer = observer;
        }

        public boolean onPreDraw() {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)Notification.INSTANCE);
                try {
                    return this.proceedDrawingPass.call();
                }
                catch (Exception e) {
                    this.observer.onError((Throwable)e);
                    this.dispose();
                }
            }
            return true;
        }

        protected void onDispose() {
            this.view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }
    }
}

