/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.view;

import android.view.View;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.view.ViewAttachAttachedEvent;
import com.jakewharton.rxbinding2.view.ViewAttachDetachedEvent;
import com.jakewharton.rxbinding2.view.ViewAttachEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class ViewAttachEventObservable
extends Observable<ViewAttachEvent> {
    private final View view;

    ViewAttachEventObservable(View view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super ViewAttachEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements View.OnAttachStateChangeListener {
        private final View view;
        private final Observer<? super ViewAttachEvent> observer;

        Listener(View view, Observer<? super ViewAttachEvent> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onViewAttachedToWindow(View v) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)ViewAttachAttachedEvent.create(this.view));
            }
        }

        public void onViewDetachedFromWindow(View v) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)ViewAttachDetachedEvent.create(this.view));
            }
        }

        protected void onDispose() {
            this.view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }
    }
}

