/*
 * Decompiled with CFR 0.152.
 */
package com.jack.test.logger;

import android.app.Activity;
import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.jack.test.logger.Log;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogView
extends FrameLayout
implements Log.LogNode,
TextWatcher {
    private Log.LogNode mNext;
    private ScrollView mScrollView;
    private TextView mTextView;
    private boolean enableAutoScroll = true;

    public LogView(Context context) {
        this(context, null);
    }

    public LogView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LogView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mScrollView = new ScrollView(context);
        this.mScrollView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mTextView = new TextView(context);
        this.mTextView.setClickable(true);
        final GestureDetector gestureDetector = new GestureDetector((GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e) {
                LogView.this.mTextView.setText((CharSequence)"");
                return true;
            }
        });
        this.mTextView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return gestureDetector.onTouchEvent(event);
            }
        });
        this.mTextView.addTextChangedListener((TextWatcher)this);
        this.mScrollView.addView((View)this.mTextView, new ViewGroup.LayoutParams(-1, -2));
        this.addView((View)this.mScrollView);
    }

    public Log.LogNode getNext() {
        return this.mNext;
    }

    public void setNext(Log.LogNode node) {
        this.mNext = node;
    }

    @Override
    public void println(int priority, String tag, String msg, Throwable tr) {
        String priorityStr = null;
        switch (priority) {
            case 3: {
                priorityStr = "D";
                break;
            }
            case 4: {
                priorityStr = "I";
                break;
            }
            case 5: {
                priorityStr = "W";
                break;
            }
            case 6: {
                priorityStr = "E";
                break;
            }
        }
        String exceptionStr = null;
        if (tr != null) {
            exceptionStr = Log.getStackTraceString((Throwable)tr);
        }
        final StringBuilder outputBuilder = new StringBuilder();
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date curDate = new Date(System.currentTimeMillis());
        String str = formatter.format(curDate);
        outputBuilder.append(priorityStr + " ");
        outputBuilder.append(str);
        outputBuilder.append(" ");
        outputBuilder.append(msg);
        outputBuilder.append("\r\n");
        ((Activity)this.getContext()).runOnUiThread((Runnable)new Thread(new Runnable(){

            @Override
            public void run() {
                LogView.this.appendToLog(outputBuilder.toString());
            }
        }));
        if (this.mNext != null) {
            this.mNext.println(priority, tag, msg, tr);
        }
    }

    @Override
    public void clearLog() {
        this.mTextView.setText((CharSequence)"");
    }

    @Override
    public void up() {
        this.enableAutoScroll = false;
        this.mScrollView.fullScroll(1);
    }

    @Override
    public void down() {
        this.enableAutoScroll = true;
        this.scrollDown();
    }

    @Override
    public void enableAutoScroll() {
        this.enableAutoScroll = true;
    }

    public void appendToLog(String s) {
        this.mTextView.append((CharSequence)("\n" + s));
    }

    private StringBuilder appendIfNotNull(StringBuilder source, String addStr, String delimiter) {
        if (addStr != null) {
            if (addStr.length() == 0) {
                delimiter = "";
            }
            return source.append(addStr).append(delimiter);
        }
        return source;
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        if (this.enableAutoScroll) {
            this.scrollDown();
        }
    }

    private void scrollDown() {
        this.mScrollView.post(new Runnable(){

            @Override
            public void run() {
                LogView.this.mScrollView.fullScroll(130);
            }
        });
    }
}

