package com.jackandphantom.blurimage;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicBlur;
import android.widget.ImageView;

import java.lang.ref.WeakReference;



public class BlurImage {

    private  float BITMAP_SCALE=0.3f;
    private static final float BLUR_RADIUS=7f;
    private Bitmap image;

    private Context context;
    private float intensity = 08f;
    private float MAX_RADIUS=25;

    private float MIN_SCALE=0.2f;
    private float MAX_SCALE=0.9f;
    private boolean async = false;

    private BlurImage(Context context) {
        this.context = context;
    }

    /*
    *  This method is creating a blur bitmap , this method use renderscript which efficient
     *  and here we use scriptIntrinsicBlur for performing blurring
    * */
      Bitmap blur(){

        if (image == null) {
            return image;
        }

        int width= Math.round(image.getWidth()*BITMAP_SCALE);
        int height = Math.round(image.getHeight()*BITMAP_SCALE);

        Bitmap input= Bitmap.createScaledBitmap(image,width,height,false);

        Bitmap output= Bitmap.createBitmap(input);

        RenderScript rs = RenderScript.create(context);
        ScriptIntrinsicBlur intrinsicBlur = ScriptIntrinsicBlur.create(rs, Element.U8_4(rs));


        Allocation inputallocation= Allocation.createFromBitmap(rs,input);
        Allocation outputallocation= Allocation.createFromBitmap(rs,output);
        intrinsicBlur.setRadius(intensity);
        intrinsicBlur.setInput(inputallocation);
        intrinsicBlur.forEach(outputallocation);

        outputallocation.copyTo(output);

        return output;
    }

    @NonNull
    public static BlurImage with(Context context) {
       return new BlurImage(context);
    }

    /*
    * Here we get bitmap on which we apply the blur process
    * */

    public BlurImage load(Bitmap bitmap) {
        this.image = bitmap;
        return this;
    }

    public BlurImage load(int res) {
        image = BitmapFactory.decodeResource(context.getResources(), res);
        return this;
    }

    public BlurImage intensity(float intensity) {
        if (intensity<MAX_RADIUS && intensity > 0)
             this.intensity = intensity;
        else
            this.intensity = MAX_RADIUS;
        return this;
    }

    public BlurImage Async(boolean async) {
        this.async = async;
        return this;
    }

    public void into(ImageView imageView) {

        if (async) {
            new AsyncBlurImage(imageView).execute();
        }
        else {
            try {
                imageView.setImageBitmap(blur());


            } catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }

    }

    public BlurImage scale(float scale) {
        try {
            if (scale > 1.0f)
            BITMAP_SCALE = MAX_SCALE;
            else if (scale <= 0) {
                BITMAP_SCALE=MIN_SCALE;
            }else {
                BITMAP_SCALE=scale;
            }
        }catch (OutOfMemoryError error) {
            error.printStackTrace();
        }

        return this;
    }

    public float getBitmapScale() {
        return BITMAP_SCALE;
    }

    public Bitmap getImageBlur() {

        return blur();
    }

    /*
    * when developer make async true the this class will executed and it perform the blurring process in background
    * */

   private class AsyncBlurImage extends AsyncTask<Void, Void, Bitmap> {
        private WeakReference<ImageView> weakReference;

        public AsyncBlurImage(ImageView image) {
            this.weakReference = new WeakReference<ImageView>(image);
        }

        @Override
        protected Bitmap doInBackground(Void... voids) {
            return blur();
        }

        @Override
        protected void onPostExecute(Bitmap bitmap) {

            ImageView imageView = weakReference.get();

            if (imageView != null && bitmap != null) {
                imageView.setImageBitmap(bitmap);
            }

        }
    }


}
