/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.os.Build;
import com.j256.ormlite.android.AndroidCompiledStatement;
import com.j256.ormlite.android.AndroidDatabaseResults;
import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.misc.IOUtils;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.GeneratedKeyHolder;
import java.sql.Connection;
import java.sql.Savepoint;

public class AndroidDatabaseConnection
implements DatabaseConnection {
    private static Logger logger = LoggerFactory.getLogger(AndroidDatabaseConnection.class);
    private static final String[] NO_STRING_ARGS = new String[0];
    private final SQLiteDatabase db;
    private final boolean readWrite;
    private final boolean cancelQueriesEnabled;

    public AndroidDatabaseConnection(SQLiteDatabase db, boolean readWrite) {
        this(db, readWrite, false);
    }

    public AndroidDatabaseConnection(SQLiteDatabase db, boolean readWrite, boolean cancelQueriesEnabled) {
        this.db = db;
        this.readWrite = readWrite;
        this.cancelQueriesEnabled = cancelQueriesEnabled;
        logger.trace("{}: db {} opened, read-write = {}", this, (Object)db, (Object)readWrite);
    }

    @Override
    public boolean isAutoCommitSupported() {
        return true;
    }

    @Override
    public boolean isAutoCommit() throws java.sql.SQLException {
        try {
            boolean inTransaction = this.db.inTransaction();
            logger.trace("{}: in transaction is {}", this, (Object)inTransaction);
            return !inTransaction;
        }
        catch (SQLException e) {
            throw new java.sql.SQLException("problems getting auto-commit from database", e);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        if (autoCommit) {
            if (this.db.inTransaction()) {
                this.db.setTransactionSuccessful();
                this.db.endTransaction();
            }
        } else if (!this.db.inTransaction()) {
            this.db.beginTransaction();
        }
    }

    @Override
    public Savepoint setSavePoint(String name) throws java.sql.SQLException {
        try {
            this.db.beginTransaction();
            logger.trace("{}: save-point set with name {}", this, (Object)name);
            return new OurSavePoint(name);
        }
        catch (SQLException e) {
            throw new java.sql.SQLException("problems beginning transaction " + name, e);
        }
    }

    public boolean isReadWrite() {
        return this.readWrite;
    }

    @Override
    public void commit(Savepoint savepoint) throws java.sql.SQLException {
        try {
            this.db.setTransactionSuccessful();
            this.db.endTransaction();
            if (savepoint == null) {
                logger.trace("{}: transaction is successfully ended", this);
            } else {
                logger.trace("{}: transaction {} is successfully ended", this, (Object)savepoint.getSavepointName());
            }
        }
        catch (SQLException e) {
            if (savepoint == null) {
                throw new java.sql.SQLException("problems committing transaction", e);
            }
            throw new java.sql.SQLException("problems committing transaction " + savepoint.getSavepointName(), e);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws java.sql.SQLException {
        try {
            this.db.endTransaction();
            if (savepoint == null) {
                logger.trace("{}: transaction is ended, unsuccessfully", this);
            } else {
                logger.trace("{}: transaction {} is ended, unsuccessfully", this, (Object)savepoint.getSavepointName());
            }
        }
        catch (SQLException e) {
            if (savepoint == null) {
                throw new java.sql.SQLException("problems rolling back transaction", e);
            }
            throw new java.sql.SQLException("problems rolling back transaction " + savepoint.getSavepointName(), e);
        }
    }

    @Override
    public void releaseSavePoint(Savepoint savePoint) {
    }

    @Override
    public int executeStatement(String statementStr, int resultFlags) throws java.sql.SQLException {
        return AndroidCompiledStatement.execSql(this.db, statementStr, statementStr, NO_STRING_ARGS);
    }

    @Override
    public CompiledStatement compileStatement(String statement, StatementBuilder.StatementType type, FieldType[] argFieldTypes, int resultFlags, boolean cacheStore) {
        AndroidCompiledStatement stmt = new AndroidCompiledStatement(statement, this.db, type, this.cancelQueriesEnabled, cacheStore);
        logger.trace("{}: compiled statement got {}: {}", this, (Object)stmt, (Object)statement);
        return stmt;
    }

    @Override
    public int insert(String statement, Object[] args, FieldType[] argFieldTypes, GeneratedKeyHolder keyHolder) throws java.sql.SQLException {
        SQLiteStatement stmt = null;
        try {
            stmt = this.db.compileStatement(statement);
            this.bindArgs(stmt, args, argFieldTypes);
            long rowId = stmt.executeInsert();
            if (keyHolder != null) {
                keyHolder.addKey(rowId);
            }
            int result = 1;
            logger.trace("{}: insert statement is compiled and executed, changed {}: {}", this, (Object)result, (Object)statement);
            int n = result;
            return n;
        }
        catch (SQLException e) {
            throw new java.sql.SQLException("inserting to database failed: " + statement, e);
        }
        finally {
            this.closeQuietly(stmt);
        }
    }

    @Override
    public int update(String statement, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        return this.execute(statement, args, argFieldTypes, "updated");
    }

    @Override
    public int delete(String statement, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        return this.execute(statement, args, argFieldTypes, "deleted");
    }

    @Override
    public <T> Object queryForOne(String statement, Object[] args, FieldType[] argFieldTypes, GenericRowMapper<T> rowMapper, ObjectCache objectCache) throws java.sql.SQLException {
        T t;
        T first;
        AndroidDatabaseResults results;
        Cursor cursor;
        block7: {
            block6: {
                cursor = null;
                results = null;
                cursor = this.db.rawQuery(statement, this.toStrings(args));
                results = new AndroidDatabaseResults(cursor, objectCache, true);
                logger.trace("{}: queried for one result: {}", this, (Object)statement);
                if (results.first()) break block6;
                Object var8_8 = null;
                IOUtils.closeQuietly(results);
                this.closeQuietly(cursor);
                return var8_8;
            }
            first = rowMapper.mapRow(results);
            if (!results.next()) break block7;
            Object object = MORE_THAN_ONE;
            IOUtils.closeQuietly(results);
            this.closeQuietly(cursor);
            return object;
        }
        try {
            t = first;
        }
        catch (SQLException e) {
            try {
                throw new java.sql.SQLException("queryForOne from database failed: " + statement, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(results);
                this.closeQuietly(cursor);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(results);
        this.closeQuietly(cursor);
        return t;
    }

    @Override
    public long queryForLong(String statement) throws java.sql.SQLException {
        SQLiteStatement stmt = null;
        try {
            stmt = this.db.compileStatement(statement);
            long result = stmt.simpleQueryForLong();
            logger.trace("{}: query for long simple query returned {}: {}", this, (Object)result, (Object)statement);
            long l = result;
            return l;
        }
        catch (SQLException e) {
            throw new java.sql.SQLException("queryForLong from database failed: " + statement, e);
        }
        finally {
            this.closeQuietly(stmt);
        }
    }

    @Override
    public long queryForLong(String statement, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        long l;
        Cursor cursor = null;
        AndroidDatabaseResults results = null;
        try {
            cursor = this.db.rawQuery(statement, this.toStrings(args));
            results = new AndroidDatabaseResults(cursor, null, false);
            long result = results.first() ? results.getLong(0) : 0L;
            logger.trace("{}: query for long raw query returned {}: {}", this, (Object)result, (Object)statement);
            l = result;
            this.closeQuietly(cursor);
        }
        catch (SQLException e) {
            try {
                throw new java.sql.SQLException("queryForLong from database failed: " + statement, e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(cursor);
                IOUtils.closeQuietly(results);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(results);
        return l;
    }

    @Override
    public void close() throws Exception {
        try {
            this.db.close();
            logger.trace("{}: db {} closed", this, (Object)this.db);
        }
        catch (SQLException e) {
            throw new java.sql.SQLException("problems closing the database connection", e);
        }
    }

    @Override
    public void closeQuietly() {
        IOUtils.closeQuietly(this);
    }

    @Override
    public boolean isClosed() throws java.sql.SQLException {
        try {
            boolean isOpen = this.db.isOpen();
            logger.trace("{}: db {} isOpen returned {}", this, (Object)this.db, (Object)isOpen);
            return !isOpen;
        }
        catch (SQLException e) {
            throw new java.sql.SQLException("problems detecting if the database is closed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTableExists(String tableName) {
        try (Cursor cursor = this.db.rawQuery("SELECT DISTINCT tbl_name FROM sqlite_master WHERE tbl_name = ?", new String[]{tableName});){
            boolean result = cursor.getCount() > 0;
            logger.trace("{}: isTableExists '{}' returned {}", this, (Object)tableName, (Object)result);
            boolean bl = result;
            return bl;
        }
    }

    @Override
    public Connection getUnderlyingConnection() {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(super.hashCode());
    }

    private int execute(String statement, Object[] args, FieldType[] argFieldTypes, String label) throws java.sql.SQLException {
        int result = -1;
        SQLiteStatement stmt = null;
        try {
            stmt = this.db.compileStatement(statement);
            this.bindArgs(stmt, args, argFieldTypes);
            if (Build.VERSION.SDK_INT >= 11) {
                result = stmt.executeUpdateDelete();
            } else {
                stmt.execute();
            }
        }
        catch (SQLException e) {
            throw new java.sql.SQLException("updating database failed: " + statement, e);
        }
        finally {
            this.closeQuietly(stmt);
        }
        if (result < 0) {
            result = this.selectNumChanges(label);
        }
        logger.trace("{} statement is compiled and executed, changed {}: {}", (Object)label, (Object)result, (Object)statement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int selectNumChanges(String label) {
        SQLiteStatement stmt = null;
        try {
            stmt = this.db.compileStatement("SELECT CHANGES()");
            int n = (int)stmt.simpleQueryForLong();
            return n;
        }
        catch (SQLException e) {
            logger.warn((Throwable)e, "{} unable to run statement 'SELECT CHANGES()' to get the changed lines", (Object)label);
            int n = 1;
            return n;
        }
        finally {
            this.closeQuietly(stmt);
        }
    }

    private void bindArgs(SQLiteStatement stmt, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        if (args == null) {
            return;
        }
        block7: for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) {
                stmt.bindNull(i + 1);
                continue;
            }
            SqlType sqlType = argFieldTypes[i].getSqlType();
            switch (sqlType) {
                case STRING: 
                case LONG_STRING: 
                case CHAR: {
                    stmt.bindString(i + 1, arg.toString());
                    continue block7;
                }
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INTEGER: 
                case LONG: {
                    stmt.bindLong(i + 1, ((Number)arg).longValue());
                    continue block7;
                }
                case FLOAT: 
                case DOUBLE: {
                    stmt.bindDouble(i + 1, ((Number)arg).doubleValue());
                    continue block7;
                }
                case BYTE_ARRAY: 
                case SERIALIZABLE: {
                    stmt.bindBlob(i + 1, (byte[])arg);
                    continue block7;
                }
                case DATE: 
                case BLOB: 
                case BIG_DECIMAL: {
                    throw new java.sql.SQLException("Invalid Android type: " + (Object)((Object)sqlType));
                }
                default: {
                    throw new java.sql.SQLException("Unknown sql argument type: " + (Object)((Object)sqlType));
                }
            }
        }
    }

    private String[] toStrings(Object[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        String[] strings = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            strings[i] = arg == null ? null : arg.toString();
        }
        return strings;
    }

    private void closeQuietly(Cursor cursor) {
        if (cursor != null) {
            cursor.close();
        }
    }

    private void closeQuietly(SQLiteStatement statement) {
        if (statement != null) {
            statement.close();
        }
    }

    private static class OurSavePoint
    implements Savepoint {
        private String name;

        public OurSavePoint(String name) {
            this.name = name;
        }

        @Override
        public int getSavepointId() {
            return 0;
        }

        @Override
        public String getSavepointName() {
            return this.name;
        }
    }
}

