/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.util.Log;
import com.j256.ormlite.logger.Level;
import com.j256.ormlite.logger.LogBackend;
import com.j256.ormlite.logger.LogBackendFactory;
import com.j256.ormlite.logger.LoggerFactory;

public class AndroidLogBackend
implements LogBackend {
    private static final String ALL_LOGS_NAME = "ORMLite";
    private static final int REFRESH_LEVEL_CACHE_EVERY = 200;
    private static final int MAX_TAG_LENGTH = 23;
    private final String className;
    private volatile int levelCacheC = 0;
    private final boolean[] levelCache;

    public AndroidLogBackend(String className) {
        String simpleName = LoggerFactory.getSimpleClassName((String)className);
        int length = simpleName.length();
        if (length > 23) {
            simpleName = className.substring(length - 23, length);
        }
        this.className = simpleName;
        int maxLevel = 0;
        for (Level level : Level.values()) {
            int androidLevel = this.levelToAndroidLevel(level);
            if (androidLevel <= maxLevel) continue;
            maxLevel = androidLevel;
        }
        this.levelCache = new boolean[maxLevel + 1];
        this.refreshLevelCache();
    }

    public boolean isLevelEnabled(Level level) {
        int androidLevel;
        if (++this.levelCacheC >= 200) {
            this.refreshLevelCache();
            this.levelCacheC = 0;
        }
        if ((androidLevel = this.levelToAndroidLevel(level)) < this.levelCache.length) {
            return this.levelCache[androidLevel];
        }
        return this.isLevelEnabledInternal(androidLevel);
    }

    public void log(Level level, String msg) {
        switch (level) {
            case TRACE: {
                Log.v((String)this.className, (String)msg);
                break;
            }
            case DEBUG: {
                Log.d((String)this.className, (String)msg);
                break;
            }
            case WARNING: {
                Log.w((String)this.className, (String)msg);
                break;
            }
            case ERROR: {
                Log.e((String)this.className, (String)msg);
                break;
            }
            case FATAL: {
                Log.e((String)this.className, (String)msg);
                break;
            }
            default: {
                Log.i((String)this.className, (String)msg);
            }
        }
    }

    public void log(Level level, String msg, Throwable t) {
        switch (level) {
            case TRACE: {
                Log.v((String)this.className, (String)msg, (Throwable)t);
                break;
            }
            case DEBUG: {
                Log.d((String)this.className, (String)msg, (Throwable)t);
                break;
            }
            case WARNING: {
                Log.w((String)this.className, (String)msg, (Throwable)t);
                break;
            }
            case ERROR: {
                Log.e((String)this.className, (String)msg, (Throwable)t);
                break;
            }
            case FATAL: {
                Log.e((String)this.className, (String)msg, (Throwable)t);
                break;
            }
            default: {
                Log.i((String)this.className, (String)msg, (Throwable)t);
            }
        }
    }

    private void refreshLevelCache() {
        for (Level level : Level.values()) {
            int androidLevel = this.levelToAndroidLevel(level);
            if (androidLevel >= this.levelCache.length) continue;
            this.levelCache[androidLevel] = this.isLevelEnabledInternal(androidLevel);
        }
    }

    private boolean isLevelEnabledInternal(int androidLevel) {
        return Log.isLoggable((String)this.className, (int)androidLevel) || Log.isLoggable((String)ALL_LOGS_NAME, (int)androidLevel);
    }

    private int levelToAndroidLevel(Level level) {
        switch (level) {
            case TRACE: {
                return 2;
            }
            case DEBUG: {
                return 3;
            }
            case WARNING: {
                return 5;
            }
            case ERROR: {
                return 6;
            }
            case FATAL: {
                return 6;
            }
        }
        return 4;
    }

    public static class AndroidLogBackendFactory
    implements LogBackendFactory {
        public LogBackend createLogBackend(String classLabel) {
            return new AndroidLogBackend(classLabel);
        }
    }
}

