/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.j256.ormlite.android.AndroidDatabaseResults;
import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseResults;
import java.util.ArrayList;
import java.util.List;

public class AndroidCompiledStatement
implements CompiledStatement {
    private static Logger logger = LoggerFactory.getLogger(AndroidCompiledStatement.class);
    private final String sql;
    private final SQLiteDatabase db;
    private final StatementBuilder.StatementType type;
    private static final String[] NO_STRING_ARGS = new String[0];
    private Cursor cursor;
    private List<Object> args;
    private Integer max;

    public AndroidCompiledStatement(String sql, SQLiteDatabase db, StatementBuilder.StatementType type) {
        this.sql = sql;
        this.db = db;
        this.type = type;
    }

    public int getColumnCount() throws java.sql.SQLException {
        return this.getCursor().getColumnCount();
    }

    public String getColumnName(int column) throws java.sql.SQLException {
        return this.getCursor().getColumnName(column);
    }

    public DatabaseResults runQuery(ObjectCache objectCache) throws java.sql.SQLException {
        if (!this.type.isOkForQuery()) {
            throw new IllegalArgumentException("Cannot call query on a " + this.type + " statement");
        }
        return new AndroidDatabaseResults(this.getCursor(), objectCache);
    }

    public int runUpdate() throws java.sql.SQLException {
        if (!this.type.isOkForUpdate()) {
            throw new IllegalArgumentException("Cannot call update on a " + this.type + " statement");
        }
        String finalSql = this.max == null ? this.sql : this.sql + " " + this.max;
        return this.execSql("runUpdate", finalSql);
    }

    public int runExecute() throws java.sql.SQLException {
        if (!this.type.isOkForExecute()) {
            throw new IllegalArgumentException("Cannot call execute on a " + this.type + " statement");
        }
        return this.execSql("runExecute", this.sql);
    }

    public void close() throws java.sql.SQLException {
        if (this.cursor != null) {
            try {
                this.cursor.close();
            }
            catch (SQLException e) {
                throw SqlExceptionUtil.create((String)"Problems closing Android cursor", (Throwable)e);
            }
        }
    }

    public void setObject(int parameterIndex, Object obj, SqlType sqlType) throws java.sql.SQLException {
        this.isInPrep();
        if (this.args == null) {
            this.args = new ArrayList<Object>();
        }
        if (obj == null) {
            this.args.add(parameterIndex, null);
            return;
        }
        switch (sqlType) {
            case STRING: 
            case LONG_STRING: 
            case DATE: 
            case BOOLEAN: 
            case CHAR: 
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                this.args.add(parameterIndex, obj.toString());
                break;
            }
            case BYTE_ARRAY: 
            case SERIALIZABLE: {
                this.args.add(parameterIndex, obj);
                break;
            }
            case BLOB: 
            case BIG_DECIMAL: {
                throw new java.sql.SQLException("Invalid Android type: " + sqlType);
            }
            default: {
                throw new java.sql.SQLException("Unknown sql argument type: " + sqlType);
            }
        }
    }

    public void setMaxRows(int max) throws java.sql.SQLException {
        this.isInPrep();
        this.max = max;
    }

    public void setQueryTimeout(long millis) {
    }

    public Cursor getCursor() throws java.sql.SQLException {
        if (this.cursor == null) {
            String finalSql = null;
            try {
                finalSql = this.max == null ? this.sql : this.sql + " " + this.max;
                this.cursor = this.db.rawQuery(finalSql, this.getStringArray());
                this.cursor.moveToFirst();
                logger.trace("{}: started rawQuery cursor for: {}", (Object)this, (Object)finalSql);
            }
            catch (SQLException e) {
                throw SqlExceptionUtil.create((String)("Problems executing Android query: " + finalSql), (Throwable)e);
            }
        }
        return this.cursor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(super.hashCode());
    }

    private void isInPrep() throws java.sql.SQLException {
        if (this.cursor != null) {
            throw new java.sql.SQLException("Query already run. Cannot add argument values.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execSql(String label, String finalSql) throws java.sql.SQLException {
        int result;
        try {
            this.db.execSQL(finalSql, this.getArgArray());
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("Problems executing " + label + " Android statement: " + finalSql), (Throwable)e);
        }
        SQLiteStatement stmt = null;
        try {
            stmt = this.db.compileStatement("SELECT CHANGES()");
            result = (int)stmt.simpleQueryForLong();
        }
        catch (SQLException e) {
            result = 1;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        logger.trace("compiled statement {} changed {} rows: {}", (Object)label, (Object)result, (Object)finalSql);
        return result;
    }

    private Object[] getArgArray() {
        if (this.args == null) {
            return NO_STRING_ARGS;
        }
        return this.args.toArray(new Object[this.args.size()]);
    }

    private String[] getStringArray() {
        if (this.args == null) {
            return NO_STRING_ARGS;
        }
        return this.args.toArray(new String[this.args.size()]);
    }
}

