/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.query;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.query.Comparison;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseComparison
implements Comparison {
    protected final String columnName;
    protected final FieldType fieldType;
    private final Object value;

    protected BaseComparison(String columnName, FieldType fieldType, Object value) {
        this.columnName = columnName;
        this.fieldType = fieldType;
        this.value = value;
    }

    @Override
    public abstract StringBuilder appendOperation(StringBuilder var1);

    @Override
    public StringBuilder appendSql(DatabaseType databaseType, StringBuilder sb, List<SelectArg> selectArgList) throws SQLException {
        databaseType.appendEscapedEntityName(sb, this.columnName);
        sb.append(' ');
        this.appendOperation(sb);
        this.appendValue(databaseType, sb, selectArgList);
        return sb;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public StringBuilder appendValue(DatabaseType databaseType, StringBuilder sb, List<SelectArg> selectArgList) throws SQLException {
        this.appendArgOrValue(databaseType, this.fieldType, sb, selectArgList, this.value);
        return sb;
    }

    protected void appendArgOrValue(DatabaseType databaseType, FieldType fieldType, StringBuilder sb, List<SelectArg> selectArgList, Object argOrValue) throws SQLException {
        boolean appendSpace = true;
        if (argOrValue == null) {
            throw new IllegalArgumentException("argument to comparison of '" + fieldType.getFieldName() + "' is null");
        }
        if (argOrValue instanceof SelectArg) {
            sb.append('?');
            SelectArg selectArg = (SelectArg)argOrValue;
            selectArg.setMetaInfo(this.columnName, fieldType);
            selectArgList.add(selectArg);
        } else if (fieldType.isForeign() && fieldType.getFieldType() == argOrValue.getClass()) {
            FieldType idFieldType = fieldType.getForeignIdField();
            this.appendArgOrValue(databaseType, idFieldType, sb, selectArgList, idFieldType.extractJavaFieldValue(argOrValue));
            appendSpace = false;
        } else if (fieldType.isNumber()) {
            sb.append(argOrValue.toString());
        } else {
            databaseType.appendEscapedWord(sb, argOrValue.toString());
        }
        if (appendSpace) {
            sb.append(' ');
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.columnName).append(' ');
        this.appendOperation(sb).append(' ');
        sb.append(this.value);
        return sb.toString();
    }
}

