/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.j256.ormlite.android.AndroidDatabaseResults;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseResults;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class AndroidCompiledStatement
implements CompiledStatement {
    private final String sql;
    private final SQLiteDatabase db;
    private final StatementBuilder.StatementType type;
    private Cursor cursor;
    private final List<Object> args = new ArrayList<Object>();
    private Integer max;

    public AndroidCompiledStatement(String sql, SQLiteDatabase db, StatementBuilder.StatementType type) {
        this.sql = sql;
        this.db = db;
        this.type = type;
    }

    public int getColumnCount() throws SQLException {
        return this.getCursor().getColumnCount();
    }

    public String getColumnName(int column) throws SQLException {
        return this.getCursor().getColumnName(AndroidDatabaseResults.jdbcColumnIndexToAndroid(column));
    }

    public DatabaseResults executeQuery() throws SQLException {
        if (this.type != StatementBuilder.StatementType.SELECT) {
            throw new IllegalArgumentException("Cannot call executeQuery on a " + (Object)((Object)this.type) + " statement");
        }
        return new AndroidDatabaseResults(this.getCursor());
    }

    public int executeUpdate() throws SQLException {
        if (this.type == StatementBuilder.StatementType.SELECT) {
            throw new IllegalArgumentException("Cannot call executeUpdate on a " + (Object)((Object)this.type) + " statement");
        }
        String finalSql = null;
        try {
            finalSql = this.max == null ? this.sql : this.sql + " " + this.max;
            this.db.execSQL(finalSql, this.args.toArray(new Object[this.args.size()]));
        }
        catch (Exception e) {
            throw SqlExceptionUtil.create("Problems executing Android statement: " + finalSql, e);
        }
        return 1;
    }

    public DatabaseResults getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException("Unsupported operation to getGeneratedKeys");
    }

    public void close() throws SQLException {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    public void setNull(int parameterIndex, SqlType sqlType) throws SQLException {
        this.isInPrep();
        this.args.add(AndroidDatabaseResults.jdbcColumnIndexToAndroid(parameterIndex), null);
    }

    public void setObject(int parameterIndex, Object obj, SqlType sqlType) throws SQLException {
        this.isInPrep();
        this.args.add(AndroidDatabaseResults.jdbcColumnIndexToAndroid(parameterIndex), obj.toString());
    }

    public void setMaxRows(int max) throws SQLException {
        this.isInPrep();
        this.max = max;
    }

    public Cursor getCursor() throws SQLException {
        if (this.cursor == null) {
            String finalSql = null;
            try {
                finalSql = this.max == null ? this.sql : this.sql + " " + this.max;
                this.cursor = this.db.rawQuery(finalSql, this.args.toArray(new String[this.args.size()]));
                this.cursor.moveToFirst();
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Problems executing Android query: " + finalSql, e);
            }
        }
        return this.cursor;
    }

    private void isInPrep() throws SQLException {
        if (this.cursor != null) {
            throw new SQLException("Query already run. Cannot add argument values.");
        }
    }
}

