/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android.apptools;

import android.content.Context;
import com.j256.ormlite.android.apptools.ClassNameProvidedOpenHelperFactory;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import java.util.concurrent.atomic.AtomicInteger;

public class OpenHelperManager {
    private static SqliteOpenHelperFactory factory;
    private static volatile OrmLiteSqliteOpenHelper helper;
    private static AtomicInteger instanceCount;
    private static String LOG_NAME;
    private static Object helperLock;

    public static void setOpenHelperFactory(SqliteOpenHelperFactory factory) {
        OpenHelperManager.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrmLiteSqliteOpenHelper getHelper(Context context) {
        if (helper == null) {
            Object object = helperLock;
            synchronized (object) {
                if (helper == null) {
                    if (factory == null) {
                        OpenHelperManager.setOpenHelperFactory(new ClassNameProvidedOpenHelperFactory());
                    }
                    helper = factory.getHelper(context);
                    instanceCount.set(0);
                }
            }
        }
        instanceCount.incrementAndGet();
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release() {
        int instC = instanceCount.decrementAndGet();
        if (instC == 0) {
            Object object = helperLock;
            synchronized (object) {
                if (helper != null) {
                    helper.close();
                    helper = null;
                }
            }
        } else if (instC < 0) {
            throw new IllegalStateException("Too many calls to release helper.  Instance count = " + instC);
        }
    }

    static {
        helper = null;
        instanceCount = new AtomicInteger();
        LOG_NAME = OpenHelperManager.class.getName();
        helperLock = new Object();
    }

    public static interface SqliteOpenHelperFactory {
        public OrmLiteSqliteOpenHelper getHelper(Context var1);
    }
}

