/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.database.sqlite.SQLiteOpenHelper;
import com.j256.ormlite.android.AndroidDatabaseConnection;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.db.SqliteAndroidDatabaseType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.support.BaseConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import java.sql.SQLException;

public class AndroidConnectionSource
extends BaseConnectionSource
implements ConnectionSource {
    private static final Logger logger = LoggerFactory.getLogger(AndroidConnectionSource.class);
    private SQLiteOpenHelper helper;
    private DatabaseConnection readOnlyConnection = null;
    private DatabaseConnection readWriteConnection = null;
    private DatabaseType databaseType = new SqliteAndroidDatabaseType();

    public AndroidConnectionSource(SQLiteOpenHelper helper) {
        this.helper = helper;
    }

    public DatabaseConnection getReadOnlyConnection() throws SQLException {
        DatabaseConnection conn = this.getSavedConnection();
        if (conn != null) {
            return conn;
        }
        if (this.readOnlyConnection == null) {
            this.readOnlyConnection = new AndroidDatabaseConnection(this.helper.getReadableDatabase(), false);
        }
        return this.readOnlyConnection;
    }

    public DatabaseConnection getReadWriteConnection() throws SQLException {
        DatabaseConnection conn = this.getSavedConnection();
        if (conn != null) {
            return conn;
        }
        if (this.readWriteConnection == null) {
            this.readWriteConnection = new AndroidDatabaseConnection(this.helper.getWritableDatabase(), true);
        }
        return this.readWriteConnection;
    }

    public void releaseConnection(DatabaseConnection connection) throws SQLException {
    }

    public boolean saveSpecialConnection(DatabaseConnection connection) throws SQLException {
        return this.saveSpecial(connection);
    }

    public void clearSpecialConnection(DatabaseConnection connection) {
        this.clearSpecial(connection, logger);
    }

    public void close() {
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

