/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import com.j256.ormlite.logger.Log;
import com.j256.ormlite.logger.LoggerFactory;

public class AndroidLog
implements Log {
    private static final int MAX_TAG_LENGTH = 23;
    private String className;

    public AndroidLog(String className) {
        this.className = LoggerFactory.getSimpleClassName((String)className);
        int length = this.className.length();
        if (length > 23) {
            this.className = this.className.substring(length - 23, length);
        }
    }

    public boolean isLevelEnabled(Log.Level level) {
        return android.util.Log.isLoggable((String)this.className, (int)this.levelToJavaLevel(level));
    }

    public void log(Log.Level level, String msg) {
        switch (level) {
            case TRACE: {
                android.util.Log.v((String)this.className, (String)msg);
                break;
            }
            case DEBUG: {
                android.util.Log.d((String)this.className, (String)msg);
                break;
            }
            case INFO: {
                android.util.Log.i((String)this.className, (String)msg);
                break;
            }
            case WARNING: {
                android.util.Log.w((String)this.className, (String)msg);
                break;
            }
            case ERROR: {
                android.util.Log.e((String)this.className, (String)msg);
                break;
            }
            case FATAL: {
                android.util.Log.e((String)this.className, (String)msg);
                break;
            }
            default: {
                android.util.Log.i((String)this.className, (String)msg);
            }
        }
    }

    public void log(Log.Level level, String msg, Throwable t) {
        switch (level) {
            case TRACE: {
                android.util.Log.v((String)this.className, (String)msg, (Throwable)t);
                break;
            }
            case DEBUG: {
                android.util.Log.d((String)this.className, (String)msg, (Throwable)t);
                break;
            }
            case INFO: {
                android.util.Log.i((String)this.className, (String)msg, (Throwable)t);
                break;
            }
            case WARNING: {
                android.util.Log.w((String)this.className, (String)msg, (Throwable)t);
                break;
            }
            case ERROR: {
                android.util.Log.e((String)this.className, (String)msg, (Throwable)t);
                break;
            }
            case FATAL: {
                android.util.Log.e((String)this.className, (String)msg, (Throwable)t);
                break;
            }
            default: {
                android.util.Log.i((String)this.className, (String)msg, (Throwable)t);
            }
        }
    }

    private int levelToJavaLevel(Log.Level level) {
        switch (level) {
            case TRACE: {
                return 2;
            }
            case DEBUG: {
                return 3;
            }
            case INFO: {
                return 4;
            }
            case WARNING: {
                return 5;
            }
            case ERROR: {
                return 6;
            }
            case FATAL: {
                return 6;
            }
        }
        return 4;
    }
}

