/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.j256.ormlite.android.AndroidCompiledStatement;
import com.j256.ormlite.android.AndroidDatabaseResults;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.support.GeneratedKeyHolder;
import java.sql.Savepoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidDatabaseConnection
implements DatabaseConnection {
    private final SQLiteDatabase db;
    private final boolean readWrite;

    public AndroidDatabaseConnection(SQLiteDatabase db, boolean readWrite) {
        this.db = db;
        this.readWrite = readWrite;
    }

    public boolean isAutoCommitSupported() {
        return false;
    }

    public boolean getAutoCommit() throws java.sql.SQLException {
        try {
            return !this.db.inTransaction();
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)"problems getting auto-commit from database", (Throwable)e);
        }
    }

    public void setAutoCommit(boolean autoCommit) {
    }

    public Savepoint setSavePoint(String name) throws java.sql.SQLException {
        try {
            this.db.beginTransaction();
            return null;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)"problems beginning transaction", (Throwable)e);
        }
    }

    public boolean isReadWrite() {
        return this.readWrite;
    }

    public void commit(Savepoint savepoint) throws java.sql.SQLException {
        try {
            this.db.setTransactionSuccessful();
            this.db.endTransaction();
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)"problems commiting transaction", (Throwable)e);
        }
    }

    public void rollback(Savepoint savepoint) throws java.sql.SQLException {
        try {
            this.db.endTransaction();
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)"problems rolling back transaction", (Throwable)e);
        }
    }

    public CompiledStatement compileStatement(String statement, StatementBuilder.StatementType type, FieldType[] argFieldTypes, FieldType[] resultFieldTypes) {
        AndroidCompiledStatement stmt = new AndroidCompiledStatement(statement, this.db, type);
        return stmt;
    }

    public int insert(String statement, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        return this.insert(statement, args, argFieldTypes, null);
    }

    public int insert(String statement, Object[] args, FieldType[] argFieldTypes, GeneratedKeyHolder keyHolder) throws java.sql.SQLException {
        SQLiteStatement stmt = null;
        try {
            stmt = this.db.compileStatement(statement);
            this.bindArgs(stmt, args, argFieldTypes);
            long rowId = stmt.executeInsert();
            if (keyHolder != null) {
                keyHolder.addKey((Number)rowId);
            }
            int n = 1;
            return n;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("inserting to database failed: " + statement), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public int update(String statement, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        SQLiteStatement stmt = null;
        try {
            stmt = this.db.compileStatement(statement);
            this.bindArgs(stmt, args, argFieldTypes);
            stmt.execute();
            int n = 1;
            return n;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("updating database failed: " + statement), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public int delete(String statement, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        return this.update(statement, args, argFieldTypes);
    }

    public <T> Object queryForOne(String statement, Object[] args, FieldType[] argFieldTypes, GenericRowMapper<T> rowMapper) throws java.sql.SQLException {
        Cursor cursor = null;
        try {
            cursor = this.db.rawQuery(statement, this.toStrings(args));
            AndroidDatabaseResults results = new AndroidDatabaseResults(cursor);
            if (!results.next()) {
                Object var7_8 = null;
                return var7_8;
            }
            Object first = rowMapper.mapRow((DatabaseResults)results);
            if (results.next()) {
                Object object = MORE_THAN_ONE;
                return object;
            }
            Object object = first;
            return object;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("queryForOne from database failed: " + statement), (Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public long queryForLong(String statement) throws java.sql.SQLException {
        SQLiteStatement stmt = null;
        try {
            stmt = this.db.compileStatement(statement);
            long l = stmt.simpleQueryForLong();
            return l;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("queryForLong from database failed: " + statement), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public void close() throws java.sql.SQLException {
        try {
            this.db.close();
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)"problems closing the database connection", (Throwable)e);
        }
    }

    public boolean isClosed() throws java.sql.SQLException {
        try {
            return !this.db.isOpen();
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)"problems detecting if the database is closed", (Throwable)e);
        }
    }

    public boolean isTableExists(String tableName) throws java.sql.SQLException {
        return true;
    }

    private void bindArgs(SQLiteStatement stmt, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        if (args == null) {
            return;
        }
        block6: for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) {
                stmt.bindNull(i + 1);
                continue;
            }
            switch (argFieldTypes[i].getSqlType()) {
                case STRING: 
                case LONG_STRING: {
                    stmt.bindString(i + 1, arg.toString());
                    continue block6;
                }
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INTEGER: 
                case LONG: {
                    stmt.bindLong(i + 1, ((Number)arg).longValue());
                    continue block6;
                }
                case FLOAT: 
                case DOUBLE: {
                    stmt.bindDouble(i + 1, ((Number)arg).doubleValue());
                    continue block6;
                }
                case BYTE_ARRAY: 
                case SERIALIZABLE: {
                    stmt.bindBlob(i + 1, (byte[])arg);
                    continue block6;
                }
                default: {
                    throw new java.sql.SQLException("Unknown sql argument type " + argFieldTypes[i].getSqlType());
                }
            }
        }
    }

    private String[] toStrings(Object[] args) {
        if (args == null) {
            return null;
        }
        String[] strings = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            strings[i] = arg == null ? null : arg.toString();
        }
        return strings;
    }
}

