/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.stmt.mapped.BaseMappedStatement;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedUpdateId<T, ID>
extends BaseMappedStatement<T> {
    private MappedUpdateId(TableInfo<T> tableInfo, String statement, List<FieldType> argFieldTypeList) {
        super(tableInfo, statement, argFieldTypeList);
    }

    public int execute(DatabaseConnection databaseConnection, T data, ID newId) throws SQLException {
        Object[] fieldObjects = this.getFieldObjects(this.argFieldTypes, data);
        try {
            Object[] args = new Object[]{newId, fieldObjects[0]};
            int rowC = databaseConnection.update(this.statement, args, this.argSqlTypes);
            if (rowC == 1) {
                this.idField.assignField(data, newId);
            }
            logger.debug("updating-id with statement '{}' and {} args, changed {} rows", this.statement, args.length, rowC);
            if (args.length > 0) {
                logger.trace("updating-id arguments: {}", new Object[]{args});
            }
            return rowC;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Unable to run update-id stmt on object " + data + ": " + this.statement, e);
        }
    }

    public static <T, ID> MappedUpdateId<T, ID> build(DatabaseType databaseType, TableInfo<T> tableInfo) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot update-id in " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<FieldType> argFieldTypeList = new ArrayList<FieldType>();
        MappedUpdateId.appendTableName(databaseType, sb, "UPDATE ", tableInfo.getTableName());
        sb.append("SET ");
        MappedUpdateId.appendFieldColumnName(databaseType, sb, idField, argFieldTypeList);
        sb.append("= ? ");
        MappedUpdateId.appendWhereId(databaseType, idField, sb, argFieldTypeList);
        return new MappedUpdateId<T, ID>(tableInfo, sb.toString(), argFieldTypeList);
    }
}

