/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.query.Clause;
import com.j256.ormlite.stmt.query.SetExpression;
import com.j256.ormlite.stmt.query.SetValue;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateBuilder<T, ID>
extends StatementBuilder<T, ID> {
    private List<Clause> updateClauseList = null;

    public UpdateBuilder(DatabaseType databaseType, TableInfo<T> tableInfo) {
        super(databaseType, tableInfo, StatementBuilder.StatementType.UPDATE);
    }

    public PreparedUpdate<T> prepare() throws SQLException {
        return super.prepareStatement();
    }

    public StatementBuilder<T, ID> updateColumnValue(String columnName, Object value) {
        FieldType fieldType = this.verifyColumnName(columnName);
        this.addUpdateColumnToList(columnName, new SetValue(columnName, fieldType, value));
        return this;
    }

    public StatementBuilder<T, ID> updateColumnExpression(String columnName, String expression) {
        this.addUpdateColumnToList(columnName, new SetExpression(columnName, expression));
        return this;
    }

    public void escapeColumnName(StringBuilder sb, String columnName) {
        this.databaseType.appendEscapedEntityName(sb, columnName);
    }

    public String escapeColumnName(String columnName) {
        StringBuilder sb = new StringBuilder();
        this.databaseType.appendEscapedEntityName(sb, columnName);
        return sb.toString();
    }

    public void escapeValue(StringBuilder sb, String value) {
        this.databaseType.appendEscapedWord(sb, value);
    }

    public String escapeValue(String value) {
        StringBuilder sb = new StringBuilder();
        this.databaseType.appendEscapedWord(sb, value);
        return sb.toString();
    }

    @Override
    protected void appendStatementStart(StringBuilder sb, List<FieldType> resultFieldTypeList) throws SQLException {
        if (this.updateClauseList == null || this.updateClauseList.size() == 0) {
            throw new IllegalArgumentException("UPDATE statements must have at least one SET column");
        }
        sb.append("UPDATE ");
        this.databaseType.appendEscapedEntityName(sb, this.tableInfo.getTableName());
        sb.append(" SET ");
        boolean first = true;
        for (Clause clause : this.updateClauseList) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            clause.appendSql(this.databaseType, sb, null);
        }
    }

    @Override
    protected void appendStatementEnd(StringBuilder sb) {
    }

    private void addUpdateColumnToList(String columnName, Clause clause) {
        this.verifyColumnName(columnName);
        if (this.updateClauseList == null) {
            this.updateClauseList = new ArrayList<Clause>();
        }
        this.updateClauseList.add(clause);
    }
}

