/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.query;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.query.Clause;
import com.j256.ormlite.stmt.query.Comparison;
import com.j256.ormlite.stmt.query.NeedsFutureClause;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Not
implements Clause,
NeedsFutureClause {
    private Comparison comparison = null;

    public Not() {
    }

    public Not(Clause clause) {
        this.setMissingClause(clause);
    }

    @Override
    public void setMissingClause(Clause clause) {
        if (this.comparison != null) {
            throw new IllegalArgumentException("NOT operation already has a comparison set");
        }
        if (!(clause instanceof Comparison)) {
            throw new IllegalArgumentException("NOT operation can only work with comparison SQL clauses, not " + clause);
        }
        this.comparison = (Comparison)clause;
    }

    @Override
    public StringBuilder appendSql(DatabaseType databaseType, StringBuilder sb, List<SelectArg> selectArgList) {
        if (this.comparison == null) {
            throw new IllegalStateException("Comparison has not been set in NOT operation");
        }
        sb.append("(NOT ");
        databaseType.appendEscapedEntityName(sb, this.comparison.getColumnName());
        sb.append(' ');
        this.comparison.appendOperation(sb);
        this.comparison.appendValue(databaseType, sb, selectArgList);
        sb.append(") ");
        return sb;
    }

    public String toString() {
        if (this.comparison == null) {
            return "NOT without comparison";
        }
        return "NOT comparison " + this.comparison;
    }
}

