/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.misc.JavaxPersistence;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseFieldConfig {
    private String fieldName;
    private String columnName;
    private DataType dataType = DataType.UNKNOWN;
    private String defaultValue;
    private int width;
    private boolean canBeNull;
    private boolean id;
    private boolean generatedId;
    private String generatedIdSequence;
    private boolean foreign;
    private DatabaseTableConfig<?> foreignTableConfig;
    private boolean useGetSet;
    private Enum<?> unknownEnumvalue;
    private boolean throwIfNull;
    private String format;

    public DatabaseFieldConfig() {
    }

    public DatabaseFieldConfig(String fieldName, String columnName, DataType dataType, String defaultValue, int width, boolean canBeNull, boolean id, boolean generatedId, String generatedIdSequence, boolean foreign, DatabaseTableConfig<?> foreignTableConfig, boolean useGetSet, Enum<?> unknownEnumValue, boolean throwIfNull, String format) {
        this.fieldName = fieldName;
        this.columnName = columnName;
        this.dataType = dataType;
        this.defaultValue = defaultValue;
        this.width = width;
        this.canBeNull = canBeNull;
        this.id = id;
        this.generatedId = generatedId;
        this.generatedIdSequence = generatedIdSequence;
        this.foreign = foreign;
        this.foreignTableConfig = foreignTableConfig;
        this.useGetSet = useGetSet;
        this.unknownEnumvalue = unknownEnumValue;
        this.throwIfNull = throwIfNull;
        this.format = format;
    }

    @Deprecated
    public DatabaseFieldConfig(String fieldName, String columnName, DataType dataType, String defaultValue, int width, boolean canBeNull, boolean id, boolean generatedId, String generatedIdSequence, boolean foreign, DatabaseTableConfig<?> foreignTableConfig, boolean useGetSet, Enum<?> unknownEnumValue, boolean throwIfNull) {
        this(fieldName, columnName, dataType, defaultValue, width, canBeNull, id, generatedId, generatedIdSequence, foreign, foreignTableConfig, useGetSet, unknownEnumValue, throwIfNull, null);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isCanBeNull() {
        return this.canBeNull;
    }

    public void setCanBeNull(boolean canBeNull) {
        this.canBeNull = canBeNull;
    }

    public boolean isId() {
        return this.id;
    }

    public void setId(boolean id) {
        this.id = id;
    }

    public boolean isGeneratedId() {
        return this.generatedId;
    }

    public void setGeneratedId(boolean generatedId) {
        this.generatedId = generatedId;
    }

    public String getGeneratedIdSequence() {
        return this.generatedIdSequence;
    }

    public void setGeneratedIdSequence(String generatedIdSequence) {
        this.generatedIdSequence = generatedIdSequence;
    }

    public boolean isForeign() {
        return this.foreign;
    }

    public void setForeign(boolean foreign) {
        this.foreign = foreign;
    }

    public DatabaseTableConfig<?> getForeignTableConfig() {
        return this.foreignTableConfig;
    }

    public void setForeignTableConfig(DatabaseTableConfig<?> foreignTableConfig) {
        this.foreignTableConfig = foreignTableConfig;
    }

    public boolean isUseGetSet() {
        return this.useGetSet;
    }

    public void setUseGetSet(boolean useGetSet) {
        this.useGetSet = useGetSet;
    }

    public Enum<?> getUnknownEnumvalue() {
        return this.unknownEnumvalue;
    }

    public void setUnknownEnumvalue(Enum<?> unknownEnumvalue) {
        this.unknownEnumvalue = unknownEnumvalue;
    }

    public boolean isThrowIfNull() {
        return this.throwIfNull;
    }

    public void setThrowIfNull(boolean throwIfNull) {
        this.throwIfNull = throwIfNull;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public static DatabaseFieldConfig fromField(DatabaseType databaseType, Field field) throws SQLException {
        DatabaseField databaseField = field.getAnnotation(DatabaseField.class);
        if (databaseField != null) {
            if (databaseField.persisted()) {
                return DatabaseFieldConfig.fromDatabaseField(databaseType, field, databaseField);
            }
            return null;
        }
        DatabaseFieldConfig config = JavaxPersistence.createFieldConfig(databaseType, field);
        if (config != null) {
            return config;
        }
        return null;
    }

    public static Method findGetMethod(Field field, boolean throwExceptions) {
        Method fieldGetMethod;
        String methodName = DatabaseFieldConfig.methodFromField(field, "get");
        try {
            fieldGetMethod = field.getDeclaringClass().getMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            if (throwExceptions) {
                throw new IllegalArgumentException("Could not find appropriate get method for " + field);
            }
            return null;
        }
        if (fieldGetMethod.getReturnType() != field.getType()) {
            if (throwExceptions) {
                throw new IllegalArgumentException("Return type of get method " + methodName + " does not return " + field.getType());
            }
            return null;
        }
        return fieldGetMethod;
    }

    public static Method findSetMethod(Field field, boolean throwExceptions) {
        Method fieldSetMethod;
        String methodName = DatabaseFieldConfig.methodFromField(field, "set");
        try {
            fieldSetMethod = field.getDeclaringClass().getMethod(methodName, field.getType());
        }
        catch (Exception e) {
            if (throwExceptions) {
                throw new IllegalArgumentException("Could not find appropriate set method for " + field);
            }
            return null;
        }
        if (fieldSetMethod.getReturnType() != Void.TYPE) {
            if (throwExceptions) {
                throw new IllegalArgumentException("Return type of set method " + methodName + " returns " + fieldSetMethod.getReturnType() + " instead of void");
            }
            return null;
        }
        return fieldSetMethod;
    }

    private static DatabaseFieldConfig fromDatabaseField(DatabaseType databaseType, Field field, DatabaseField databaseField) {
        DatabaseFieldConfig config = new DatabaseFieldConfig();
        config.fieldName = field.getName();
        if (databaseType.isEntityNamesMustBeUpCase()) {
            config.fieldName = config.fieldName.toUpperCase();
        }
        config.columnName = databaseField.columnName().length() > 0 ? databaseField.columnName() : null;
        config.dataType = databaseField.dataType();
        config.defaultValue = databaseField.defaultValue().length() > 0 ? databaseField.defaultValue() : null;
        config.width = databaseField.width();
        config.canBeNull = databaseField.canBeNull();
        config.id = databaseField.id();
        config.generatedId = databaseField.generatedId();
        config.generatedIdSequence = databaseField.generatedIdSequence().length() > 0 ? databaseField.generatedIdSequence() : null;
        config.foreign = databaseField.foreign();
        config.useGetSet = databaseField.useGetSet();
        config.unknownEnumvalue = databaseField.unknownEnumName().length() > 0 ? DatabaseFieldConfig.findMatchingEnumVal(field, databaseField.unknownEnumName()) : null;
        config.throwIfNull = databaseField.throwIfNull();
        config.format = databaseField.format().length() > 0 ? databaseField.format() : null;
        return config;
    }

    private static String methodFromField(Field field, String prefix) {
        return prefix + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
    }

    private static Enum<?> findMatchingEnumVal(Field field, String unknownEnumName) {
        for (Enum enumVal : (Enum[])field.getType().getEnumConstants()) {
            if (!enumVal.name().equals(unknownEnumName)) continue;
            return enumVal;
        }
        throw new IllegalArgumentException("Unknwown enum unknown name " + unknownEnumName + " for field " + field);
    }
}

