/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.xml.XMLUtil;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.net.ImageRetrieve;
import com.itextpdf.tool.xml.net.exc.NoImageException;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.pipeline.html.NoImageProviderException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Image
extends AbstractTagProcessor {
    private final CssUtils utils = CssUtils.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(Image.class);

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        Map<String, String> attributes = tag.getAttributes();
        String src = attributes.get("src");
        com.itextpdf.text.Image img = null;
        ArrayList<Element> l = new ArrayList<Element>(1);
        if (null != src && src.length() > 0) {
            src = XMLUtil.unescapeXML((String)src);
            src = src.trim();
            try {
                if (logger.isLogging(Level.TRACE)) {
                    logger.trace(String.format(LocaleMessages.getInstance().getMessage("html.tag.img.try"), src));
                }
                try {
                    img = new ImageRetrieve(this.getHtmlPipelineContext(ctx).getImageProvider()).retrieveImage(src);
                }
                catch (NoImageProviderException e) {
                    img = new ImageRetrieve().retrieveImage(src);
                }
            }
            catch (IOException e) {
                if (logger.isLogging(Level.ERROR)) {
                    logger.error(String.format(LocaleMessages.getInstance().getMessage("html.tag.img.failedretrieve"), src), (Exception)e);
                }
            }
            catch (NoImageException e) {
                if (logger.isLogging(Level.ERROR)) {
                    logger.error("", (Exception)e);
                }
            }
            catch (NoCustomContextException e) {
                throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
            }
            if (null != img) {
                try {
                    HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
                    l.add(this.getCssAppliers().apply((Element)new Chunk((com.itextpdf.text.Image)this.getCssAppliers().apply((Element)img, tag, htmlPipelineContext), 0.0f, 0.0f, true), tag, htmlPipelineContext));
                }
                catch (NoCustomContextException e) {
                    throw new RuntimeWorkerException(e);
                }
            }
        }
        return l;
    }

    @Override
    public boolean isStackOwner() {
        return false;
    }
}

