/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.text.pdf.PdfDiv;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.css.apply.MarginMemory;
import com.itextpdf.tool.xml.css.apply.PageSizeContainable;
import java.util.Map;

public class DivCssApplier {
    private final CssUtils utils = CssUtils.getInstance();

    public PdfDiv apply(PdfDiv div, Tag t, MarginMemory memory, PageSizeContainable psc) {
        String heightValue;
        String widthValue;
        Map<String, String> css = t.getCSS();
        float fontSize = FontSizeTranslator.getInstance().translateFontSize(t);
        if (fontSize == -1.0f) {
            fontSize = 12.0f;
        }
        String align = null;
        if (t.getAttributes().containsKey("align")) {
            align = t.getAttributes().get("align");
        } else if (css.containsKey("text-align")) {
            align = css.get("text-align");
        }
        if (align != null) {
            if (align.equalsIgnoreCase("center")) {
                div.setTextAlignment(1);
            } else if (align.equalsIgnoreCase("right")) {
                div.setTextAlignment(2);
            } else if (align.equalsIgnoreCase("justify")) {
                div.setTextAlignment(3);
            }
        }
        if ((widthValue = t.getCSS().get("width")) == null) {
            widthValue = t.getAttributes().get("width");
        }
        if (widthValue != null) {
            if (this.utils.isNumericValue(widthValue) || this.utils.isMetricValue(widthValue)) {
                div.setWidth(Float.valueOf(this.utils.parsePxInCmMmPcToPt(widthValue)));
            } else if (this.utils.isRelativeValue(widthValue)) {
                if (widthValue.contains("%")) {
                    div.setPercentageWidth(Float.valueOf(this.utils.parseRelativeValue(widthValue, 1.0f)));
                } else {
                    div.setWidth(Float.valueOf(this.utils.parseRelativeValue(widthValue, fontSize)));
                }
            }
        }
        if ((heightValue = t.getCSS().get("height")) == null) {
            heightValue = t.getAttributes().get("height");
        }
        if (heightValue != null) {
            if (this.utils.isNumericValue(heightValue) || this.utils.isMetricValue(heightValue)) {
                div.setHeight(Float.valueOf(this.utils.parsePxInCmMmPcToPt(heightValue)));
            } else if (this.utils.isRelativeValue(heightValue)) {
                if (heightValue.contains("%")) {
                    div.setPercentageHeight(Float.valueOf(this.utils.parseRelativeValue(heightValue, 1.0f)));
                } else {
                    div.setHeight(Float.valueOf(this.utils.parseRelativeValue(heightValue, fontSize)));
                }
            }
        }
        Float marginTop = null;
        Float marginBottom = null;
        for (Map.Entry<String, String> entry : css.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equalsIgnoreCase("left")) {
                div.setLeft(Float.valueOf(this.utils.parseValueToPt(value, fontSize)));
                continue;
            }
            if (key.equalsIgnoreCase("right")) {
                if (div.getWidth() != null && div.getLeft() != null) continue;
                div.setRight(Float.valueOf(this.utils.parseValueToPt(value, fontSize)));
                continue;
            }
            if (key.equalsIgnoreCase("top")) {
                div.setTop(Float.valueOf(this.utils.parseValueToPt(value, fontSize)));
                continue;
            }
            if (key.equalsIgnoreCase("bottom")) {
                if (div.getHeight() != null && div.getTop() != null) continue;
                div.setBottom(Float.valueOf(this.utils.parseValueToPt(value, fontSize)));
                continue;
            }
            if (key.equalsIgnoreCase("background-color")) {
                div.setBackgroundColor(HtmlUtilities.decodeColor((String)value));
                continue;
            }
            if (key.equalsIgnoreCase("padding-left")) {
                div.setPaddingLeft(this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if (key.equalsIgnoreCase("padding-right")) {
                div.setPaddingRight(this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if (key.equalsIgnoreCase("padding-top")) {
                div.setPaddingTop(this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if (key.equalsIgnoreCase("padding-bottom")) {
                div.setPaddingBottom(this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if (key.equalsIgnoreCase("margin-top")) {
                marginTop = Float.valueOf(this.utils.calculateMarginTop(value, fontSize, memory));
                continue;
            }
            if (key.equalsIgnoreCase("margin-bottom")) {
                marginBottom = Float.valueOf(this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if (key.equalsIgnoreCase("float")) {
                if (value.equalsIgnoreCase("left")) {
                    div.setFloatType(PdfDiv.FloatType.LEFT);
                    continue;
                }
                if (!value.equalsIgnoreCase("right")) continue;
                div.setFloatType(PdfDiv.FloatType.RIGHT);
                continue;
            }
            if (!key.equalsIgnoreCase("position")) continue;
            if (value.equalsIgnoreCase("absolute")) {
                div.setPosition(PdfDiv.PositionType.ABSOLUTE);
                continue;
            }
            if (value.equalsIgnoreCase("fixed")) {
                div.setPosition(PdfDiv.PositionType.FIXED);
                continue;
            }
            if (!value.equalsIgnoreCase("relative")) continue;
            div.setPosition(PdfDiv.PositionType.RELATIVE);
        }
        return div;
    }
}

