/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.css.apply.MarginMemory;
import com.itextpdf.tool.xml.html.CssAppliers;
import java.util.Map;

public class ParagraphCssApplier {
    private final CssAppliers appliers;

    public ParagraphCssApplier(CssAppliers appliers) {
        this.appliers = appliers;
    }

    public Paragraph apply(Paragraph p, Tag t, MarginMemory configuration) {
        CssUtils utils = CssUtils.getInstance();
        float fontSize = FontSizeTranslator.getInstance().getFontSize(t);
        float lmb = 0.0f;
        boolean hasLMB = false;
        Map<String, String> css = t.getCSS();
        for (Map.Entry<String, String> entry : css.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("margin-top".equalsIgnoreCase(key)) {
                p.setSpacingBefore(p.getSpacingBefore() + utils.calculateMarginTop(value, fontSize, configuration));
                continue;
            }
            if ("padding-top".equalsIgnoreCase(key)) {
                p.setSpacingBefore(p.getSpacingBefore() + utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("margin-bottom".equalsIgnoreCase(key)) {
                float after = utils.parseValueToPt(value, fontSize);
                p.setSpacingAfter(p.getSpacingAfter() + after);
                lmb = after;
                hasLMB = true;
                continue;
            }
            if ("padding-bottom".equalsIgnoreCase(key)) {
                p.setSpacingAfter(p.getSpacingAfter() + utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("margin-left".equalsIgnoreCase(key)) {
                p.setIndentationLeft(p.getIndentationLeft() + utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("margin-right".equalsIgnoreCase(key)) {
                p.setIndentationRight(p.getIndentationRight() + utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("padding-left".equalsIgnoreCase(key)) {
                p.setIndentationLeft(p.getIndentationLeft() + utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("padding-right".equalsIgnoreCase(key)) {
                p.setIndentationRight(p.getIndentationRight() + utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("text-align".equalsIgnoreCase(key)) {
                if ("right".equalsIgnoreCase(value)) {
                    p.setAlignment(2);
                    continue;
                }
                if ("center".equalsIgnoreCase(value)) {
                    p.setAlignment(1);
                    continue;
                }
                if ("left".equalsIgnoreCase(value)) {
                    p.setAlignment(0);
                    continue;
                }
                if (!"justify".equalsIgnoreCase(value)) continue;
                p.setAlignment(3);
                continue;
            }
            if ("text-indent".equalsIgnoreCase(key)) {
                p.setFirstLineIndent(utils.parseValueToPt(value, fontSize));
                continue;
            }
            if (!"line-height".equalsIgnoreCase(key)) continue;
            if (utils.isNumericValue(value)) {
                p.setLeading(Float.parseFloat(value) * fontSize);
                continue;
            }
            if (utils.isRelativeValue(value)) {
                p.setLeading(utils.parseRelativeValue(value, fontSize));
                continue;
            }
            if (!utils.isMetricValue(value)) continue;
            p.setLeading(utils.parsePxInCmMmPcToPt(value));
        }
        if (hasLMB) {
            configuration.setLastMarginBottom(Float.valueOf(lmb));
        }
        Font font = this.appliers.getChunkCssAplier().applyFontStyles(t);
        p.setFont(font);
        return p;
    }
}

