/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.WritableDirectElement;
import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.apply.ChunkCssApplier;
import com.itextpdf.tool.xml.css.apply.NoNewLineParagraphCssApplier;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.html.HTMLUtils;
import com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Anchor
extends AbstractTagProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Anchor.class);

    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        String sanitized = HTMLUtils.sanitizeInline(content);
        ArrayList<Element> l = new ArrayList<Element>(1);
        if (sanitized.length() > 0) {
            l.add((Element)new ChunkCssApplier().apply(new Chunk(sanitized), tag));
        }
        return l;
    }

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        try {
            final String name = tag.getAttributes().get("name");
            ArrayList<Element> elems = new ArrayList<Element>(0);
            if (currentContent.size() > 0) {
                NoNewLineParagraph p = new NoNewLineParagraph();
                String url = tag.getAttributes().get("href");
                for (Element e : currentContent) {
                    if (e instanceof Chunk) {
                        if (null != url) {
                            if (url.startsWith("#")) {
                                if (LOGGER.isLogging(Level.TRACE)) {
                                    LOGGER.trace(String.format(LocaleMessages.getInstance().getMessage("html.tag.a.local"), url));
                                }
                                ((Chunk)e).setLocalGoto(url.replaceFirst("#", ""));
                            } else {
                                if (null != this.getHtmlPipelineContext(ctx).getLinkProvider() && !url.startsWith("http")) {
                                    String root = this.getHtmlPipelineContext(ctx).getLinkProvider().getLinkRoot();
                                    if (root.endsWith("/") && url.startsWith("/")) {
                                        root = root.substring(0, root.length() - 1);
                                    }
                                    url = root + url;
                                }
                                if (LOGGER.isLogging(Level.TRACE)) {
                                    LOGGER.trace(String.format(LocaleMessages.getInstance().getMessage("html.tag.a.external"), url));
                                }
                                ((Chunk)e).setAnchor(url);
                            }
                        } else if (null != name) {
                            ((Chunk)e).setLocalDestination(name);
                            if (LOGGER.isLogging(Level.TRACE)) {
                                LOGGER.trace(String.format(LocaleMessages.getInstance().getMessage("html.tag.a.setlocal"), name));
                            }
                        }
                    }
                    p.add(e);
                }
                elems.add((Element)new NoNewLineParagraphCssApplier(this.getHtmlPipelineContext(ctx)).apply(p, tag));
            } else if (null != name) {
                if (LOGGER.isLogging(Level.TRACE)) {
                    LOGGER.trace(String.format(LocaleMessages.getInstance().getMessage("html.tag.a.spacehack"), name));
                }
                elems.add((Element)new WritableDirectElement(){

                    public void write(PdfWriter writer, Document doc) throws DocumentException {
                        ColumnText c = new ColumnText(writer.getDirectContent());
                        float verticalPosition = writer.getVerticalPosition(false);
                        c.setSimpleColumn(new Phrase(new Chunk(" ").setLocalDestination(name)), 1.0f, verticalPosition - 5.0f, 6.0f, verticalPosition, 5.0f, 0);
                        try {
                            c.go();
                        }
                        catch (DocumentException e) {
                            throw new RuntimeWorkerException(e);
                        }
                    }
                });
            }
            return elems;
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
        }
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }
}

