/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssApplier;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkCssApplier
implements CssApplier<Chunk> {
    public static final List<String> BOLD = Arrays.asList("bold", "bolder", "600", "700", "800", "900");
    private final CssUtils utils = CssUtils.getInstance();

    @Override
    public Chunk apply(Chunk c, Tag t) {
        String xfaVertScale;
        String fontName = "Helvetica";
        String encoding = "Cp1252";
        float size = new FontSizeTranslator().getFontSize(t);
        int style = 0;
        BaseColor color = BaseColor.BLACK;
        Map<String, String> rules = t.getCSS();
        block0: for (Map.Entry<String, String> entry : rules.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("font-weight".equalsIgnoreCase(key) && "bold".contains(value)) {
                if (style == 2) {
                    style = 3;
                    continue;
                }
                style = 1;
                continue;
            }
            if ("font-style".equalsIgnoreCase(key)) {
                if (value.equalsIgnoreCase("italic")) {
                    style = style == 1 ? 3 : 2;
                }
                if (!value.equalsIgnoreCase("oblique")) continue;
                c.setSkew(0.0f, 12.0f);
                continue;
            }
            if ("font-family".equalsIgnoreCase(key)) {
                if (value.contains(",")) {
                    String[] fonts;
                    for (String s : fonts = value.split(",")) {
                        if (FontFactory.getFont((String)(s = s.trim())).getFamilyname().equalsIgnoreCase("unknown")) continue;
                        fontName = s;
                        continue block0;
                    }
                    continue;
                }
                fontName = value;
                continue;
            }
            if ("color".equalsIgnoreCase(key)) {
                color = HtmlUtilities.decodeColor((String)value);
                continue;
            }
            if ("letter-spacing".equalsIgnoreCase(key)) {
                c.setCharacterSpacing(this.utils.parsePxInCmMmPcToPt(value));
                continue;
            }
            if (null == rules.get("xfa-font-horizontal-scale")) continue;
            c.setHorizontalScaling(Float.parseFloat(rules.get("xfa-font-horizontal-scale").replace("%", "")) / 100.0f);
        }
        if (null != rules.get("vertical-align")) {
            String value = rules.get("vertical-align");
            if (value.equalsIgnoreCase("super") || value.equalsIgnoreCase("top") || value.equalsIgnoreCase("text-top")) {
                c.setTextRise((float)((double)(size / 2.0f) + 0.5));
            } else if (value.equalsIgnoreCase("sub") || value.equalsIgnoreCase("bottom") || value.equalsIgnoreCase("text-bottom")) {
                c.setTextRise(-size / 2.0f);
            } else {
                c.setTextRise(this.utils.parsePxInCmMmPcToPt(value));
            }
        }
        if (null != (xfaVertScale = rules.get("xfa-font-vertical-scale")) && xfaVertScale.contains("%")) {
            size *= Float.parseFloat(xfaVertScale.replace("%", "")) / 100.0f;
            c.setHorizontalScaling(100.0f / Float.parseFloat(xfaVertScale.replace("%", "")));
        }
        if (null != rules.get("text-decoration")) {
            String value = rules.get("text-decoration");
            if ("underline".equalsIgnoreCase(value)) {
                c.setUnderline(0.75f, -size / 8.0f);
            }
            if ("line-through".equalsIgnoreCase(value)) {
                c.setUnderline(0.75f, size / 4.0f);
            }
        }
        if (null != rules.get("background-color")) {
            c.setBackground(HtmlUtilities.decodeColor((String)rules.get("background-color")));
        }
        Font f = FontFactory.getFont((String)fontName, (String)encoding, (boolean)true, (float)size, (int)style, (BaseColor)color);
        c.setFont(f);
        return c;
    }

    public float getWidestWord(Chunk c) {
        String[] words = c.getContent().split("\\s");
        float widestWord = 0.0f;
        for (int i = 0; i < words.length; ++i) {
            Chunk word = new Chunk(words[i]);
            this.copyChunkStyles(c, word);
            if (!(word.getWidthPoint() > widestWord)) continue;
            widestWord = word.getWidthPoint();
        }
        return widestWord;
    }

    public void copyChunkStyles(Chunk source, Chunk target) {
        target.setFont(source.getFont());
        target.setAttributes(source.getAttributes());
        target.setCharacterSpacing(source.getCharacterSpacing());
        target.setHorizontalScaling(source.getHorizontalScaling());
        target.setHorizontalScaling(source.getHorizontalScaling());
    }
}

