/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.pipeline.html;

import com.itextpdf.text.Element;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.NoTagProcessorException;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.TagProcessor;
import com.itextpdf.tool.xml.pipeline.AbstractPipeline;
import com.itextpdf.tool.xml.pipeline.WritableElement;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.pipeline.html.NoStackException;
import com.itextpdf.tool.xml.pipeline.html.StackKeeper;
import java.io.UnsupportedEncodingException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlPipeline
extends AbstractPipeline<HtmlPipelineContext> {
    private final HtmlPipelineContext hpc;

    public HtmlPipeline(HtmlPipelineContext hpc, Pipeline<?> next) {
        super(next);
        this.hpc = hpc;
    }

    @Override
    public Pipeline<?> open(Tag t, ProcessObject po) throws PipelineException {
        block8: {
            HtmlPipelineContext hcc = (HtmlPipelineContext)this.getLocalContext();
            try {
                List<Element> content;
                TagProcessor tp = hcc.resolveProcessor(t.getTag(), t.getNameSpace());
                if (tp.isStackOwner()) {
                    hcc.addFirst(new StackKeeper(t));
                }
                if ((content = tp.startElement(t)).size() <= 0) break block8;
                if (tp.isStackOwner()) {
                    try {
                        StackKeeper peek = hcc.peek();
                        for (Element elem : content) {
                            peek.add(elem);
                        }
                        break block8;
                    }
                    catch (NoStackException e) {
                        throw new PipelineException(String.format("pipeline.html.missingstack", t.toString()), e);
                    }
                }
                for (Element elem : content) {
                    hcc.currentContent().add(elem);
                }
            }
            catch (NoTagProcessorException e) {
                if (hcc.acceptUnknown()) break block8;
                throw e;
            }
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> content(Tag t, byte[] b, ProcessObject po) throws PipelineException {
        block10: {
            HtmlPipelineContext hcc = (HtmlPipelineContext)this.getLocalContext();
            try {
                TagProcessor tp = hcc.resolveProcessor(t.getTag(), t.getNameSpace());
                String ctn = null;
                if (null != hcc.charSet()) {
                    try {
                        ctn = new String(b, hcc.charSet().name());
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("unsupported.charset"), e);
                    }
                } else {
                    ctn = new String(b);
                }
                List<Element> elems = tp.content(t, ctn);
                if (elems.size() <= 0) break block10;
                try {
                    StackKeeper peek = hcc.peek();
                    for (Element e : elems) {
                        peek.add(e);
                    }
                }
                catch (NoStackException e) {
                    WritableElement writableElement = new WritableElement();
                    for (Element elem : elems) {
                        writableElement.add(elem);
                    }
                    po.add(writableElement);
                }
            }
            catch (NoTagProcessorException e) {
                if (hcc.acceptUnknown()) break block10;
                throw e;
            }
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> close(Tag t, ProcessObject po) throws PipelineException {
        block9: {
            HtmlPipelineContext hcc = (HtmlPipelineContext)this.getLocalContext();
            try {
                TagProcessor tp = hcc.resolveProcessor(t.getTag(), t.getNameSpace());
                List<Element> elems = null;
                if (tp.isStackOwner()) {
                    StackKeeper tagStack;
                    try {
                        tagStack = hcc.poll();
                    }
                    catch (NoStackException e) {
                        throw new PipelineException(String.format(LocaleMessages.getInstance().getMessage("pipeline.html.missingstack"), t.toString()), e);
                    }
                    elems = tp.endElement(t, tagStack.getElements());
                } else {
                    elems = tp.endElement(t, hcc.currentContent());
                    hcc.currentContent().clear();
                }
                if (elems.size() <= 0) break block9;
                try {
                    StackKeeper stack = hcc.peek();
                    for (Element elem : elems) {
                        stack.add(elem);
                    }
                }
                catch (NoStackException e) {
                    WritableElement writableElement = new WritableElement();
                    po.add(writableElement);
                    writableElement.addAll(elems);
                }
            }
            catch (NoTagProcessorException e) {
                if (hcc.acceptUnknown()) break block9;
                throw e;
            }
        }
        return this.getNext();
    }

    @Override
    public HtmlPipelineContext getNewCustomContext() throws NoCustomContextException {
        try {
            HtmlPipelineContext clone = this.hpc.clone();
            clone.setContext(this.getContext());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            String message = String.format(LocaleMessages.getInstance().getMessage("unsupported.clone"), this.hpc.getClass().toString());
            throw new RuntimeWorkerException(message, e);
        }
    }
}

