/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.GreekList;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.RomanList;
import com.itextpdf.text.ZapfDingbatsList;
import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.net.ImageRetrieve;
import com.itextpdf.tool.xml.net.exc.NoImageException;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.pipeline.html.NoImageProviderException;
import java.io.IOException;
import java.util.Map;

public class ListStyleTypeCssApplier {
    private final CssUtils utils = CssUtils.getInstance();
    private static final Logger LOG = LoggerFactory.getLogger(ListStyleTypeCssApplier.class);

    public List apply(List list, Tag t, HtmlPipelineContext htmlPipelineContext) {
        float fontSize = FontSizeTranslator.getInstance().getFontSize(t);
        List lst = list;
        Map<String, String> css = t.getCSS();
        String styleType = css.get("list-style-type");
        if (null != styleType) {
            if (styleType.equalsIgnoreCase("none")) {
                lst.setLettered(false);
                lst.setNumbered(false);
                lst.setListSymbol("");
            } else if ("decimal".equalsIgnoreCase(styleType)) {
                lst = new List(true);
                this.synchronizeSymbol(fontSize, lst);
            } else if ("disc".equalsIgnoreCase(styleType)) {
                lst = new ZapfDingbatsList(108);
                this.shrinkSymbol(lst, fontSize);
            } else if ("square".equalsIgnoreCase(styleType)) {
                lst = new ZapfDingbatsList(110);
                this.shrinkSymbol(lst, fontSize);
            } else if ("circle".equalsIgnoreCase(styleType)) {
                lst = new ZapfDingbatsList(109);
                this.shrinkSymbol(lst, fontSize);
            } else if ("lower-roman".equals(styleType)) {
                lst = new RomanList(true, 0);
                this.synchronizeSymbol(fontSize, lst);
            } else if ("upper-roman".equals(styleType)) {
                lst = new RomanList(false, 0);
                this.synchronizeSymbol(fontSize, lst);
            } else if ("lower-greek".equals(styleType)) {
                lst = new GreekList(true, 0);
                this.synchronizeSymbol(fontSize, lst);
            } else if ("upper-greek".equals(styleType)) {
                lst = new GreekList(false, 0);
                this.synchronizeSymbol(fontSize, lst);
            } else if ("lower-alpha".equals(styleType) || "lower-latin".equals(styleType)) {
                lst = new List(true, true);
                this.synchronizeSymbol(fontSize, lst);
                lst.setLowercase(true);
            } else if ("upper-alpha".equals(styleType) || "upper-latin".equals(styleType)) {
                lst = new List(true, true);
                this.synchronizeSymbol(fontSize, lst);
                lst.setLowercase(false);
            }
        } else if (t.getTag().equalsIgnoreCase("ol")) {
            lst = new List(true);
            this.synchronizeSymbol(fontSize, lst);
        } else if (t.getTag().equalsIgnoreCase("ul")) {
            lst = new List(false);
            this.shrinkSymbol(lst, fontSize);
        }
        if (null != css.get("list-style-image") && !css.get("list-style-image").equalsIgnoreCase("none")) {
            lst = new List();
            String url = this.utils.extractUrl(css.get("list-style-image"));
            Image img = null;
            try {
                if (htmlPipelineContext == null) {
                    img = new ImageRetrieve().retrieveImage(url);
                } else {
                    try {
                        img = new ImageRetrieve(htmlPipelineContext.getImageProvider()).retrieveImage(url);
                    }
                    catch (NoImageProviderException e) {
                        if (LOG.isLogging(Level.TRACE)) {
                            LOG.trace(String.format(LocaleMessages.getInstance().getMessage("pipeline.html.noimageprovider"), htmlPipelineContext.getClass().getName()));
                        }
                        img = new ImageRetrieve().retrieveImage(url);
                    }
                }
                lst.setListSymbol(new Chunk(img, 0.0f, 0.0f, false));
                lst.setSymbolIndent(img.getWidth());
                if (LOG.isLogging(Level.TRACE)) {
                    LOG.trace(String.format(LocaleMessages.getInstance().getMessage("html.tag.list"), url));
                }
            }
            catch (IOException e) {
                if (LOG.isLogging(Level.ERROR)) {
                    LOG.error(String.format(LocaleMessages.getInstance().getMessage("html.tag.list.failed"), url), (Exception)e);
                }
                lst = new List(false);
            }
            catch (NoImageException e) {
                if (LOG.isLogging(Level.ERROR)) {
                    LOG.error(e.getLocalizedMessage(), (Exception)e);
                }
                lst = new List(false);
            }
        }
        lst.setAlignindent(false);
        lst.setAutoindent(false);
        float leftIndent = 0.0f;
        leftIndent = null != css.get("list-style-position") && css.get("list-style-position").equalsIgnoreCase("inside") ? (leftIndent += 30.0f) : (leftIndent += 15.0f);
        leftIndent += css.get("margin-left") != null ? this.utils.parseValueToPt(css.get("margin-left"), fontSize) : 0.0f;
        lst.setIndentationLeft(leftIndent += css.get("padding-left") != null ? this.utils.parseValueToPt(css.get("padding-left"), fontSize) : 0.0f);
        return lst;
    }

    private void synchronizeSymbol(float fontSize, List lst) {
        lst.getSymbol().getFont().setSize(fontSize);
        lst.setSymbolIndent(fontSize);
    }

    private void shrinkSymbol(List lst, float fontSize) {
        lst.setSymbolIndent(12.0f);
        Chunk symbol = lst.getSymbol();
        symbol.setTextRise(2.0f);
        symbol.getFont().setSize(7.0f);
    }
}

