/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssFile;
import com.itextpdf.tool.xml.css.CssFileProcessor;
import com.itextpdf.tool.xml.css.CssFiles;
import com.itextpdf.tool.xml.css.CssFilesImpl;
import com.itextpdf.tool.xml.css.CssInheritanceRules;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.DefaultCssInheritanceRules;
import com.itextpdf.tool.xml.exceptions.CssResolverException;
import com.itextpdf.tool.xml.net.FileRetrieve;
import com.itextpdf.tool.xml.net.FileRetrieveImpl;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleAttrCSSResolver
implements CSSResolver {
    public static final String STYLE = "style";
    private final CssUtils utils;
    private CssInheritanceRules inherit;
    private final CssFiles cssFiles;
    private FileRetrieve retrieve;

    public StyleAttrCSSResolver() {
        this((CssFiles)new CssFilesImpl(), CssUtils.getInstance());
    }

    public StyleAttrCSSResolver(CssFiles cssFiles) {
        this(cssFiles, CssUtils.getInstance());
    }

    public StyleAttrCSSResolver(CssFiles cssFiles, CssUtils utils) {
        this(new DefaultCssInheritanceRules(), cssFiles, utils);
    }

    public StyleAttrCSSResolver(CssInheritanceRules rules, CssFiles cssFiles, CssUtils utils) {
        this(rules, cssFiles, utils, new FileRetrieveImpl());
    }

    public StyleAttrCSSResolver(CssInheritanceRules rules, CssFiles cssFiles, CssUtils utils, FileRetrieve fileRetrieve) {
        this.utils = utils;
        this.cssFiles = cssFiles;
        this.inherit = rules;
        this.retrieve = fileRetrieve;
    }

    public StyleAttrCSSResolver(CssFiles cssFiles, FileRetrieve r) {
        this(new DefaultCssInheritanceRules(), cssFiles, CssUtils.getInstance(), r);
    }

    @Override
    public void resolveStyles(Tag t) {
        Map<Object, Object> tagCss = new HashMap();
        if (null != this.cssFiles && this.cssFiles.hasFiles()) {
            tagCss = this.cssFiles.getCSS(t);
        }
        if (null != t.getAttributes() && !t.getAttributes().isEmpty()) {
            String styleAtt;
            if (t.getAttributes().get("cellpadding") != null) {
                tagCss.putAll(this.utils.parseBoxValues(t.getAttributes().get("cellpadding"), "cellpadding-", ""));
            }
            if (t.getAttributes().get("cellspacing") != null) {
                tagCss.putAll(this.utils.parseBoxValues(t.getAttributes().get("cellspacing"), "cellspacing-", ""));
            }
            if (null != (styleAtt = t.getAttributes().get(STYLE)) && styleAtt.length() > 0) {
                String[] styles;
                for (String s : styles = styleAtt.split(";")) {
                    String[] part = s.split(":", 2);
                    if (part.length != 2) continue;
                    String key = part[0].trim();
                    String value = this.utils.stripDoubleSpacesAndTrim(part[1]);
                    this.splitRules(tagCss, key, value);
                }
            }
        }
        Map<String, String> css = t.getCSS();
        if (this.mustInherit(t.getTag()) && null != t.getParent() && null != t.getParent().getCSS()) {
            if (null != this.inherit) {
                for (Map.Entry<Object, Object> entry : t.getParent().getCSS().entrySet()) {
                    String key = (String)entry.getKey();
                    if ((!tagCss.containsKey(key) || !"inherit".equals(tagCss.get(key))) && !this.canInherite(t, key)) continue;
                    css.put(key, (String)entry.getValue());
                }
            } else {
                css.putAll(t.getParent().getCSS());
            }
        }
        for (Map.Entry<Object, Object> entry : tagCss.entrySet()) {
            if ("inherit".equalsIgnoreCase((String)entry.getValue())) continue;
            css.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void splitRules(Map<String, String> css, String key, String value) {
        if ("border".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBorder(value));
        } else if ("margin".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBoxValues(value, "margin-", ""));
        } else if ("border-width".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBoxValues(value, "border-", "-width"));
        } else if ("border-style".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBoxValues(value, "border-", "-style"));
        } else if ("border-color".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBoxValues(value, "border-", "-color"));
        } else if ("padding".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBoxValues(value, "padding-", ""));
        } else if ("font".equalsIgnoreCase(key)) {
            css.putAll(this.utils.processFont(value));
        } else if ("list-style".equalsIgnoreCase(key)) {
            css.putAll(this.utils.processListStyle(value));
        } else {
            css.put(key, value);
        }
    }

    public void setCssInheritance(CssInheritanceRules cssInheritanceRules) {
        this.inherit = cssInheritanceRules;
    }

    private boolean canInherite(Tag t, String property) {
        if (null != this.inherit) {
            return this.inherit.inheritCssSelector(t, property);
        }
        return true;
    }

    private boolean mustInherit(String tag) {
        if (null != this.inherit) {
            return this.inherit.inheritCssTag(tag);
        }
        return true;
    }

    @Override
    public void addCss(String content, String charSet) throws CssResolverException {
        CssFileProcessor proc = new CssFileProcessor();
        try {
            this.retrieve.processFromStream(new ByteArrayInputStream(content.getBytes(charSet)), proc);
            this.cssFiles.add(proc.getCss());
        }
        catch (UnsupportedEncodingException e) {
            throw new CssResolverException(e);
        }
        catch (IOException e) {
            throw new CssResolverException(e);
        }
    }

    @Override
    public void addCssFile(String href) throws CssResolverException {
        CssFileProcessor cssFileProcessor = new CssFileProcessor();
        try {
            this.retrieve.processFromHref(href, cssFileProcessor);
        }
        catch (IOException e) {
            throw new CssResolverException(e);
        }
        this.cssFiles.add(cssFileProcessor.getCss());
    }

    @Override
    public void addCss(CssFile file) {
        this.cssFiles.add(file);
    }

    @Override
    public void addCss(String content) throws CssResolverException {
        CssFileProcessor proc = new CssFileProcessor();
        FileRetrieveImpl retrieve = new FileRetrieveImpl();
        try {
            retrieve.processFromStream(new ByteArrayInputStream(content.getBytes()), proc);
            this.cssFiles.add(proc.getCss());
        }
        catch (UnsupportedEncodingException e) {
            throw new CssResolverException(e);
        }
        catch (IOException e) {
            throw new CssResolverException(e);
        }
    }

    public void setCssInheritanceRules(CssInheritanceRules inherit) {
        this.inherit = inherit;
    }

    public void setFileRetrieve(FileRetrieve retrieve) {
        this.retrieve = retrieve;
    }
}

