/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.node.impl.jsoup;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.styledxmlparser.IXmlParser;
import com.itextpdf.styledxmlparser.jsoup.Jsoup;
import com.itextpdf.styledxmlparser.jsoup.nodes.Comment;
import com.itextpdf.styledxmlparser.jsoup.nodes.DataNode;
import com.itextpdf.styledxmlparser.jsoup.nodes.Document;
import com.itextpdf.styledxmlparser.jsoup.nodes.DocumentType;
import com.itextpdf.styledxmlparser.jsoup.nodes.Element;
import com.itextpdf.styledxmlparser.jsoup.nodes.Node;
import com.itextpdf.styledxmlparser.jsoup.nodes.TextNode;
import com.itextpdf.styledxmlparser.node.IDocumentNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupDataNode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupDocumentNode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupDocumentTypeNode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupElementNode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupNode;
import com.itextpdf.styledxmlparser.node.impl.jsoup.node.JsoupTextNode;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsoupXmlParser
implements IXmlParser {
    private static Logger logger = LoggerFactory.getLogger(JsoupXmlParser.class);

    @Override
    public IDocumentNode parse(InputStream xmlStream, String charset) throws IOException {
        String baseUri = "";
        Document doc = Jsoup.parseXML(xmlStream, charset, baseUri);
        INode result = this.wrapJsoupHierarchy(doc);
        if (result instanceof IDocumentNode) {
            return (IDocumentNode)result;
        }
        throw new IllegalStateException();
    }

    @Override
    public IDocumentNode parse(String xml) {
        Document doc = Jsoup.parseXML(xml);
        INode result = this.wrapJsoupHierarchy(doc);
        if (result instanceof IDocumentNode) {
            return (IDocumentNode)result;
        }
        throw new IllegalStateException();
    }

    private INode wrapJsoupHierarchy(Node jsoupNode) {
        JsoupNode resultNode = null;
        if (jsoupNode instanceof Document) {
            resultNode = new JsoupDocumentNode((Document)jsoupNode);
        } else if (jsoupNode instanceof TextNode) {
            resultNode = new JsoupTextNode((TextNode)jsoupNode);
        } else if (jsoupNode instanceof Element) {
            resultNode = new JsoupElementNode((Element)jsoupNode);
        } else if (jsoupNode instanceof DataNode) {
            resultNode = new JsoupDataNode((DataNode)jsoupNode);
        } else if (jsoupNode instanceof DocumentType) {
            resultNode = new JsoupDocumentTypeNode((DocumentType)jsoupNode);
        } else if (!(jsoupNode instanceof Comment)) {
            logger.error(MessageFormatUtil.format((String)"Could not map node type: {0}", (Object[])new Object[]{jsoupNode.getClass()}));
        }
        for (Node node : jsoupNode.childNodes()) {
            INode childNode = this.wrapJsoupHierarchy(node);
            if (childNode == null) continue;
            resultNode.addChild(childNode);
        }
        return resultNode;
    }
}

