/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.parse;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.parse.CssSelectorParserMatch;
import com.itextpdf.styledxmlparser.css.selector.item.CssAttributeSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssClassSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssIdSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssSeparatorSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssTagSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.ICssSelectorItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public final class CssSelectorParser {
    private static final Set<String> legacyPseudoElements = new HashSet<String>();
    private static final String SELECTOR_PATTERN_STR = "(\\*)|([_a-zA-Z][\\w-]*)|(\\.[_a-zA-Z][\\w-]*)|(#[_a-z][\\w-]*)|(\\[[_a-zA-Z][\\w-]*(([~^$*|])?=((\"[^\"]+\")|([^\"]+)|('[^']+')|(\"\")|('')))?\\])|(::?[a-zA-Z-]*)|( )|(\\+)|(>)|(~)";
    private static final Pattern selectorPattern;

    private CssSelectorParser() {
    }

    public static List<ICssSelectorItem> parseSelectorItems(String selector) {
        ArrayList<ICssSelectorItem> selectorItems = new ArrayList<ICssSelectorItem>();
        CssSelectorParserMatch match = new CssSelectorParserMatch(selector, selectorPattern);
        boolean tagSelectorDescription = false;
        while (match.success()) {
            String selectorItem = match.getValue();
            char firstChar = selectorItem.charAt(0);
            switch (firstChar) {
                case '#': {
                    match.next();
                    selectorItems.add(new CssIdSelectorItem(selectorItem.substring(1)));
                    break;
                }
                case '.': {
                    match.next();
                    selectorItems.add(new CssClassSelectorItem(selectorItem.substring(1)));
                    break;
                }
                case '[': {
                    match.next();
                    selectorItems.add(new CssAttributeSelectorItem(selectorItem));
                    break;
                }
                case ':': {
                    break;
                }
                case ' ': 
                case '+': 
                case '>': 
                case '~': {
                    match.next();
                    if (selectorItems.size() == 0) {
                        throw new IllegalArgumentException(MessageFormatUtil.format((String)"Invalid token detected in the start of the selector string: {0}", (Object[])new Object[]{Character.valueOf(firstChar)}));
                    }
                    ICssSelectorItem lastItem = (ICssSelectorItem)selectorItems.get(selectorItems.size() - 1);
                    CssSeparatorSelectorItem curItem = new CssSeparatorSelectorItem(firstChar);
                    if (lastItem instanceof CssSeparatorSelectorItem) {
                        if (curItem.getSeparator() == ' ') break;
                        if (((CssSeparatorSelectorItem)lastItem).getSeparator() == ' ') {
                            selectorItems.set(selectorItems.size() - 1, curItem);
                            break;
                        }
                        throw new IllegalArgumentException(MessageFormatUtil.format((String)"Invalid selector description. Two consequent characters occurred: {0}, {1}", (Object[])new Object[]{Character.valueOf(((CssSeparatorSelectorItem)lastItem).getSeparator()), Character.valueOf(curItem.getSeparator())}));
                    }
                    selectorItems.add(curItem);
                    tagSelectorDescription = false;
                    break;
                }
                default: {
                    match.next();
                    if (tagSelectorDescription) {
                        throw new IllegalStateException("Invalid selector string");
                    }
                    tagSelectorDescription = true;
                    selectorItems.add(new CssTagSelectorItem(selectorItem));
                }
            }
        }
        if (selectorItems.size() == 0) {
            throw new IllegalArgumentException("Selector declaration is invalid");
        }
        return selectorItems;
    }

    static {
        legacyPseudoElements.add("first-line");
        legacyPseudoElements.add("first-letter");
        legacyPseudoElements.add("before");
        legacyPseudoElements.add("after");
        selectorPattern = Pattern.compile(SELECTOR_PATTERN_STR);
    }
}

