/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.util;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.styledxmlparser.PortUtil;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

class CssPropertyNormalizer {
    private static final Pattern URL_PATTERN = PortUtil.createRegexPatternWithDotMatchingNewlines("^[uU][rR][lL]\\(");

    CssPropertyNormalizer() {
    }

    static String normalize(String str) {
        StringBuilder sb = new StringBuilder();
        boolean isWhitespace = false;
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '\\') {
                sb.append(str.charAt(i));
                if (++i >= str.length()) continue;
                sb.append(str.charAt(i));
                ++i;
                continue;
            }
            if (Character.isWhitespace(str.charAt(i))) {
                isWhitespace = true;
                ++i;
                continue;
            }
            if (isWhitespace) {
                if (sb.length() > 0 && !CssPropertyNormalizer.trimSpaceAfter(sb.charAt(sb.length() - 1)) && !CssPropertyNormalizer.trimSpaceBefore(str.charAt(i))) {
                    sb.append(" ");
                }
                isWhitespace = false;
            }
            if (str.charAt(i) == '\'' || str.charAt(i) == '\"') {
                i = CssPropertyNormalizer.appendQuotedString(sb, str, i);
                continue;
            }
            if ((str.charAt(i) == 'u' || str.charAt(i) == 'U') && URL_PATTERN.matcher(str.substring(i)).find()) {
                sb.append(str.substring(i, i + 4).toLowerCase());
                i = CssPropertyNormalizer.appendUrlContent(sb, str, i + 4);
                continue;
            }
            sb.append(Character.toLowerCase(str.charAt(i)));
            ++i;
        }
        return sb.toString();
    }

    private static int appendQuotedString(StringBuilder buffer, String source, int start) {
        char endQuoteSymbol = source.charAt(start);
        int end = CssUtils.findNextUnescapedChar(source, endQuoteSymbol, start + 1);
        if (end == -1) {
            end = source.length();
            LoggerFactory.getLogger(CssPropertyNormalizer.class).warn(MessageFormatUtil.format((String)"The quote is not closed in css expression: {0}", (Object[])new Object[]{source}));
        } else {
            ++end;
        }
        buffer.append(source, start, end);
        return end;
    }

    private static int appendUrlContent(StringBuilder buffer, String source, int start) {
        while (Character.isWhitespace(source.charAt(start)) && start < source.length()) {
            ++start;
        }
        if (start < source.length()) {
            int curr = start;
            if (source.charAt(curr) == '\"' || source.charAt(curr) == '\'') {
                curr = CssPropertyNormalizer.appendQuotedString(buffer, source, curr);
                return curr;
            }
            if ((curr = CssUtils.findNextUnescapedChar(source, ')', curr)) == -1) {
                LoggerFactory.getLogger(CssPropertyNormalizer.class).warn(MessageFormatUtil.format((String)"url function is not properly closed in expression:{0}", (Object[])new Object[]{source}));
                return source.length();
            }
            buffer.append(source.substring(start, curr).trim());
            buffer.append(')');
            return curr + 1;
        }
        LoggerFactory.getLogger(CssPropertyNormalizer.class).warn(MessageFormatUtil.format((String)"url function is empty in expression:{0}", (Object[])new Object[]{source}));
        return source.length();
    }

    private static boolean trimSpaceAfter(char ch) {
        return ch == ',' || ch == '(';
    }

    private static boolean trimSpaceBefore(char ch) {
        return ch == ',' || ch == ')';
    }
}

