/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.util;

import com.itextpdf.layout.property.BackgroundRepeat;
import com.itextpdf.styledxmlparser.css.CommonCssConstants;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssGradientUtil;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;

public final class CssBackgroundUtils {
    private CssBackgroundUtils() {
    }

    public static BackgroundRepeat.BackgroundRepeatValue parseBackgroundRepeat(String value) {
        switch (value) {
            case "no-repeat": {
                return BackgroundRepeat.BackgroundRepeatValue.NO_REPEAT;
            }
            case "round": {
                return BackgroundRepeat.BackgroundRepeatValue.ROUND;
            }
            case "space": {
                return BackgroundRepeat.BackgroundRepeatValue.SPACE;
            }
        }
        return BackgroundRepeat.BackgroundRepeatValue.REPEAT;
    }

    public static String getBackgroundPropertyNameFromType(BackgroundPropertyType propertyType) {
        switch (propertyType) {
            case BACKGROUND_COLOR: {
                return "background-color";
            }
            case BACKGROUND_IMAGE: {
                return "background-image";
            }
            case BACKGROUND_POSITION: {
                return "background-position";
            }
            case BACKGROUND_POSITION_X: {
                return "background-position-x";
            }
            case BACKGROUND_POSITION_Y: {
                return "background-position-y";
            }
            case BACKGROUND_SIZE: {
                return "background-size";
            }
            case BACKGROUND_REPEAT: {
                return "background-repeat";
            }
            case BACKGROUND_ORIGIN: {
                return "background-origin";
            }
            case BACKGROUND_CLIP: {
                return "background-clip";
            }
            case BACKGROUND_ATTACHMENT: {
                return "background-attachment";
            }
        }
        return "undefined";
    }

    public static BackgroundPropertyType resolveBackgroundPropertyType(String value) {
        String url = "url(";
        if (value.startsWith("url(") && value.indexOf(40, "url(".length()) == -1 && value.indexOf(41) == value.length() - 1) {
            return BackgroundPropertyType.BACKGROUND_IMAGE;
        }
        if (CssGradientUtil.isCssLinearGradientValue(value) || "none".equals(value)) {
            return BackgroundPropertyType.BACKGROUND_IMAGE;
        }
        if (CommonCssConstants.BACKGROUND_REPEAT_VALUES.contains(value)) {
            return BackgroundPropertyType.BACKGROUND_REPEAT;
        }
        if (CommonCssConstants.BACKGROUND_ATTACHMENT_VALUES.contains(value)) {
            return BackgroundPropertyType.BACKGROUND_ATTACHMENT;
        }
        if (CommonCssConstants.BACKGROUND_POSITION_X_VALUES.contains(value) && !"center".equals(value)) {
            return BackgroundPropertyType.BACKGROUND_POSITION_X;
        }
        if (CommonCssConstants.BACKGROUND_POSITION_Y_VALUES.contains(value) && !"center".equals(value)) {
            return BackgroundPropertyType.BACKGROUND_POSITION_Y;
        }
        if ("center".equals(value)) {
            return BackgroundPropertyType.BACKGROUND_POSITION;
        }
        if (Integer.valueOf(0).equals(CssDimensionParsingUtils.parseInteger(value)) || CssTypesValidationUtils.isMetricValue(value) || CssTypesValidationUtils.isRelativeValue(value)) {
            return BackgroundPropertyType.BACKGROUND_POSITION_OR_SIZE;
        }
        if (CommonCssConstants.BACKGROUND_SIZE_VALUES.contains(value)) {
            return BackgroundPropertyType.BACKGROUND_SIZE;
        }
        if (CssTypesValidationUtils.isColorProperty(value)) {
            return BackgroundPropertyType.BACKGROUND_COLOR;
        }
        if (CommonCssConstants.BACKGROUND_ORIGIN_OR_CLIP_VALUES.contains(value)) {
            return BackgroundPropertyType.BACKGROUND_ORIGIN_OR_CLIP;
        }
        return BackgroundPropertyType.UNDEFINED;
    }

    public static enum BackgroundPropertyType {
        BACKGROUND_COLOR,
        BACKGROUND_IMAGE,
        BACKGROUND_POSITION,
        BACKGROUND_POSITION_X,
        BACKGROUND_POSITION_Y,
        BACKGROUND_SIZE,
        BACKGROUND_REPEAT,
        BACKGROUND_ORIGIN,
        BACKGROUND_CLIP,
        BACKGROUND_ATTACHMENT,
        BACKGROUND_POSITION_OR_SIZE,
        BACKGROUND_ORIGIN_OR_CLIP,
        UNDEFINED;

    }
}

