/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.validate.CssDeclarationValidationMaster;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceItemsShorthandResolver
implements IShorthandResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlaceItemsShorthandResolver.class);

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        if (CssTypesValidationUtils.isInitialOrInheritOrUnset(shorthandExpression = shorthandExpression.trim())) {
            return Arrays.asList(new CssDeclaration("align-items", shorthandExpression), new CssDeclaration("justify-items", shorthandExpression));
        }
        if (CssTypesValidationUtils.containsInitialOrInheritOrUnset(shorthandExpression)) {
            return PlaceItemsShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "place-items", shorthandExpression);
        }
        if (shorthandExpression.isEmpty()) {
            return PlaceItemsShorthandResolver.handleExpressionError("{0} shorthand property cannot be empty.", "place-items", shorthandExpression);
        }
        String[] placeItemsProps = shorthandExpression.split(" ");
        switch (placeItemsProps.length) {
            case 1: {
                return this.resolveShorthandWithOneWord(placeItemsProps[0]);
            }
            case 2: {
                return this.resolveShorthandWithTwoWords(placeItemsProps[0], placeItemsProps[1]);
            }
            case 3: {
                return this.resolveShorthandWithThreeWords(placeItemsProps[0], placeItemsProps[1], placeItemsProps[2]);
            }
            case 4: {
                return this.resolveShorthandWithFourWords(placeItemsProps[0], placeItemsProps[1], placeItemsProps[2], placeItemsProps[3]);
            }
        }
        return PlaceItemsShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "place-items", shorthandExpression);
    }

    private List<CssDeclaration> resolveShorthandWithOneWord(String firstWord) {
        List<CssDeclaration> resolvedShorthand = this.resolveAlignItemsAndJustifyItems(firstWord, firstWord);
        if (resolvedShorthand.isEmpty()) {
            return PlaceItemsShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "place-items", firstWord);
        }
        return resolvedShorthand;
    }

    private List<CssDeclaration> resolveShorthandWithTwoWords(String firstWord, String secondWord) {
        List<CssDeclaration> resolvedShorthand = this.resolveAlignItemsAndJustifyItems(firstWord, secondWord);
        if (resolvedShorthand.isEmpty() && (resolvedShorthand = this.resolveAlignItemsAndJustifyItems(firstWord + " " + secondWord, firstWord + " " + secondWord)).isEmpty()) {
            return PlaceItemsShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "place-items", firstWord + " " + secondWord);
        }
        return resolvedShorthand;
    }

    private List<CssDeclaration> resolveShorthandWithThreeWords(String firstWord, String secondWord, String thirdWord) {
        List<CssDeclaration> resolvedShorthand = this.resolveAlignItemsAndJustifyItems(firstWord, secondWord + " " + thirdWord);
        if (resolvedShorthand.isEmpty() && (resolvedShorthand = this.resolveAlignItemsAndJustifyItems(firstWord + " " + secondWord, thirdWord)).isEmpty()) {
            return PlaceItemsShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "place-items", firstWord + " " + secondWord + " " + thirdWord);
        }
        return resolvedShorthand;
    }

    private List<CssDeclaration> resolveShorthandWithFourWords(String firstWord, String secondWord, String thirdWord, String fourthWord) {
        List<CssDeclaration> resolvedShorthand = this.resolveAlignItemsAndJustifyItems(firstWord + " " + secondWord, thirdWord + " " + fourthWord);
        if (resolvedShorthand.isEmpty()) {
            return PlaceItemsShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "place-items", firstWord + " " + secondWord + " " + thirdWord + " " + fourthWord);
        }
        return resolvedShorthand;
    }

    private List<CssDeclaration> resolveAlignItemsAndJustifyItems(String alignItems, String justifyItems) {
        CssDeclaration alignItemsDeclaration = new CssDeclaration("align-items", alignItems);
        if (CssDeclarationValidationMaster.checkDeclaration(alignItemsDeclaration)) {
            CssDeclaration justifyItemsDeclaration = new CssDeclaration("justify-items", justifyItems);
            if (CssDeclarationValidationMaster.checkDeclaration(justifyItemsDeclaration)) {
                return Arrays.asList(alignItemsDeclaration, justifyItemsDeclaration);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private static List<CssDeclaration> handleExpressionError(String logMessage, String attribute, String shorthandExpression) {
        LOGGER.warn(MessageFormatUtil.format((String)logMessage, (Object[])new Object[]{attribute, shorthandExpression}));
        return Collections.emptyList();
    }
}

