/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer.objectfit;

import com.itextpdf.layout.properties.ObjectFit;
import com.itextpdf.layout.renderer.objectfit.ObjectFitApplyingResult;

public final class ObjectFitCalculator {
    private ObjectFitCalculator() {
    }

    public static ObjectFitApplyingResult calculateRenderedImageSize(ObjectFit objectFit, double absoluteImageWidth, double absoluteImageHeight, double imageContainerWidth, double imageContainerHeight) {
        switch (objectFit) {
            case FILL: {
                return ObjectFitCalculator.processFill(imageContainerWidth, imageContainerHeight);
            }
            case CONTAIN: {
                return ObjectFitCalculator.processContain(absoluteImageWidth, absoluteImageHeight, imageContainerWidth, imageContainerHeight);
            }
            case COVER: {
                return ObjectFitCalculator.processCover(absoluteImageWidth, absoluteImageHeight, imageContainerWidth, imageContainerHeight);
            }
            case SCALE_DOWN: {
                return ObjectFitCalculator.processScaleDown(absoluteImageWidth, absoluteImageHeight, imageContainerWidth, imageContainerHeight);
            }
            case NONE: {
                return ObjectFitCalculator.processNone(absoluteImageWidth, absoluteImageHeight, imageContainerWidth, imageContainerHeight);
            }
        }
        throw new IllegalArgumentException("Object fit parameter cannot be null!");
    }

    private static ObjectFitApplyingResult processFill(double imageContainerWidth, double imageContainerHeight) {
        return new ObjectFitApplyingResult(imageContainerWidth, imageContainerHeight, false);
    }

    private static ObjectFitApplyingResult processContain(double absoluteImageWidth, double absoluteImageHeight, double imageContainerWidth, double imageContainerHeight) {
        return ObjectFitCalculator.processToFitSide(absoluteImageWidth, absoluteImageHeight, imageContainerWidth, imageContainerHeight, false);
    }

    private static ObjectFitApplyingResult processCover(double absoluteImageWidth, double absoluteImageHeight, double imageContainerWidth, double imageContainerHeight) {
        return ObjectFitCalculator.processToFitSide(absoluteImageWidth, absoluteImageHeight, imageContainerWidth, imageContainerHeight, true);
    }

    private static ObjectFitApplyingResult processScaleDown(double absoluteImageWidth, double absoluteImageHeight, double imageContainerWidth, double imageContainerHeight) {
        if (imageContainerWidth >= absoluteImageWidth && imageContainerHeight >= absoluteImageHeight) {
            return new ObjectFitApplyingResult(absoluteImageWidth, absoluteImageHeight, false);
        }
        return ObjectFitCalculator.processToFitSide(absoluteImageWidth, absoluteImageHeight, imageContainerWidth, imageContainerHeight, false);
    }

    private static ObjectFitApplyingResult processNone(double absoluteImageWidth, double absoluteImageHeight, double imageContainerWidth, double imageContainerHeight) {
        boolean doesObjectFitRequireCutting = imageContainerWidth <= absoluteImageWidth || imageContainerHeight <= absoluteImageHeight;
        return new ObjectFitApplyingResult(absoluteImageWidth, absoluteImageHeight, doesObjectFitRequireCutting);
    }

    private static ObjectFitApplyingResult processToFitSide(double absoluteImageWidth, double absoluteImageHeight, double imageContainerWidth, double imageContainerHeight, boolean clipToFit) {
        double renderedImageHeight;
        double renderedImageWidth;
        double heightCoeff = imageContainerHeight / absoluteImageHeight;
        double widthCoeff = imageContainerWidth / absoluteImageWidth;
        boolean isWidthFitted = heightCoeff > widthCoeff ^ clipToFit;
        if (isWidthFitted) {
            renderedImageWidth = imageContainerWidth;
            renderedImageHeight = absoluteImageHeight * imageContainerWidth / absoluteImageWidth;
        } else {
            renderedImageHeight = imageContainerHeight;
            renderedImageWidth = absoluteImageWidth * imageContainerHeight / absoluteImageHeight;
        }
        return new ObjectFitApplyingResult(renderedImageWidth, renderedImageHeight, clipToFit);
    }
}

