/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.TableBorderDescriptor;
import com.itextpdf.layout.renderer.TableBorderUtil;
import com.itextpdf.layout.renderer.TableBorders;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class CollapsedTableBorders
extends TableBorders {
    private List<Border> topBorderCollapseWith = new ArrayList<Border>();
    private List<Border> bottomBorderCollapseWith = new ArrayList<Border>();
    private List<Border> verticalBottomBorderCollapseWith = null;
    private static Comparator<Border> borderComparator = new BorderComparator();

    public CollapsedTableBorders(List<CellRenderer[]> rows, int numberOfColumns, Border[] tableBoundingBorders) {
        super(rows, numberOfColumns, tableBoundingBorders);
    }

    public CollapsedTableBorders(List<CellRenderer[]> rows, int numberOfColumns, Border[] tableBoundingBorders, int largeTableIndexOffset) {
        super(rows, numberOfColumns, tableBoundingBorders, largeTableIndexOffset);
    }

    public List<Border> getTopBorderCollapseWith() {
        return this.topBorderCollapseWith;
    }

    public List<Border> getBottomBorderCollapseWith() {
        return this.bottomBorderCollapseWith;
    }

    @Override
    public float[] getCellBorderIndents(int row, int col, int rowspan, int colspan) {
        Border border;
        int i;
        float[] indents = new float[4];
        List<Border> borderList = this.getHorizontalBorder(this.startRow + row - rowspan + 1);
        for (i = col; i < col + colspan; ++i) {
            border = borderList.get(i);
            if (null == border || !(border.getWidth() > indents[0])) continue;
            indents[0] = border.getWidth();
        }
        borderList = this.getVerticalBorder(col + colspan);
        for (i = this.startRow - this.largeTableIndexOffset + row - rowspan + 1; i < this.startRow - this.largeTableIndexOffset + row + 1; ++i) {
            border = borderList.get(i);
            if (null == border || !(border.getWidth() > indents[1])) continue;
            indents[1] = border.getWidth();
        }
        borderList = this.getHorizontalBorder(this.startRow + row + 1);
        for (i = col; i < col + colspan; ++i) {
            border = borderList.get(i);
            if (null == border || !(border.getWidth() > indents[2])) continue;
            indents[2] = border.getWidth();
        }
        borderList = this.getVerticalBorder(col);
        for (i = this.startRow - this.largeTableIndexOffset + row - rowspan + 1; i < this.startRow - this.largeTableIndexOffset + row + 1; ++i) {
            border = borderList.get(i);
            if (null == border || !(border.getWidth() > indents[3])) continue;
            indents[3] = border.getWidth();
        }
        return indents;
    }

    public List<Border> getVerticalBordersCrossingTopHorizontalBorder() {
        ArrayList<Border> borders = new ArrayList<Border>(this.numberOfColumns + 1);
        for (int i = 0; i <= this.numberOfColumns; ++i) {
            List<Border> verticalBorder = this.getVerticalBorder(i);
            Border borderToAdd = this.startRow - this.largeTableIndexOffset < verticalBorder.size() ? verticalBorder.get(this.startRow - this.largeTableIndexOffset) : null;
            borders.add(borderToAdd);
        }
        return borders;
    }

    @Override
    public List<Border> getVerticalBorder(int index) {
        if (index == 0) {
            List<Border> borderList = TableBorderUtil.createAndFillBorderList(null, this.tableBoundingBorders[3], ((List)this.verticalBorders.get(0)).size());
            return CollapsedTableBorders.getCollapsedList((List)this.verticalBorders.get(0), borderList);
        }
        if (index == this.numberOfColumns) {
            List<Border> borderList = TableBorderUtil.createAndFillBorderList(null, this.tableBoundingBorders[1], ((List)this.verticalBorders.get(this.verticalBorders.size() - 1)).size());
            return CollapsedTableBorders.getCollapsedList((List)this.verticalBorders.get(this.verticalBorders.size() - 1), borderList);
        }
        return (List)this.verticalBorders.get(index);
    }

    @Override
    public List<Border> getHorizontalBorder(int index) {
        if (index == this.startRow) {
            List<Border> firstBorderOnCurrentPage = TableBorderUtil.createAndFillBorderList(this.topBorderCollapseWith, this.tableBoundingBorders[0], this.numberOfColumns);
            if (index == this.largeTableIndexOffset) {
                return CollapsedTableBorders.getCollapsedList((List)this.horizontalBorders.get(index - this.largeTableIndexOffset), firstBorderOnCurrentPage);
            }
            if (0 != this.rows.size()) {
                int col = 0;
                int row = index;
                while (col < this.numberOfColumns) {
                    if (null != ((CellRenderer[])this.rows.get(row - this.largeTableIndexOffset))[col] && row - index + 1 <= ((Cell)((CellRenderer[])this.rows.get(row - this.largeTableIndexOffset))[col].getModelElement()).getRowspan()) {
                        CellRenderer cell = ((CellRenderer[])this.rows.get(row - this.largeTableIndexOffset))[col];
                        Border cellModelTopBorder = TableBorderUtil.getCellSideBorder((Cell)cell.getModelElement(), 13);
                        int colspan = cell.getPropertyAsInteger(16);
                        if (null == firstBorderOnCurrentPage.get(col) || null != cellModelTopBorder && cellModelTopBorder.getWidth() > firstBorderOnCurrentPage.get(col).getWidth()) {
                            for (int i = col; i < col + colspan; ++i) {
                                firstBorderOnCurrentPage.set(i, cellModelTopBorder);
                            }
                        }
                        col += colspan;
                        row = index;
                        continue;
                    }
                    if (++row != this.rows.size()) continue;
                }
            }
            return firstBorderOnCurrentPage;
        }
        if (index == this.finishRow + 1) {
            List<Border> lastBorderOnCurrentPage = TableBorderUtil.createAndFillBorderList(this.bottomBorderCollapseWith, this.tableBoundingBorders[2], this.numberOfColumns);
            if (index - this.largeTableIndexOffset == this.horizontalBorders.size() - 1) {
                return CollapsedTableBorders.getCollapsedList((List)this.horizontalBorders.get(index - this.largeTableIndexOffset), lastBorderOnCurrentPage);
            }
            if (0 != this.rows.size()) {
                int col = 0;
                int row = index - 1;
                while (col < this.numberOfColumns) {
                    if (null != ((CellRenderer[])this.rows.get(row - this.largeTableIndexOffset))[col]) {
                        CellRenderer cell = ((CellRenderer[])this.rows.get(row - this.largeTableIndexOffset))[col];
                        Border cellModelBottomBorder = TableBorderUtil.getCellSideBorder((Cell)cell.getModelElement(), 10);
                        int colspan = cell.getPropertyAsInteger(16);
                        if (null == lastBorderOnCurrentPage.get(col) || null != cellModelBottomBorder && cellModelBottomBorder.getWidth() > lastBorderOnCurrentPage.get(col).getWidth()) {
                            for (int i = col; i < col + colspan; ++i) {
                                lastBorderOnCurrentPage.set(i, cellModelBottomBorder);
                            }
                        }
                        col += colspan;
                        row = index - 1;
                        continue;
                    }
                    if (++row != this.rows.size()) continue;
                }
            }
            return lastBorderOnCurrentPage;
        }
        return (List)this.horizontalBorders.get(index - this.largeTableIndexOffset);
    }

    public CollapsedTableBorders setTopBorderCollapseWith(List<Border> topBorderCollapseWith) {
        this.topBorderCollapseWith = new ArrayList<Border>();
        if (null != topBorderCollapseWith) {
            this.topBorderCollapseWith.addAll(topBorderCollapseWith);
        }
        return this;
    }

    public CollapsedTableBorders setBottomBorderCollapseWith(List<Border> bottomBorderCollapseWith, List<Border> verticalBordersCrossingBottomBorder) {
        this.bottomBorderCollapseWith = new ArrayList<Border>();
        if (null != bottomBorderCollapseWith) {
            this.bottomBorderCollapseWith.addAll(bottomBorderCollapseWith);
        }
        this.verticalBottomBorderCollapseWith = null;
        if (null != verticalBordersCrossingBottomBorder) {
            this.verticalBottomBorderCollapseWith = new ArrayList<Border>(verticalBordersCrossingBottomBorder);
        }
        return this;
    }

    @Override
    protected void buildBordersArrays(CellRenderer cell, int row, int col, int[] rowspansToDeduct) {
        int i;
        int nextCellColspan;
        CellRenderer nextCell;
        int nextCellRow;
        int j;
        if (row > this.horizontalBorders.size()) {
            --row;
        }
        int currCellColspan = cell.getPropertyAsInteger(16);
        if (col != 0 && null == ((CellRenderer[])this.rows.get(row))[col - 1]) {
            j = col;
            do {
                --j;
                for (nextCellRow = row; this.rows.size() != nextCellRow && null == ((CellRenderer[])this.rows.get(nextCellRow))[j]; ++nextCellRow) {
                }
            } while (j > 0 && this.rows.size() != nextCellRow && (j + ((CellRenderer[])this.rows.get(nextCellRow))[j].getPropertyAsInteger(16) != col || nextCellRow - ((CellRenderer[])this.rows.get(nextCellRow))[j].getPropertyAsInteger(60) + 1 + rowspansToDeduct[j] != row));
            if (j >= 0 && nextCellRow != this.rows.size() && nextCellRow > row) {
                nextCell = ((CellRenderer[])this.rows.get(nextCellRow))[j];
                nextCell.setProperty(60, nextCell.getPropertyAsInteger(60) - rowspansToDeduct[j]);
                nextCellColspan = nextCell.getPropertyAsInteger(16);
                for (i = j; i < j + nextCellColspan; ++i) {
                    rowspansToDeduct[i] = 0;
                }
                this.buildBordersArrays(nextCell, nextCellRow, true);
            }
        }
        for (j = 0; j < currCellColspan; j += nextCell.getPropertyAsInteger(16).intValue()) {
            for (nextCellRow = row + 1; nextCellRow < this.rows.size() && null == ((CellRenderer[])this.rows.get(nextCellRow))[col + j]; ++nextCellRow) {
            }
            if (nextCellRow == this.rows.size()) break;
            nextCell = ((CellRenderer[])this.rows.get(nextCellRow))[col + j];
            if (row != nextCellRow - nextCell.getPropertyAsInteger(60)) continue;
            this.buildBordersArrays(nextCell, nextCellRow, true);
        }
        if (col + currCellColspan < ((CellRenderer[])this.rows.get(row)).length) {
            for (nextCellRow = row; nextCellRow < this.rows.size() && null == ((CellRenderer[])this.rows.get(nextCellRow))[col + currCellColspan]; ++nextCellRow) {
            }
            if (nextCellRow != this.rows.size()) {
                nextCell = ((CellRenderer[])this.rows.get(nextCellRow))[col + currCellColspan];
                nextCell.setProperty(60, nextCell.getPropertyAsInteger(60) - rowspansToDeduct[col + currCellColspan]);
                nextCellColspan = nextCell.getPropertyAsInteger(16);
                for (i = col + currCellColspan; i < col + currCellColspan + nextCellColspan; ++i) {
                    rowspansToDeduct[i] = 0;
                }
                this.buildBordersArrays(nextCell, nextCellRow, true);
            }
        }
        this.buildBordersArrays(cell, row, false);
    }

    protected void buildBordersArrays(CellRenderer cell, int row, boolean isNeighbourCell) {
        int i;
        int colspan = cell.getPropertyAsInteger(16);
        int rowspan = cell.getPropertyAsInteger(60);
        int colN = ((Cell)cell.getModelElement()).getCol();
        Border[] cellBorders = cell.getBorders();
        if (row + 1 - rowspan < 0) {
            rowspan = row + 1;
        }
        for (i = 0; i < colspan; ++i) {
            this.checkAndReplaceBorderInArray(this.horizontalBorders, row + 1 - rowspan, colN + i, cellBorders[0], false);
        }
        for (i = 0; i < colspan; ++i) {
            this.checkAndReplaceBorderInArray(this.horizontalBorders, row + 1, colN + i, cellBorders[2], true);
        }
        for (int j = row - rowspan + 1; j <= row; ++j) {
            this.checkAndReplaceBorderInArray(this.verticalBorders, colN, j, cellBorders[3], false);
        }
        for (i = row - rowspan + 1; i <= row; ++i) {
            this.checkAndReplaceBorderInArray(this.verticalBorders, colN + colspan, i, cellBorders[1], true);
        }
    }

    protected boolean checkAndReplaceBorderInArray(List<List<Border>> borderArray, int i, int j, Border borderToAdd, boolean hasPriority) {
        List<Border> borders = borderArray.get(i);
        Border neighbour = borders.get(j);
        if (neighbour == null) {
            borders.set(j, borderToAdd);
            return true;
        }
        if (neighbour != borderToAdd && borderToAdd != null && neighbour.getWidth() <= borderToAdd.getWidth()) {
            if (!hasPriority && neighbour.getWidth() == borderToAdd.getWidth()) {
                return false;
            }
            borders.set(j, borderToAdd);
            return true;
        }
        return false;
    }

    @Override
    protected TableBorders drawHorizontalBorder(PdfCanvas canvas, TableBorderDescriptor borderDescriptor) {
        int i = borderDescriptor.getBorderIndex();
        float startX = borderDescriptor.getMainCoordinateStart();
        float y1 = borderDescriptor.getCrossCoordinate();
        float[] countedColumnWidth = borderDescriptor.getMainCoordinateWidths();
        List<Border> horizontalBorder = this.getHorizontalBorder(this.startRow + i);
        float x1 = startX;
        float x2 = x1 + countedColumnWidth[0];
        for (int j = 1; j <= horizontalBorder.size(); ++j) {
            Border nextBorder;
            Border currentBorder = horizontalBorder.get(j - 1);
            Border border = nextBorder = j < horizontalBorder.size() ? horizontalBorder.get(j) : null;
            if (currentBorder != null) {
                List<Border> crossingBordersAtStart = this.getCrossingBorders(i, j - 1);
                float startCornerWidth = this.getWidestBorderWidth(crossingBordersAtStart.get(1), crossingBordersAtStart.get(3));
                List<Border> crossingBordersAtEnd = this.getCrossingBorders(i, j);
                float endCornerWidth = this.getWidestBorderWidth(crossingBordersAtEnd.get(1), crossingBordersAtEnd.get(3));
                if (1 == j) {
                    crossingBordersAtStart.add(0, currentBorder);
                }
                if (0 == i) {
                    if (1 != j) {
                        crossingBordersAtStart.add(0, crossingBordersAtStart.get(3));
                    }
                    crossingBordersAtEnd.add(0, crossingBordersAtEnd.get(3));
                }
                Collections.sort(crossingBordersAtStart, borderComparator);
                Collections.sort(crossingBordersAtEnd, borderComparator);
                float x1Offset = currentBorder.equals(crossingBordersAtStart.get(0)) ? -startCornerWidth / 2.0f : startCornerWidth / 2.0f;
                float x2Offset = currentBorder.equals(crossingBordersAtEnd.get(0)) ? endCornerWidth / 2.0f : -endCornerWidth / 2.0f;
                currentBorder.drawCellBorder(canvas, x1 + x1Offset, y1, x2 + x2Offset, y1, Border.Side.NONE);
                x1 = x2;
            } else {
                x2 = x1 += countedColumnWidth[j - 1];
            }
            if (nextBorder == null || j == horizontalBorder.size()) continue;
            x2 += countedColumnWidth[j];
        }
        return this;
    }

    @Override
    protected TableBorders drawVerticalBorder(PdfCanvas canvas, TableBorderDescriptor borderDescriptor) {
        float y1;
        int i = borderDescriptor.getBorderIndex();
        float startY = borderDescriptor.getMainCoordinateStart();
        float x1 = borderDescriptor.getCrossCoordinate();
        float[] heights = borderDescriptor.getMainCoordinateWidths();
        List<Border> borders = this.getVerticalBorder(i);
        float y2 = y1 = startY;
        if (0 != heights.length) {
            y2 = y1 - heights[0];
        }
        Float y1Offset = null;
        for (int j = 1; j <= heights.length; ++j) {
            Border nextBorder;
            Border currentBorder = borders.get(this.startRow - this.largeTableIndexOffset + j - 1);
            Border border = nextBorder = j < heights.length ? borders.get(this.startRow - this.largeTableIndexOffset + j) : null;
            if (currentBorder != null) {
                List<Border> crossingBordersAtStart = this.getCrossingBorders(j - 1, i);
                float startCornerWidth = this.getWidestBorderWidth(crossingBordersAtStart.get(0), crossingBordersAtStart.get(2));
                if (1 == j) {
                    crossingBordersAtStart.add(0, currentBorder);
                }
                Collections.sort(crossingBordersAtStart, borderComparator);
                List<Border> crossingBordersAtEnd = this.getCrossingBorders(j, i);
                float endCornerWidth = this.getWidestBorderWidth(crossingBordersAtEnd.get(0), crossingBordersAtEnd.get(2));
                Collections.sort(crossingBordersAtEnd, borderComparator);
                if (!currentBorder.equals(nextBorder)) {
                    if (null == y1Offset) {
                        y1Offset = Float.valueOf(currentBorder.equals(crossingBordersAtStart.get(0)) ? startCornerWidth / 2.0f : -startCornerWidth / 2.0f);
                    }
                    float y2Offset = currentBorder.equals(crossingBordersAtEnd.get(0)) ? -endCornerWidth / 2.0f : endCornerWidth / 2.0f;
                    currentBorder.drawCellBorder(canvas, x1, y1 + y1Offset.floatValue(), x1, y2 + y2Offset, Border.Side.NONE);
                    y1 = y2;
                    y1Offset = null;
                } else if (null == y1Offset) {
                    y1Offset = Float.valueOf(currentBorder.equals(crossingBordersAtStart.get(0)) ? startCornerWidth / 2.0f : -startCornerWidth / 2.0f);
                }
            } else {
                y2 = y1 -= heights[j - 1];
            }
            if (nextBorder == null) continue;
            y2 -= heights[j];
        }
        return this;
    }

    public static Border getCollapsedBorder(Border cellBorder, Border tableBorder) {
        if (null != tableBorder && (null == cellBorder || cellBorder.getWidth() < tableBorder.getWidth())) {
            return tableBorder;
        }
        if (null != cellBorder) {
            return cellBorder;
        }
        return Border.NO_BORDER;
    }

    public static List<Border> getCollapsedList(List<Border> innerList, List<Border> outerList) {
        int size = Math.min(null == innerList ? 0 : innerList.size(), null == outerList ? 0 : outerList.size());
        ArrayList<Border> collapsedList = new ArrayList<Border>();
        for (int i = 0; i < size; ++i) {
            collapsedList.add(CollapsedTableBorders.getCollapsedBorder(innerList.get(i), outerList.get(i)));
        }
        return collapsedList;
    }

    @Override
    protected TableBorders applyLeftAndRightTableBorder(Rectangle layoutBox, boolean reverse) {
        if (null != layoutBox) {
            layoutBox.applyMargins(0.0f, this.rightBorderMaxWidth / 2.0f, 0.0f, this.leftBorderMaxWidth / 2.0f, reverse);
        }
        return this;
    }

    @Override
    protected TableBorders applyTopTableBorder(Rectangle occupiedBox, Rectangle layoutBox, boolean isEmpty, boolean force, boolean reverse) {
        if (!isEmpty) {
            return this.applyTopTableBorder(occupiedBox, layoutBox, reverse);
        }
        if (force) {
            this.applyTopTableBorder(occupiedBox, layoutBox, reverse);
            return this.applyTopTableBorder(occupiedBox, layoutBox, reverse);
        }
        return this;
    }

    @Override
    protected TableBorders applyBottomTableBorder(Rectangle occupiedBox, Rectangle layoutBox, boolean isEmpty, boolean force, boolean reverse) {
        if (!isEmpty) {
            return this.applyBottomTableBorder(occupiedBox, layoutBox, reverse);
        }
        if (force) {
            this.applyBottomTableBorder(occupiedBox, layoutBox, reverse);
            return this.applyBottomTableBorder(occupiedBox, layoutBox, reverse);
        }
        return this;
    }

    @Override
    protected TableBorders applyTopTableBorder(Rectangle occupiedBox, Rectangle layoutBox, boolean reverse) {
        float topIndent = (float)(reverse ? -1 : 1) * this.getMaxTopWidth();
        layoutBox.decreaseHeight(topIndent / 2.0f);
        occupiedBox.moveDown(topIndent / 2.0f).increaseHeight(topIndent / 2.0f);
        return this;
    }

    @Override
    protected TableBorders applyBottomTableBorder(Rectangle occupiedBox, Rectangle layoutBox, boolean reverse) {
        float bottomTableBorderWidth = (float)(reverse ? -1 : 1) * this.getMaxBottomWidth();
        layoutBox.decreaseHeight(bottomTableBorderWidth / 2.0f);
        occupiedBox.moveDown(bottomTableBorderWidth / 2.0f).increaseHeight(bottomTableBorderWidth / 2.0f);
        return this;
    }

    @Override
    protected TableBorders applyCellIndents(Rectangle box, float topIndent, float rightIndent, float bottomIndent, float leftIndent, boolean reverse) {
        box.applyMargins(topIndent / 2.0f, rightIndent / 2.0f, bottomIndent / 2.0f, leftIndent / 2.0f, false);
        return this;
    }

    @Override
    protected float getCellVerticalAddition(float[] indents) {
        return indents[0] / 2.0f + indents[2] / 2.0f;
    }

    @Override
    protected TableBorders updateBordersOnNewPage(boolean isOriginalNonSplitRenderer, boolean isFooterOrHeader, TableRenderer currentRenderer, TableRenderer headerRenderer, TableRenderer footerRenderer) {
        if (!isFooterOrHeader) {
            if (isOriginalNonSplitRenderer) {
                if (null != this.rows) {
                    this.processAllBordersAndEmptyRows();
                    this.rightBorderMaxWidth = this.getMaxRightWidth();
                    this.leftBorderMaxWidth = this.getMaxLeftWidth();
                }
                this.setTopBorderCollapseWith(((Table)currentRenderer.getModelElement()).getLastRowBottomBorder());
            } else {
                this.setTopBorderCollapseWith(null);
                this.setBottomBorderCollapseWith(null, null);
            }
        }
        if (null != footerRenderer) {
            float rightFooterBorderWidth = footerRenderer.bordersHandler.getMaxRightWidth();
            float leftFooterBorderWidth = footerRenderer.bordersHandler.getMaxLeftWidth();
            this.leftBorderMaxWidth = Math.max(this.leftBorderMaxWidth, leftFooterBorderWidth);
            this.rightBorderMaxWidth = Math.max(this.rightBorderMaxWidth, rightFooterBorderWidth);
        }
        if (null != headerRenderer) {
            float rightHeaderBorderWidth = headerRenderer.bordersHandler.getMaxRightWidth();
            float leftHeaderBorderWidth = headerRenderer.bordersHandler.getMaxLeftWidth();
            this.leftBorderMaxWidth = Math.max(this.leftBorderMaxWidth, leftHeaderBorderWidth);
            this.rightBorderMaxWidth = Math.max(this.rightBorderMaxWidth, rightHeaderBorderWidth);
        }
        return this;
    }

    @Override
    protected TableBorders skipFooter(Border[] borders) {
        this.setTableBoundingBorders(borders);
        this.setBottomBorderCollapseWith(null, null);
        return this;
    }

    @Override
    protected TableBorders skipHeader(Border[] borders) {
        this.setTableBoundingBorders(borders);
        this.setTopBorderCollapseWith(null);
        return this;
    }

    @Override
    protected TableBorders collapseTableWithFooter(TableBorders footerBordersHandler, boolean hasContent) {
        ((CollapsedTableBorders)footerBordersHandler).setTopBorderCollapseWith(hasContent ? this.getLastHorizontalBorder() : this.getTopBorderCollapseWith());
        this.setBottomBorderCollapseWith(footerBordersHandler.getHorizontalBorder(0), ((CollapsedTableBorders)footerBordersHandler).getVerticalBordersCrossingTopHorizontalBorder());
        return this;
    }

    @Override
    protected TableBorders collapseTableWithHeader(TableBorders headerBordersHandler, boolean updateBordersHandler) {
        ((CollapsedTableBorders)headerBordersHandler).setBottomBorderCollapseWith(this.getHorizontalBorder(this.startRow), this.getVerticalBordersCrossingTopHorizontalBorder());
        if (updateBordersHandler) {
            this.setTopBorderCollapseWith(headerBordersHandler.getLastHorizontalBorder());
        }
        return this;
    }

    @Override
    protected TableBorders fixHeaderOccupiedArea(Rectangle occupiedBox, Rectangle layoutBox) {
        float topBorderMaxWidth = this.getMaxTopWidth();
        layoutBox.increaseHeight(topBorderMaxWidth);
        occupiedBox.moveUp(topBorderMaxWidth).decreaseHeight(topBorderMaxWidth);
        return this;
    }

    List<Border> getCrossingBorders(int horizontalIndex, int verticalIndex) {
        List<Border> horizontalBorder = this.getHorizontalBorder(this.startRow + horizontalIndex);
        List<Border> verticalBorder = this.getVerticalBorder(verticalIndex);
        ArrayList<Border> crossingBorders = new ArrayList<Border>(4);
        crossingBorders.add(verticalIndex > 0 ? horizontalBorder.get(verticalIndex - 1) : null);
        crossingBorders.add(horizontalIndex > 0 ? verticalBorder.get(this.startRow - this.largeTableIndexOffset + horizontalIndex - 1) : null);
        crossingBorders.add(verticalIndex < this.numberOfColumns ? horizontalBorder.get(verticalIndex) : null);
        crossingBorders.add(horizontalIndex <= this.finishRow - this.startRow ? verticalBorder.get(this.startRow - this.largeTableIndexOffset + horizontalIndex) : null);
        if (horizontalIndex == this.finishRow - this.startRow + 1 && null != this.verticalBottomBorderCollapseWith && CollapsedTableBorders.isBorderWider(this.verticalBottomBorderCollapseWith.get(verticalIndex), (Border)crossingBorders.get(3))) {
            crossingBorders.set(3, this.verticalBottomBorderCollapseWith.get(verticalIndex));
        }
        return crossingBorders;
    }

    private float getWidestBorderWidth(Border ... borders) {
        float maxWidth = 0.0f;
        for (Border border : borders) {
            if (null == border || !(maxWidth < border.getWidth())) continue;
            maxWidth = border.getWidth();
        }
        return maxWidth;
    }

    private static boolean isBorderWider(Border thisBorder, Border otherBorder) {
        return CollapsedTableBorders.isBorderWider(thisBorder, otherBorder, true);
    }

    private static boolean isBorderWider(Border thisBorder, Border otherBorder, boolean strict) {
        if (null == thisBorder) {
            return false;
        }
        if (null == otherBorder) {
            return true;
        }
        int comparisonResult = Float.compare(thisBorder.getWidth(), otherBorder.getWidth());
        return strict ? comparisonResult > 0 : comparisonResult >= 0;
    }

    private static class BorderComparator
    implements Comparator<Border> {
        private BorderComparator() {
        }

        @Override
        public int compare(Border o1, Border o2) {
            if (o1 == o2) {
                return 0;
            }
            if (null == o1) {
                return 1;
            }
            if (null == o2) {
                return -1;
            }
            return Float.compare(o2.getWidth(), o1.getWidth());
        }
    }
}

