/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.element;

import com.itextpdf.io.image.ImageData;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.canvas.wmf.WmfImageData;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.DefaultAccessibilityProperties;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.element.AbstractElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.property.ObjectFit;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Image
extends AbstractElement<Image>
implements ILeafElement,
IAccessibleElement {
    protected PdfXObject xObject;
    protected DefaultAccessibilityProperties tagProperties;

    public Image(PdfImageXObject xObject) {
        this.xObject = xObject;
    }

    public Image(PdfFormXObject xObject) {
        this.xObject = xObject;
    }

    public Image(PdfImageXObject xObject, float width) {
        this.xObject = xObject;
        this.setWidth(width);
    }

    public Image(PdfImageXObject xObject, float left, float bottom, float width) {
        this.xObject = xObject;
        this.setProperty(34, Float.valueOf(left));
        this.setProperty(14, Float.valueOf(bottom));
        this.setWidth(width);
        this.setProperty(52, 4);
    }

    public Image(PdfImageXObject xObject, float left, float bottom) {
        this.xObject = xObject;
        this.setProperty(34, Float.valueOf(left));
        this.setProperty(14, Float.valueOf(bottom));
        this.setProperty(52, 4);
    }

    public Image(PdfFormXObject xObject, float left, float bottom) {
        this.xObject = xObject;
        this.setProperty(34, Float.valueOf(left));
        this.setProperty(14, Float.valueOf(bottom));
        this.setProperty(52, 4);
    }

    public Image(ImageData img) {
        this(new PdfImageXObject(Image.checkImageType(img)));
        this.setProperty(19, true);
    }

    public Image(ImageData img, float left, float bottom) {
        this(new PdfImageXObject(Image.checkImageType(img)), left, bottom);
        this.setProperty(19, true);
    }

    public Image(ImageData img, float left, float bottom, float width) {
        this(new PdfImageXObject(Image.checkImageType(img)), left, bottom, width);
        this.setProperty(19, true);
    }

    public PdfXObject getXObject() {
        return this.xObject;
    }

    public Image setRotationAngle(double radAngle) {
        this.setProperty(55, radAngle);
        return this;
    }

    public UnitValue getMarginLeft() {
        return (UnitValue)this.getProperty(44);
    }

    public Image setMarginLeft(float value) {
        UnitValue marginUV = UnitValue.createPointValue(value);
        this.setProperty(44, marginUV);
        return this;
    }

    public UnitValue getMarginRight() {
        return (UnitValue)this.getProperty(45);
    }

    public Image setMarginRight(float value) {
        UnitValue marginUV = UnitValue.createPointValue(value);
        this.setProperty(45, marginUV);
        return this;
    }

    public UnitValue getMarginTop() {
        return (UnitValue)this.getProperty(46);
    }

    public Image setMarginTop(float value) {
        UnitValue marginUV = UnitValue.createPointValue(value);
        this.setProperty(46, marginUV);
        return this;
    }

    public UnitValue getMarginBottom() {
        return (UnitValue)this.getProperty(43);
    }

    public Image setMarginBottom(float value) {
        UnitValue marginUV = UnitValue.createPointValue(value);
        this.setProperty(43, marginUV);
        return this;
    }

    public Image setMargins(float marginTop, float marginRight, float marginBottom, float marginLeft) {
        return this.setMarginTop(marginTop).setMarginRight(marginRight).setMarginBottom(marginBottom).setMarginLeft(marginLeft);
    }

    public UnitValue getPaddingLeft() {
        return (UnitValue)this.getProperty(48);
    }

    public Image setPaddingLeft(float value) {
        UnitValue paddingUV = UnitValue.createPointValue(value);
        this.setProperty(48, paddingUV);
        return this;
    }

    public UnitValue getPaddingRight() {
        return (UnitValue)this.getProperty(49);
    }

    public Image setPaddingRight(float value) {
        UnitValue paddingUV = UnitValue.createPointValue(value);
        this.setProperty(49, paddingUV);
        return this;
    }

    public UnitValue getPaddingTop() {
        return (UnitValue)this.getProperty(50);
    }

    public Image setPaddingTop(float value) {
        UnitValue paddingUV = UnitValue.createPointValue(value);
        this.setProperty(50, paddingUV);
        return this;
    }

    public UnitValue getPaddingBottom() {
        return (UnitValue)this.getProperty(47);
    }

    public Image setPaddingBottom(float value) {
        UnitValue paddingUV = UnitValue.createPointValue(value);
        this.setProperty(47, paddingUV);
        return this;
    }

    public Image setPadding(float commonPadding) {
        return this.setPaddings(commonPadding, commonPadding, commonPadding, commonPadding);
    }

    public Image setPaddings(float paddingTop, float paddingRight, float paddingBottom, float paddingLeft) {
        this.setPaddingTop(paddingTop);
        this.setPaddingRight(paddingRight);
        this.setPaddingBottom(paddingBottom);
        this.setPaddingLeft(paddingLeft);
        return this;
    }

    public Image scale(float horizontalScaling, float verticalScaling) {
        this.setProperty(29, Float.valueOf(horizontalScaling));
        this.setProperty(76, Float.valueOf(verticalScaling));
        return this;
    }

    public Image scaleToFit(float fitWidth, float fitHeight) {
        float horizontalScaling = fitWidth / this.xObject.getWidth();
        float verticalScaling = fitHeight / this.xObject.getHeight();
        return this.scale(Math.min(horizontalScaling, verticalScaling), Math.min(horizontalScaling, verticalScaling));
    }

    public Image scaleAbsolute(float fitWidth, float fitHeight) {
        float horizontalScaling = fitWidth / this.xObject.getWidth();
        float verticalScaling = fitHeight / this.xObject.getHeight();
        return this.scale(horizontalScaling, verticalScaling);
    }

    public Image setAutoScale(boolean autoScale) {
        if (this.hasProperty(5) && this.hasProperty(4) && autoScale && (((Boolean)this.getProperty(5)).booleanValue() || ((Boolean)this.getProperty(4)).booleanValue())) {
            Logger logger = LoggerFactory.getLogger(Image.class);
            logger.warn("The image cannot be auto scaled and scaled by a certain parameter simultaneously");
        }
        this.setProperty(3, autoScale);
        return this;
    }

    public Image setAutoScaleHeight(boolean autoScale) {
        if (this.hasProperty(5) && autoScale && ((Boolean)this.getProperty(5)).booleanValue()) {
            this.setProperty(5, false);
            this.setProperty(4, false);
            this.setProperty(3, true);
        } else {
            this.setProperty(5, autoScale);
        }
        return this;
    }

    public Image setAutoScaleWidth(boolean autoScale) {
        if (this.hasProperty(4) && autoScale && ((Boolean)this.getProperty(4)).booleanValue()) {
            this.setProperty(5, false);
            this.setProperty(4, false);
            this.setProperty(3, true);
        } else {
            this.setProperty(5, autoScale);
        }
        return this;
    }

    public Image setFixedPosition(float left, float bottom) {
        this.setFixedPosition(left, bottom, this.getWidth());
        return this;
    }

    public Image setFixedPosition(int pageNumber, float left, float bottom) {
        this.setFixedPosition(pageNumber, left, bottom, this.getWidth());
        return this;
    }

    public float getImageWidth() {
        return this.xObject.getWidth();
    }

    public float getImageHeight() {
        return this.xObject.getHeight();
    }

    public Image setHeight(float height) {
        UnitValue heightAsUV = UnitValue.createPointValue(height);
        this.setProperty(27, heightAsUV);
        return this;
    }

    public Image setHeight(UnitValue height) {
        this.setProperty(27, height);
        return this;
    }

    public Image setMaxHeight(float maxHeight) {
        UnitValue maxHeightAsUv = UnitValue.createPointValue(maxHeight);
        this.setProperty(84, maxHeightAsUv);
        return this;
    }

    public Image setMaxHeight(UnitValue maxHeight) {
        this.setProperty(84, maxHeight);
        return this;
    }

    public Image setMinHeight(float minHeight) {
        UnitValue minHeightAsUv = UnitValue.createPointValue(minHeight);
        this.setProperty(85, minHeightAsUv);
        return this;
    }

    public Image setMinHeight(UnitValue minHeight) {
        this.setProperty(85, minHeight);
        return this;
    }

    public Image setMaxWidth(float maxWidth) {
        UnitValue minHeightAsUv = UnitValue.createPointValue(maxWidth);
        this.setProperty(79, minHeightAsUv);
        return this;
    }

    public Image setMaxWidth(UnitValue maxWidth) {
        this.setProperty(79, maxWidth);
        return this;
    }

    public Image setMinWidth(float minWidth) {
        UnitValue minHeightAsUv = UnitValue.createPointValue(minWidth);
        this.setProperty(80, minHeightAsUv);
        return this;
    }

    public Image setMinWidth(UnitValue minWidth) {
        this.setProperty(80, minWidth);
        return this;
    }

    public Image setWidth(float width) {
        this.setProperty(77, UnitValue.createPointValue(width));
        return this;
    }

    public Image setWidth(UnitValue width) {
        this.setProperty(77, width);
        return this;
    }

    public UnitValue getWidth() {
        return (UnitValue)this.getProperty(77);
    }

    public float getImageScaledWidth() {
        return null == this.getProperty(29) ? this.xObject.getWidth() : this.xObject.getWidth() * ((Float)this.getProperty(29)).floatValue();
    }

    public float getImageScaledHeight() {
        return null == this.getProperty(76) ? this.xObject.getHeight() : this.xObject.getHeight() * ((Float)this.getProperty(76)).floatValue();
    }

    public Image setObjectFit(ObjectFit objectFit) {
        this.setProperty(125, (Object)objectFit);
        return this;
    }

    public ObjectFit getObjectFit() {
        if (this.hasProperty(125)) {
            return (ObjectFit)((Object)this.getProperty(125));
        }
        return ObjectFit.FILL;
    }

    @Override
    public AccessibilityProperties getAccessibilityProperties() {
        if (this.tagProperties == null) {
            this.tagProperties = new DefaultAccessibilityProperties("Figure");
        }
        return this.tagProperties;
    }

    @Override
    protected IRenderer makeNewRenderer() {
        return new ImageRenderer(this);
    }

    private static ImageData checkImageType(ImageData image) {
        if (image instanceof WmfImageData) {
            throw new PdfException("Cannot create layout image by WmfImage instance. First convert the image into FormXObject and then use the corresponding layout image constructor.");
        }
        return image;
    }
}

