/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.kernel.font.PdfFont;

public final class TextPreprocessingUtil {
    private TextPreprocessingUtil() {
    }

    public static GlyphLine replaceSpecialWhitespaceGlyphs(GlyphLine line, PdfFont font) {
        if (null != line) {
            boolean isMonospaceFont = font.getFontProgram().getFontMetrics().isFixedPitch();
            Glyph space = font.getGlyph(32);
            int spaceWidth = space.getWidth();
            int lineSize = line.size();
            for (int i = 0; i < lineSize; ++i) {
                Glyph glyph = line.get(i);
                int xAdvance = 0;
                boolean isSpecialWhitespaceGlyph = false;
                if (glyph.getCode() <= 0) {
                    switch (glyph.getUnicode()) {
                        case 8194: {
                            xAdvance = isMonospaceFont ? 0 : 500 - spaceWidth;
                            isSpecialWhitespaceGlyph = true;
                            break;
                        }
                        case 8195: {
                            xAdvance = isMonospaceFont ? 0 : 1000 - spaceWidth;
                            isSpecialWhitespaceGlyph = true;
                            break;
                        }
                        case 8201: {
                            xAdvance = isMonospaceFont ? 0 : 200 - spaceWidth;
                            isSpecialWhitespaceGlyph = true;
                            break;
                        }
                        case 9: {
                            xAdvance = 3 * spaceWidth;
                            isSpecialWhitespaceGlyph = true;
                        }
                    }
                }
                if (!isSpecialWhitespaceGlyph) continue;
                Glyph newGlyph = new Glyph(space, glyph.getUnicode());
                assert (xAdvance <= Short.MAX_VALUE && xAdvance >= Short.MIN_VALUE);
                newGlyph.setXAdvance((short)xAdvance);
                line.set(i, newGlyph);
            }
        }
        return line;
    }
}

