/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout;

import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.layout.ElementPropertyContainer;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.property.FontKerning;
import com.itextpdf.layout.property.HorizontalAlignment;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.VerticalAlignment;
import com.itextpdf.layout.renderer.RootRenderer;
import com.itextpdf.layout.splitting.DefaultSplitCharacters;
import com.itextpdf.layout.splitting.ISplitCharacters;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RootElement<T extends IPropertyContainer>
extends ElementPropertyContainer<T>
implements Closeable {
    protected boolean immediateFlush = true;
    protected PdfDocument pdfDocument;
    protected List<IElement> childElements = new ArrayList<IElement>();
    @Deprecated
    protected Map<Integer, Object> properties = new HashMap<Integer, Object>();
    protected PdfFont defaultFont;
    protected FontProvider defaultFontProvider;
    protected ISplitCharacters defaultSplitCharacters;
    protected RootRenderer rootRenderer;

    public T add(IBlockElement element) {
        this.childElements.add(element);
        this.ensureRootRendererNotNull().addChild(element.createRendererSubTree());
        if (this.immediateFlush) {
            this.childElements.remove(this.childElements.size() - 1);
        }
        return (T)this;
    }

    public T add(Image image) {
        this.childElements.add(image);
        this.ensureRootRendererNotNull().addChild(image.createRendererSubTree());
        if (this.immediateFlush) {
            this.childElements.remove(this.childElements.size() - 1);
        }
        return (T)this;
    }

    public FontProvider getFontProvider() {
        Object fontProvider = this.getProperty(91);
        if (fontProvider instanceof FontProvider) {
            return (FontProvider)fontProvider;
        }
        return null;
    }

    public void setFontProvider(FontProvider fontProvider) {
        this.setProperty(91, fontProvider);
    }

    @Override
    public boolean hasProperty(int property) {
        return this.hasOwnProperty(property);
    }

    @Override
    public boolean hasOwnProperty(int property) {
        return this.properties.containsKey(property);
    }

    @Override
    public <T1> T1 getProperty(int property) {
        return this.getOwnProperty(property);
    }

    @Override
    public <T1> T1 getOwnProperty(int property) {
        return (T1)this.properties.get(property);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        try {
            switch (property) {
                case 20: {
                    if (this.defaultFont == null) {
                        this.defaultFont = PdfFontFactory.createFont();
                    }
                    return (T1)this.defaultFont;
                }
                case 91: {
                    if (this.defaultFontProvider == null) {
                        this.defaultFontProvider = new FontProvider();
                    }
                    return (T1)this.defaultFontProvider;
                }
                case 62: {
                    if (this.defaultSplitCharacters == null) {
                        this.defaultSplitCharacters = new DefaultSplitCharacters();
                    }
                    return (T1)this.defaultSplitCharacters;
                }
                case 24: {
                    return (T1)Integer.valueOf(12);
                }
                case 71: {
                    return (T1)Integer.valueOf(0);
                }
                case 72: {
                    return (T1)Float.valueOf(0.0f);
                }
                case 61: {
                    return (T1)Float.valueOf(0.75f);
                }
            }
            return null;
        }
        catch (IOException exc) {
            throw new RuntimeException(exc.toString(), exc);
        }
    }

    @Override
    public void deleteOwnProperty(int property) {
        this.properties.remove(property);
    }

    @Override
    public void setProperty(int property, Object value) {
        this.properties.put(property, value);
    }

    public RootRenderer getRenderer() {
        return this.ensureRootRendererNotNull();
    }

    public T showTextAligned(String text, float x, float y, TextAlignment textAlign) {
        return this.showTextAligned(text, x, y, textAlign, 0.0f);
    }

    public T showTextAligned(String text, float x, float y, TextAlignment textAlign, float angle) {
        return this.showTextAligned(text, x, y, textAlign, VerticalAlignment.BOTTOM, angle);
    }

    public T showTextAligned(String text, float x, float y, TextAlignment textAlign, VerticalAlignment vertAlign, float angle) {
        Paragraph p = (Paragraph)new Paragraph(text).setMultipliedLeading(1.0f).setMargin(0.0f);
        return this.showTextAligned(p, x, y, this.pdfDocument.getNumberOfPages(), textAlign, vertAlign, angle);
    }

    public T showTextAlignedKerned(String text, float x, float y, TextAlignment textAlign, VerticalAlignment vertAlign, float radAngle) {
        Paragraph p = (Paragraph)((Paragraph)new Paragraph(text).setMultipliedLeading(1.0f).setMargin(0.0f)).setFontKerning(FontKerning.YES);
        return this.showTextAligned(p, x, y, this.pdfDocument.getNumberOfPages(), textAlign, vertAlign, radAngle);
    }

    public T showTextAligned(Paragraph p, float x, float y, TextAlignment textAlign) {
        return this.showTextAligned(p, x, y, this.pdfDocument.getNumberOfPages(), textAlign, VerticalAlignment.BOTTOM, 0.0f);
    }

    public T showTextAligned(Paragraph p, float x, float y, TextAlignment textAlign, VerticalAlignment vertAlign) {
        return this.showTextAligned(p, x, y, this.pdfDocument.getNumberOfPages(), textAlign, vertAlign, 0.0f);
    }

    public T showTextAligned(Paragraph p, float x, float y, int pageNumber, TextAlignment textAlign, VerticalAlignment vertAlign, float radAngle) {
        Div div = new Div();
        ((Div)div.setTextAlignment(textAlign)).setVerticalAlignment(vertAlign);
        if (radAngle != 0.0f) {
            div.setRotationAngle(radAngle);
        }
        div.setProperty(58, Float.valueOf(x));
        div.setProperty(59, Float.valueOf(y));
        float divSize = 5000.0f;
        float divX = x;
        float divY = y;
        if (textAlign == TextAlignment.CENTER) {
            divX = x - divSize / 2.0f;
            p.setHorizontalAlignment(HorizontalAlignment.CENTER);
        } else if (textAlign == TextAlignment.RIGHT) {
            divX = x - divSize;
            p.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        }
        if (vertAlign == VerticalAlignment.MIDDLE) {
            divY = y - divSize / 2.0f;
        } else if (vertAlign == VerticalAlignment.TOP) {
            divY = y - divSize;
        }
        if (pageNumber == 0) {
            pageNumber = 1;
        }
        ((Div)div.setFixedPosition(pageNumber, divX, divY, divSize)).setMinHeight(divSize);
        if (p.getProperty(33) == null) {
            p.setMultipliedLeading(1.0f);
        }
        div.add((IBlockElement)p.setMargins(0.0f, 0.0f, 0.0f, 0.0f));
        div.setRole(PdfName.Artifact);
        this.add(div);
        return (T)this;
    }

    protected abstract RootRenderer ensureRootRendererNotNull();
}

