/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.border;

import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.border.Border;

public class DottedBorder
extends Border {
    private static final float GAP_MODIFIER = 1.5f;

    public DottedBorder(float width) {
        super(width);
    }

    public DottedBorder(Color color, float width) {
        super(color, width);
    }

    public DottedBorder(Color color, float width, float opacity) {
        super(color, width, opacity);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float borderWidthBefore, float borderWidthAfter) {
        float initialGap = this.width * 1.5f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = this.getDotsGap(borderLength, initialGap + this.width);
        if (adjustedGap > this.width) {
            adjustedGap -= this.width;
        }
        float widthHalf = this.width / 2.0f;
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2);
        switch (borderSide) {
            case TOP: {
                y1 += widthHalf;
                y2 += widthHalf;
                break;
            }
            case RIGHT: {
                x1 += widthHalf;
                x2 += widthHalf;
                break;
            }
            case BOTTOM: {
                y1 -= widthHalf;
                y2 -= widthHalf;
                break;
            }
            case LEFT: {
                x1 -= widthHalf;
                x2 -= widthHalf;
            }
        }
        canvas.saveState().setLineWidth(this.width).setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineDash(this.width, adjustedGap, this.width + adjustedGap / 2.0f).moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke().restoreState();
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float outerRadius, Border.Side side, float borderWidthBefore, float borderWidthAfter) {
        float curv = 0.447f;
        float initialGap = this.width * 1.5f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = this.getDotsGap(borderLength, initialGap);
        if (adjustedGap > this.width) {
            adjustedGap -= this.width;
        }
        float x0 = x1;
        float y0 = y1;
        float x3 = x2;
        float y3 = y2;
        float innerRadiusBefore = Math.max(0.0f, outerRadius - borderWidthBefore);
        float innerRadius = Math.max(0.0f, outerRadius - this.width);
        float innerRadiusAfter = Math.max(0.0f, outerRadius - borderWidthAfter);
        float widthHalf = this.width / 2.0f;
        canvas.saveState().setLineWidth(this.width).setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineDash(this.width, adjustedGap, this.width + adjustedGap / 2.0f);
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2, side);
        switch (borderSide) {
            case TOP: {
                Point clipPoint1 = this.getIntersectionPoint(new Point((double)(x1 - borderWidthBefore), (double)(y1 + this.width)), new Point((double)x1, (double)y1), new Point((double)(x0 -= borderWidthBefore / 2.0f), (double)(y0 -= innerRadius)), new Point((double)(x0 + 10.0f), (double)y0));
                Point clipPoint2 = this.getIntersectionPoint(new Point((double)(x2 + borderWidthAfter), (double)(y2 + this.width)), new Point((double)x2, (double)y2), new Point((double)(x3 += borderWidthAfter / 2.0f), (double)(y3 -= innerRadius)), new Point((double)(x3 - 10.0f), (double)y3));
                if (clipPoint1.x > clipPoint2.x) {
                    Point clipPoint = this.getIntersectionPoint(new Point((double)(x1 - borderWidthBefore), (double)(y1 + this.width)), clipPoint1, clipPoint2, new Point((double)(x2 + borderWidthAfter), (double)(y2 + this.width)));
                    canvas.moveTo((double)(x1 - borderWidthBefore), (double)(y1 + this.width)).lineTo(clipPoint.x, clipPoint.y).lineTo((double)(x2 + borderWidthAfter), (double)(y2 + this.width)).lineTo((double)(x1 - borderWidthBefore), (double)(y1 + this.width));
                } else {
                    canvas.moveTo((double)(x1 - borderWidthBefore), (double)(y1 + this.width)).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo((double)(x2 + borderWidthAfter), (double)(y2 + this.width)).lineTo((double)(x1 - borderWidthBefore), (double)(y1 + this.width));
                }
                canvas.clip().newPath();
                canvas.moveTo((double)x0, (double)y0).curveTo((double)x0, (double)(y0 + innerRadius * curv), (double)((x1 += innerRadiusBefore) - innerRadiusBefore * curv), (double)(y1 += widthHalf), (double)x1, (double)y1).lineTo((double)(x2 -= innerRadiusAfter), (double)(y2 += widthHalf)).curveTo((double)(x2 + innerRadiusAfter * curv), (double)y2, (double)x3, (double)(y3 + innerRadius * curv), (double)x3, (double)y3);
                break;
            }
            case RIGHT: {
                Point clipPoint1 = this.getIntersectionPoint(new Point((double)(x1 + this.width), (double)(y1 + borderWidthBefore)), new Point((double)x1, (double)y1), new Point((double)(x0 -= innerRadius), (double)(y0 += borderWidthBefore / 2.0f)), new Point((double)x0, (double)(y0 - 10.0f)));
                Point clipPoint2 = this.getIntersectionPoint(new Point((double)(x2 + this.width), (double)(y2 - borderWidthAfter)), new Point((double)x2, (double)y2), new Point((double)(x3 -= innerRadius), (double)(y3 -= borderWidthAfter)), new Point((double)x3, (double)(y3 - 10.0f)));
                if (clipPoint1.y < clipPoint2.y) {
                    Point clipPoint = this.getIntersectionPoint(new Point((double)(x1 + this.width), (double)(y1 + borderWidthBefore)), clipPoint1, clipPoint2, new Point((double)(x2 + this.width), (double)(y2 - borderWidthAfter)));
                    canvas.moveTo((double)(x1 + this.width), (double)(y1 + borderWidthBefore)).lineTo(clipPoint.x, clipPoint.y).lineTo((double)(x2 + this.width), (double)(y2 - borderWidthAfter)).lineTo((double)(x1 + this.width), (double)(y1 + borderWidthBefore)).clip().newPath();
                } else {
                    canvas.moveTo((double)(x1 + this.width), (double)(y1 + borderWidthBefore)).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo((double)(x2 + this.width), (double)(y2 - borderWidthAfter)).lineTo((double)(x1 + this.width), (double)(y1 + borderWidthBefore)).clip().newPath();
                }
                canvas.clip().newPath();
                canvas.moveTo((double)x0, (double)y0).curveTo((double)(x0 + innerRadius * curv), (double)y0, (double)(x1 += widthHalf), (double)((y1 -= innerRadiusBefore) + innerRadiusBefore * curv), (double)x1, (double)y1).lineTo((double)(x2 += widthHalf), (double)(y2 += innerRadiusAfter)).curveTo((double)x2, (double)(y2 - innerRadiusAfter * curv), (double)(x3 + innerRadius * curv), (double)y3, (double)x3, (double)y3);
                break;
            }
            case BOTTOM: {
                Point clipPoint1 = this.getIntersectionPoint(new Point((double)(x1 + borderWidthBefore), (double)(y1 - this.width)), new Point((double)x1, (double)y1), new Point((double)(x0 += borderWidthBefore / 2.0f), (double)(y0 += innerRadius)), new Point((double)(x0 - 10.0f), (double)y0));
                Point clipPoint2 = this.getIntersectionPoint(new Point((double)(x2 - borderWidthAfter), (double)(y2 - this.width)), new Point((double)x2, (double)y2), new Point((double)(x3 -= borderWidthAfter / 2.0f), (double)(y3 += innerRadius)), new Point((double)(x3 + 10.0f), (double)y3));
                if (clipPoint1.x < clipPoint2.x) {
                    Point clipPoint = this.getIntersectionPoint(new Point((double)(x1 + borderWidthBefore), (double)(y1 - this.width)), clipPoint1, clipPoint2, new Point((double)(x2 - borderWidthAfter), (double)(y2 - this.width)));
                    canvas.moveTo((double)(x1 + borderWidthBefore), (double)(y1 - this.width)).lineTo(clipPoint.x, clipPoint.y).lineTo((double)(x2 - borderWidthAfter), (double)(y2 - this.width)).lineTo((double)(x1 + borderWidthBefore), (double)(y1 - this.width));
                } else {
                    canvas.moveTo((double)(x1 + borderWidthBefore), (double)(y1 - this.width)).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo((double)(x2 - borderWidthAfter), (double)(y2 - this.width)).lineTo((double)(x1 + borderWidthBefore), (double)(y1 - this.width));
                }
                canvas.clip().newPath();
                canvas.moveTo((double)x0, (double)y0).curveTo((double)x0, (double)(y0 - innerRadius * curv), (double)((x1 -= innerRadiusBefore) + innerRadiusBefore * curv), (double)(y1 -= widthHalf), (double)x1, (double)y1).lineTo((double)(x2 += innerRadiusAfter), (double)(y2 -= widthHalf)).curveTo((double)(x2 - innerRadiusAfter * curv), (double)y2, (double)x3, (double)(y3 - innerRadius * curv), (double)x3, (double)y3);
                break;
            }
            case LEFT: {
                Point clipPoint1 = this.getIntersectionPoint(new Point((double)(x1 - this.width), (double)(y1 - borderWidthBefore)), new Point((double)x1, (double)y1), new Point((double)(x0 += innerRadius), (double)(y0 -= borderWidthBefore / 2.0f)), new Point((double)x0, (double)(y0 + 10.0f)));
                Point clipPoint2 = this.getIntersectionPoint(new Point((double)(x2 - this.width), (double)(y2 + borderWidthAfter)), new Point((double)x2, (double)y2), new Point((double)(x3 += innerRadius), (double)(y3 += borderWidthAfter)), new Point((double)x3, (double)(y3 + 10.0f)));
                if (clipPoint1.y > clipPoint2.y) {
                    Point clipPoint = this.getIntersectionPoint(new Point((double)(x1 - this.width), (double)(y1 - borderWidthBefore)), clipPoint1, clipPoint2, new Point((double)(x2 - this.width), (double)(y2 + borderWidthAfter)));
                    canvas.moveTo((double)(x1 - this.width), (double)(y1 - borderWidthBefore)).lineTo(clipPoint.x, clipPoint.y).lineTo((double)(x2 - this.width), (double)(y2 + borderWidthAfter)).lineTo((double)(x1 - this.width), (double)(y1 - borderWidthBefore));
                } else {
                    canvas.moveTo((double)(x1 - this.width), (double)(y1 - borderWidthBefore)).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo((double)(x2 - this.width), (double)(y2 + borderWidthAfter)).lineTo((double)(x1 - this.width), (double)(y1 - borderWidthBefore));
                }
                canvas.clip().newPath();
                canvas.moveTo((double)x0, (double)y0).curveTo((double)(x0 - innerRadius * curv), (double)y0, (double)(x1 -= widthHalf), (double)((y1 += innerRadiusBefore) - innerRadiusBefore * curv), (double)x1, (double)y1).lineTo((double)(x2 -= widthHalf), (double)(y2 -= innerRadiusAfter)).curveTo((double)x2, (double)(y2 + innerRadiusAfter * curv), (double)(x3 - innerRadius * curv), (double)y3, (double)x3, (double)y3);
            }
        }
        canvas.stroke().restoreState();
    }

    @Override
    public void drawCellBorder(PdfCanvas canvas, float x1, float y1, float x2, float y2) {
        float initialGap = this.width * 1.5f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = this.getDotsGap(borderLength, initialGap + this.width);
        if (adjustedGap > this.width) {
            adjustedGap -= this.width;
        }
        canvas.saveState().setLineWidth(this.width).setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineDash(this.width, adjustedGap, this.width + adjustedGap / 2.0f).moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke().restoreState();
    }

    protected float getDotsGap(double distance, float initialGap) {
        double gapsNum = Math.ceil(distance / (double)initialGap);
        if (gapsNum == 0.0) {
            return initialGap;
        }
        return (float)(distance / gapsNum);
    }
}

