/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.margincollapse.MarginsCollapseHandler;
import com.itextpdf.layout.margincollapse.MarginsCollapseInfo;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.property.AreaBreakType;
import com.itextpdf.layout.property.FloatPropertyValue;
import com.itextpdf.layout.property.HorizontalAlignment;
import com.itextpdf.layout.property.VerticalAlignment;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AbstractWidthHandler;
import com.itextpdf.layout.renderer.AccessibleAttributesApplier;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.MaxMaxWidthHandler;
import com.itextpdf.layout.renderer.TableRenderer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlockRenderer
extends AbstractRenderer {
    protected BlockRenderer(IElement modelElement) {
        super(modelElement);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        this.overrideHeightProperties();
        boolean wasHeightClipped = false;
        int pageNumber = layoutContext.getArea().getPageNumber();
        boolean isPositioned = this.isPositioned();
        Rectangle parentBBox = layoutContext.getArea().getBBox().clone();
        if (this.getProperty(55) != null || this.isFixedLayout()) {
            parentBBox.moveDown(1000000.0f - parentBBox.getHeight()).setHeight(1000000.0f);
        }
        Float blockWidth = this.retrieveWidth(parentBBox.getWidth());
        List<Rectangle> floatRendererAreas = layoutContext.getFloatRendererAreas();
        FloatPropertyValue floatPropertyValue = (FloatPropertyValue)((Object)this.getProperty(99));
        Float childrenMaxWidth = Float.valueOf(0.0f);
        if (floatPropertyValue != null) {
            if (floatPropertyValue.equals((Object)FloatPropertyValue.LEFT)) {
                this.setProperty(28, (Object)HorizontalAlignment.LEFT);
            } else if (floatPropertyValue.equals((Object)FloatPropertyValue.RIGHT)) {
                this.setProperty(28, (Object)HorizontalAlignment.RIGHT);
            }
            Float minHeightProperty = (Float)this.getProperty(85);
            MinMaxWidth minMaxWidth = this.getMinMaxWidth(parentBBox.getWidth());
            childrenMaxWidth = Float.valueOf(minMaxWidth.getChildrenMaxWidth());
            if (minHeightProperty != null) {
                this.setProperty(85, minHeightProperty);
            } else {
                this.deleteProperty(85);
            }
        }
        if (blockWidth != null && blockWidth.floatValue() > childrenMaxWidth.floatValue()) {
            childrenMaxWidth = blockWidth;
        }
        MarginsCollapseHandler marginsCollapseHandler = null;
        boolean marginsCollapsingEnabled = Boolean.TRUE.equals(this.getPropertyAsBoolean(89));
        boolean isCellRenderer = this instanceof CellRenderer;
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler = new MarginsCollapseHandler(this, layoutContext.getMarginsCollapseInfo());
            if (!isCellRenderer) {
                marginsCollapseHandler.startMarginsCollapse(parentBBox);
            }
        }
        Border[] borders = this.getBorders();
        float[] paddings = this.getPaddings();
        this.applyBordersPaddingsMargins(parentBBox, borders, paddings);
        if (blockWidth != null && (blockWidth.floatValue() < parentBBox.getWidth() || isPositioned)) {
            parentBBox.setWidth(blockWidth.floatValue());
        }
        if (floatPropertyValue != null && !FloatPropertyValue.NONE.equals((Object)floatPropertyValue)) {
            Rectangle layoutBox = layoutContext.getArea().getBBox();
            float extremalRightBorder = layoutBox.getX() + layoutBox.getWidth();
            this.adjustBlockAreaAccordingToFloatRenderers(floatRendererAreas, parentBBox, extremalRightBorder, blockWidth, marginsCollapseHandler);
            if (parentBBox.getWidth() < childrenMaxWidth.floatValue()) {
                childrenMaxWidth = Float.valueOf(parentBBox.getWidth());
            }
        }
        Float blockMaxHeight = this.retrieveMaxHeight();
        if (!this.isFixedLayout() && null != blockMaxHeight && blockMaxHeight.floatValue() < parentBBox.getHeight() && !Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
            float heightDelta = parentBBox.getHeight() - blockMaxHeight.floatValue();
            if (marginsCollapsingEnabled && !isCellRenderer) {
                marginsCollapseHandler.processFixedHeightAdjustment(heightDelta);
            }
            parentBBox.moveUp(heightDelta).setHeight(blockMaxHeight.floatValue());
            wasHeightClipped = true;
        }
        float clearHeightCorrection = this.calculateClearHeightCorrection(floatRendererAreas, parentBBox);
        List<Rectangle> areas = isPositioned ? Collections.singletonList(parentBBox) : this.initElementAreas(new LayoutArea(pageNumber, parentBBox));
        this.occupiedArea = new LayoutArea(pageNumber, new Rectangle(parentBBox.getX(), parentBBox.getY() + parentBBox.getHeight(), parentBBox.getWidth(), 0.0f));
        this.shrinkOccupiedAreaForAbsolutePosition();
        int currentAreaPos = 0;
        Rectangle layoutBox = areas.get(0).clone();
        IRenderer causeOfNothing = null;
        boolean anythingPlaced = false;
        for (int childPos = 0; childPos < this.childRenderers.size(); ++childPos) {
            LayoutResult result;
            IRenderer childRenderer = (IRenderer)this.childRenderers.get(childPos);
            childRenderer.setParent(this);
            MarginsCollapseInfo childMarginsInfo = null;
            if (marginsCollapsingEnabled) {
                childMarginsInfo = marginsCollapseHandler.startChildMarginsHandling(childRenderer, layoutBox);
            }
            while ((result = childRenderer.setParent(this).layout(new LayoutContext(new LayoutArea(pageNumber, layoutBox), childMarginsInfo, floatRendererAreas))).getStatus() != 1) {
                Float height;
                Float minHeight;
                Float maxHeight;
                if (marginsCollapsingEnabled) {
                    if (result.getStatus() != 3) {
                        marginsCollapseHandler.endChildMarginsHandling(layoutBox);
                    }
                    if (!isCellRenderer) {
                        marginsCollapseHandler.endMarginsCollapse(layoutBox);
                    }
                }
                if (Boolean.TRUE.equals(this.getPropertyAsBoolean(87)) || Boolean.TRUE.equals(this.getPropertyAsBoolean(86))) {
                    this.occupiedArea.setBBox(Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{this.occupiedArea.getBBox(), layoutBox}));
                } else if (result.getOccupiedArea() != null && result.getStatus() != 3) {
                    this.occupiedArea.setBBox(Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{this.occupiedArea.getBBox(), result.getOccupiedArea().getBBox()}));
                }
                if (result.getSplitRenderer() != null) {
                    this.alignChildHorizontally(result.getSplitRenderer(), this.occupiedArea.getBBox());
                }
                if (null == causeOfNothing && null != result.getCauseOfNothing()) {
                    causeOfNothing = result.getCauseOfNothing();
                }
                if (currentAreaPos + 1 < areas.size() && (result.getAreaBreak() == null || result.getAreaBreak().getType() != AreaBreakType.NEXT_PAGE)) {
                    if (result.getStatus() == 2) {
                        this.childRenderers.set(childPos, result.getSplitRenderer());
                        this.childRenderers.add(childPos + 1, result.getOverflowRenderer());
                    } else {
                        if (result.getOverflowRenderer() != null) {
                            this.childRenderers.set(childPos, result.getOverflowRenderer());
                        } else {
                            this.childRenderers.remove(childPos);
                        }
                        --childPos;
                    }
                    layoutBox = areas.get(++currentAreaPos).clone();
                    break;
                }
                if (result.getStatus() == 2) {
                    if (currentAreaPos + 1 == areas.size()) {
                        AbstractRenderer splitRenderer = this.createSplitRenderer(2);
                        splitRenderer.childRenderers = new ArrayList<IRenderer>(this.childRenderers.subList(0, childPos));
                        splitRenderer.childRenderers.add(result.getSplitRenderer());
                        splitRenderer.occupiedArea = this.occupiedArea;
                        AbstractRenderer overflowRenderer = this.createOverflowRenderer(2);
                        overflowRenderer.deleteOwnProperty(26);
                        ArrayList<IRenderer> overflowRendererChildren = new ArrayList<IRenderer>();
                        overflowRendererChildren.add(result.getOverflowRenderer());
                        overflowRendererChildren.addAll(this.childRenderers.subList(childPos + 1, this.childRenderers.size()));
                        overflowRenderer.childRenderers = overflowRendererChildren;
                        if (this.hasProperty(84)) {
                            overflowRenderer.setProperty(84, Float.valueOf(this.retrieveMaxHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
                        }
                        if (this.hasProperty(85)) {
                            overflowRenderer.setProperty(85, Float.valueOf(this.retrieveMinHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
                        }
                        if (this.hasProperty(27)) {
                            overflowRenderer.setProperty(27, Float.valueOf(this.retrieveHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
                        }
                        if (wasHeightClipped) {
                            Logger logger = LoggerFactory.getLogger(TableRenderer.class);
                            logger.warn("Element content was clipped because some height properties are set.");
                            this.occupiedArea.getBBox().moveDown(blockMaxHeight.floatValue() - this.occupiedArea.getBBox().getHeight()).setHeight(blockMaxHeight.floatValue());
                        }
                        this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
                        this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                        this.applyMargins(this.occupiedArea.getBBox(), true);
                        if (wasHeightClipped) {
                            return new LayoutResult(1, this.occupiedArea, splitRenderer, null);
                        }
                        return new LayoutResult(2, this.occupiedArea, splitRenderer, overflowRenderer, causeOfNothing);
                    }
                    this.childRenderers.set(childPos, result.getSplitRenderer());
                    this.childRenderers.add(childPos + 1, result.getOverflowRenderer());
                    layoutBox = areas.get(++currentAreaPos).clone();
                    break;
                }
                if (result.getStatus() != 3) continue;
                boolean keepTogether = this.isKeepTogether();
                int layoutResult = anythingPlaced && !keepTogether ? 2 : 3;
                AbstractRenderer splitRenderer = this.createSplitRenderer(layoutResult);
                splitRenderer.childRenderers = new ArrayList<IRenderer>(this.childRenderers.subList(0, childPos));
                for (IRenderer renderer : splitRenderer.childRenderers) {
                    renderer.setParent(splitRenderer);
                }
                AbstractRenderer overflowRenderer = this.createOverflowRenderer(layoutResult);
                ArrayList<IRenderer> overflowRendererChildren = new ArrayList<IRenderer>();
                if (result.getOverflowRenderer() != null) {
                    overflowRendererChildren.add(result.getOverflowRenderer());
                }
                overflowRendererChildren.addAll(this.childRenderers.subList(childPos + 1, this.childRenderers.size()));
                overflowRenderer.childRenderers = overflowRendererChildren;
                if (this.isRelativePosition() && this.positionedRenderers.size() > 0) {
                    overflowRenderer.positionedRenderers = new ArrayList<IRenderer>(this.positionedRenderers);
                }
                if (keepTogether) {
                    splitRenderer = null;
                    overflowRenderer.childRenderers.clear();
                    overflowRenderer.childRenderers = new ArrayList<IRenderer>(this.childRenderers);
                }
                if ((maxHeight = this.retrieveMaxHeight()) != null) {
                    if (isPositioned) {
                        this.correctPositionedLayout(layoutBox);
                    }
                    overflowRenderer.setProperty(84, Float.valueOf(maxHeight.floatValue() - this.occupiedArea.getBBox().getHeight()));
                }
                if ((minHeight = this.retrieveMinHeight()) != null) {
                    overflowRenderer.setProperty(85, Float.valueOf(minHeight.floatValue() - this.occupiedArea.getBBox().getHeight()));
                }
                if ((height = this.retrieveHeight()) != null) {
                    overflowRenderer.setProperty(27, Float.valueOf(height.floatValue() - this.occupiedArea.getBBox().getHeight()));
                }
                if (wasHeightClipped) {
                    this.occupiedArea.getBBox().moveDown(blockMaxHeight.floatValue() - this.occupiedArea.getBBox().getHeight()).setHeight(blockMaxHeight.floatValue());
                    Logger logger = LoggerFactory.getLogger(TableRenderer.class);
                    logger.warn("Element content was clipped because some height properties are set.");
                }
                this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
                this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                this.applyMargins(this.occupiedArea.getBBox(), true);
                if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) || wasHeightClipped) {
                    return new LayoutResult(1, this.occupiedArea, splitRenderer, null, null);
                }
                if (layoutResult != 3) {
                    return new LayoutResult(layoutResult, this.occupiedArea, splitRenderer, overflowRenderer, null).setAreaBreak(result.getAreaBreak());
                }
                return new LayoutResult(layoutResult, null, null, overflowRenderer, result.getCauseOfNothing()).setAreaBreak(result.getAreaBreak());
            }
            anythingPlaced = true;
            if (result.getOccupiedArea() != null) {
                this.occupiedArea.setBBox(Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{this.occupiedArea.getBBox(), result.getOccupiedArea().getBBox()}));
            }
            if (marginsCollapsingEnabled && !childRenderer.hasProperty(99)) {
                marginsCollapseHandler.endChildMarginsHandling(layoutBox);
            }
            if (result.getStatus() == 1) {
                layoutBox.setHeight(result.getOccupiedArea().getBBox().getY() - layoutBox.getY());
                if (childRenderer.getOccupiedArea() != null) {
                    this.alignChildHorizontally(childRenderer, this.occupiedArea.getBBox());
                }
            }
            if (null != causeOfNothing || null == result.getCauseOfNothing()) continue;
            causeOfNothing = result.getCauseOfNothing();
        }
        if (marginsCollapsingEnabled && !isCellRenderer) {
            marginsCollapseHandler.endMarginsCollapse(layoutBox);
        }
        if (Boolean.TRUE.equals(this.getPropertyAsBoolean(86))) {
            this.occupiedArea.setBBox(Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{this.occupiedArea.getBBox(), layoutBox}));
        }
        AbstractRenderer overflowRenderer = null;
        Float blockMinHeight = this.retrieveMinHeight();
        if (!Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) && null != blockMinHeight && blockMinHeight.floatValue() > this.occupiedArea.getBBox().getHeight()) {
            if (this.isFixedLayout()) {
                this.occupiedArea.getBBox().moveDown(blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight()).setHeight(blockMinHeight.floatValue());
            } else {
                float blockBottom = Math.max(this.occupiedArea.getBBox().getBottom() - (blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight()), layoutBox.getBottom());
                this.occupiedArea.getBBox().increaseHeight(this.occupiedArea.getBBox().getBottom() - blockBottom).setY(blockBottom);
                blockMinHeight = Float.valueOf(blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight());
                if (!this.isFixedLayout() && blockMinHeight.floatValue() > 1.0E-4f) {
                    if (this.isKeepTogether()) {
                        return new LayoutResult(3, null, null, this, this);
                    }
                    overflowRenderer = this.createOverflowRenderer(2);
                    overflowRenderer.setProperty(85, Float.valueOf(blockMinHeight.floatValue()));
                    if (this.hasProperty(27)) {
                        overflowRenderer.setProperty(27, Float.valueOf(this.retrieveHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
                    }
                }
            }
        }
        if (isPositioned) {
            this.correctPositionedLayout(layoutBox);
        }
        float initialWidth = this.occupiedArea.getBBox().getWidth();
        this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
        this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
        if (this.positionedRenderers.size() > 0) {
            LayoutArea area = new LayoutArea(this.occupiedArea.getPageNumber(), this.occupiedArea.getBBox().clone());
            this.applyBorderBox(area.getBBox(), false);
            for (IRenderer childPositionedRenderer : this.positionedRenderers) {
                childPositionedRenderer.setParent(this).layout(new LayoutContext(area));
            }
            this.applyBorderBox(area.getBBox(), true);
        }
        Rectangle rect = this.applyMargins(this.occupiedArea.getBBox(), true);
        childrenMaxWidth = Float.valueOf(childrenMaxWidth.floatValue() != 0.0f ? childrenMaxWidth.floatValue() + rect.getWidth() - initialWidth : 0.0f);
        if (this.getProperty(55) != null) {
            this.applyRotationLayout(layoutContext.getArea().getBBox().clone());
            if (this.isNotFittingLayoutArea(layoutContext.getArea()) && !Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                return new LayoutResult(3, null, null, this, this);
            }
        }
        this.applyVerticalAlignment();
        this.removeUnnecessaryFloatRendererAreas(floatRendererAreas);
        LayoutArea editedArea = this.applyFloatPropertyOnCurrentArea(floatRendererAreas, layoutContext.getArea().getBBox().getWidth(), childrenMaxWidth);
        if (floatPropertyValue != null && !floatPropertyValue.equals((Object)FloatPropertyValue.NONE)) {
            float bottomMargin;
            Document document = this.getDocument();
            float f = bottomMargin = document == null ? 0.0f : document.getBottomMargin();
            if (this.occupiedArea.getBBox().getY() < bottomMargin) {
                floatRendererAreas.clear();
                return new LayoutResult(3, null, null, this, null);
            }
        }
        this.adjustLayoutAreaIfClearPropertyPresent(clearHeightCorrection, editedArea, floatPropertyValue);
        if (null == overflowRenderer) {
            return new LayoutResult(1, editedArea, null, null, causeOfNothing);
        }
        return new LayoutResult(2, editedArea, this, overflowRenderer, causeOfNothing);
    }

    protected AbstractRenderer createSplitRenderer(int layoutResult) {
        AbstractRenderer splitRenderer = (AbstractRenderer)this.getNextRenderer();
        splitRenderer.parent = this.parent;
        splitRenderer.modelElement = this.modelElement;
        splitRenderer.occupiedArea = this.occupiedArea;
        splitRenderer.isLastRendererForModelElement = false;
        splitRenderer.properties = new HashMap<Integer, Object>(this.properties);
        return splitRenderer;
    }

    protected AbstractRenderer createOverflowRenderer(int layoutResult) {
        AbstractRenderer overflowRenderer = (AbstractRenderer)this.getNextRenderer();
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        overflowRenderer.properties = new HashMap<Integer, Object>(this.properties);
        return overflowRenderer;
    }

    @Override
    public void draw(DrawContext drawContext) {
        if (this.occupiedArea == null) {
            Logger logger = LoggerFactory.getLogger(BlockRenderer.class);
            logger.error("Occupied area hasn't been initialized. Drawing won't be performed");
            return;
        }
        PdfDocument document = drawContext.getDocument();
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        TagTreePointer tagPointer = null;
        IAccessibleElement accessibleElement = null;
        if (isTagged) {
            accessibleElement = (IAccessibleElement)this.getModelElement();
            PdfName role = accessibleElement.getRole();
            if (role != null && !PdfName.Artifact.equals((Object)role)) {
                tagPointer = document.getTagStructureContext().getAutoTaggingPointer();
                boolean alreadyCreated = tagPointer.isElementConnectedToTag(accessibleElement);
                tagPointer.addTag(accessibleElement, true);
                if (!alreadyCreated) {
                    if (role.equals((Object)PdfName.L)) {
                        PdfDictionary listAttributes = AccessibleAttributesApplier.getListAttributes(this, tagPointer);
                        BlockRenderer.applyGeneratedAccessibleAttributes(tagPointer, listAttributes);
                    }
                    if (role.equals((Object)PdfName.TD) || role.equals((Object)PdfName.TH)) {
                        PdfDictionary tableAttributes = AccessibleAttributesApplier.getTableAttributes(this, tagPointer);
                        BlockRenderer.applyGeneratedAccessibleAttributes(tagPointer, tableAttributes);
                    }
                    PdfDictionary layoutAttributes = AccessibleAttributesApplier.getLayoutAttributes(role, this, tagPointer);
                    BlockRenderer.applyGeneratedAccessibleAttributes(tagPointer, layoutAttributes);
                }
            } else {
                isTagged = false;
            }
        }
        this.applyDestinationsAndAnnotation(drawContext);
        boolean isRelativePosition = this.isRelativePosition();
        if (isRelativePosition) {
            this.applyRelativePositioningTranslation(false);
        }
        this.beginElementOpacityApplying(drawContext);
        this.beginRotationIfApplied(drawContext.getCanvas());
        this.drawBackground(drawContext);
        this.drawBorder(drawContext);
        this.drawChildren(drawContext);
        this.drawPositionedChildren(drawContext);
        this.endRotationIfApplied(drawContext.getCanvas());
        this.endElementOpacityApplying(drawContext);
        if (isRelativePosition) {
            this.applyRelativePositioningTranslation(true);
        }
        if (isTagged) {
            tagPointer.moveToParent();
            if (this.isLastRendererForModelElement) {
                document.getTagStructureContext().removeElementConnectionToTag(accessibleElement);
            }
        }
        this.flushed = true;
    }

    @Override
    public Rectangle getOccupiedAreaBBox() {
        Rectangle bBox = this.occupiedArea.getBBox().clone();
        Float rotationAngle = (Float)this.getProperty(55);
        if (rotationAngle != null) {
            if (!this.hasOwnProperty(57) || !this.hasOwnProperty(56)) {
                Logger logger = LoggerFactory.getLogger(BlockRenderer.class);
                logger.error(MessageFormat.format("Rotation was not correctly processed for {0}", this.getClass().getSimpleName()));
            } else {
                bBox.setWidth(this.getPropertyAsFloat(57).floatValue());
                bBox.setHeight(this.getPropertyAsFloat(56).floatValue());
            }
        }
        return bBox;
    }

    protected void applyVerticalAlignment() {
        VerticalAlignment verticalAlignment = (VerticalAlignment)((Object)this.getProperty(75));
        if (verticalAlignment != null && verticalAlignment != VerticalAlignment.TOP && this.childRenderers.size() > 0) {
            LayoutArea lastChildOccupiedArea = ((IRenderer)this.childRenderers.get(this.childRenderers.size() - 1)).getOccupiedArea();
            float deltaY = lastChildOccupiedArea.getBBox().getY() - this.getInnerAreaBBox().getY();
            switch (verticalAlignment) {
                case BOTTOM: {
                    for (IRenderer child : this.childRenderers) {
                        child.move(0.0f, -deltaY);
                    }
                    break;
                }
                case MIDDLE: {
                    for (IRenderer child : this.childRenderers) {
                        child.move(0.0f, -deltaY / 2.0f);
                    }
                    break;
                }
            }
        }
    }

    protected void applyRotationLayout(Rectangle layoutBox) {
        float angle = this.getPropertyAsFloat(55).floatValue();
        float x = this.occupiedArea.getBBox().getX();
        float y = this.occupiedArea.getBBox().getY();
        float height = this.occupiedArea.getBBox().getHeight();
        float width = this.occupiedArea.getBBox().getWidth();
        this.setProperty(57, Float.valueOf(width));
        this.setProperty(56, Float.valueOf(height));
        AffineTransform rotationTransform = new AffineTransform();
        if (this.isPositioned()) {
            Float rotationPointX = this.getPropertyAsFloat(58);
            Float rotationPointY = this.getPropertyAsFloat(59);
            if (rotationPointX == null || rotationPointY == null) {
                rotationPointX = Float.valueOf(x);
                rotationPointY = Float.valueOf(y);
            }
            rotationTransform.translate((double)rotationPointX.floatValue(), (double)rotationPointY.floatValue());
            rotationTransform.rotate((double)angle);
            rotationTransform.translate((double)(-rotationPointX.floatValue()), (double)(-rotationPointY.floatValue()));
            List<Point> rotatedPoints = this.transformPoints(this.rectangleToPointsList(this.occupiedArea.getBBox()), rotationTransform);
            Rectangle newBBox = this.calculateBBox(rotatedPoints);
            this.occupiedArea.getBBox().setWidth(newBBox.getWidth());
            this.occupiedArea.getBBox().setHeight(newBBox.getHeight());
            float occupiedAreaShiftX = newBBox.getX() - x;
            float occupiedAreaShiftY = newBBox.getY() - y;
            this.move(occupiedAreaShiftX, occupiedAreaShiftY);
        } else {
            rotationTransform = AffineTransform.getRotateInstance((double)angle);
            List<Point> rotatedPoints = this.transformPoints(this.rectangleToPointsList(this.occupiedArea.getBBox()), rotationTransform);
            float[] shift = this.calculateShiftToPositionBBoxOfPointsAt(x, y + height, rotatedPoints);
            for (Point point : rotatedPoints) {
                point.setLocation(point.getX() + (double)shift[0], point.getY() + (double)shift[1]);
            }
            Rectangle newBBox = this.calculateBBox(rotatedPoints);
            this.occupiedArea.getBBox().setWidth(newBBox.getWidth());
            this.occupiedArea.getBBox().setHeight(newBBox.getHeight());
            float heightDiff = height - newBBox.getHeight();
            this.move(0.0f, heightDiff);
        }
    }

    @Deprecated
    protected float[] applyRotation() {
        float[] ctm = new float[6];
        this.createRotationTransformInsideOccupiedArea().getMatrix(ctm);
        return ctm;
    }

    protected AffineTransform createRotationTransformInsideOccupiedArea() {
        Float angle = (Float)this.getProperty(55);
        AffineTransform rotationTransform = AffineTransform.getRotateInstance((double)angle.floatValue());
        Rectangle contentBox = this.getOccupiedAreaBBox();
        List<Point> rotatedContentBoxPoints = this.transformPoints(this.rectangleToPointsList(contentBox), rotationTransform);
        float[] shift = this.calculateShiftToPositionBBoxOfPointsAt(this.occupiedArea.getBBox().getLeft(), this.occupiedArea.getBBox().getTop(), rotatedContentBoxPoints);
        rotationTransform.preConcatenate(AffineTransform.getTranslateInstance((double)shift[0], (double)shift[1]));
        return rotationTransform;
    }

    protected void beginRotationIfApplied(PdfCanvas canvas) {
        Float angle = this.getPropertyAsFloat(55);
        if (angle != null) {
            if (!this.hasOwnProperty(56)) {
                Logger logger = LoggerFactory.getLogger(BlockRenderer.class);
                logger.error(MessageFormat.format("Rotation was not correctly processed for {0}", this.getClass().getSimpleName()));
            } else {
                AffineTransform transform = this.createRotationTransformInsideOccupiedArea();
                canvas.saveState().concatMatrix(transform);
            }
        }
    }

    protected void endRotationIfApplied(PdfCanvas canvas) {
        Float angle = this.getPropertyAsFloat(55);
        if (angle != null) {
            canvas.restoreState();
        }
    }

    protected void correctPositionedLayout(Rectangle layoutBox) {
        if (this.isFixedLayout()) {
            float y = this.getPropertyAsFloat(80).floatValue();
            float relativeY = this.isFixedLayout() ? 0.0f : layoutBox.getY();
            this.move(0.0f, relativeY + y - this.occupiedArea.getBBox().getY());
        }
    }

    protected float applyBordersPaddingsMargins(Rectangle parentBBox, Border[] borders, float[] paddings) {
        float parentWidth = parentBBox.getWidth();
        this.applyMargins(parentBBox, false);
        this.applyBorderBox(parentBBox, borders, false);
        if (this.isPositioned()) {
            if (this.isFixedLayout()) {
                float x = this.getPropertyAsFloat(79).floatValue();
                float relativeX = this.isFixedLayout() ? 0.0f : parentBBox.getX();
                parentBBox.setX(relativeX + x);
            } else if (this.isAbsolutePosition()) {
                this.applyAbsolutePosition(parentBBox);
            }
        }
        this.applyPaddings(parentBBox, paddings, false);
        return parentWidth - parentBBox.getWidth();
    }

    @Override
    protected MinMaxWidth getMinMaxWidth(float availableWidth) {
        Rectangle area = new Rectangle(availableWidth, 1000000.0f);
        float additionalWidth = this.applyBordersPaddingsMargins(area, this.getBorders(), this.getPaddings());
        MinMaxWidth minMaxWidth = new MinMaxWidth(additionalWidth, availableWidth);
        MaxMaxWidthHandler handler = new MaxMaxWidthHandler(minMaxWidth);
        for (IRenderer childRenderer : this.childRenderers) {
            childRenderer.setParent(this);
            MinMaxWidth childMinMaxWidth = childRenderer instanceof AbstractRenderer ? ((AbstractRenderer)childRenderer).getMinMaxWidth(area.getWidth()) : MinMaxWidthUtils.countDefaultMinMaxWidth(childRenderer, area.getWidth());
            ((AbstractWidthHandler)handler).updateMaxChildWidth(childMinMaxWidth.getMaxWidth());
            ((AbstractWidthHandler)handler).updateMinChildWidth(childMinMaxWidth.getMinWidth());
        }
        return this.countRotationMinMaxWidth(this.correctMinMaxWidth(minMaxWidth));
    }

    MinMaxWidth countRotationMinMaxWidth(MinMaxWidth minMaxWidth) {
        Float rotation = this.getPropertyAsFloat(55);
        if (rotation != null) {
            boolean restoreRendererRotation = this.hasOwnProperty(55);
            this.setProperty(55, null);
            LayoutResult result = this.layout(new LayoutContext(new LayoutArea(1, new Rectangle(minMaxWidth.getMaxWidth() + MinMaxWidthUtils.getEps(), 1000000.0f))));
            if (restoreRendererRotation) {
                this.setProperty(55, rotation);
            } else {
                this.deleteOwnProperty(55);
            }
            if (result.getOccupiedArea() != null) {
                double a = result.getOccupiedArea().getBBox().getWidth();
                double b = result.getOccupiedArea().getBBox().getHeight();
                double m = minMaxWidth.getMinWidth();
                double s = a * b;
                double resultMinWidth = Math.sqrt(2.0 * s);
                if (Math.sqrt(s) < (double)minMaxWidth.getMinWidth()) {
                    resultMinWidth = Math.max(resultMinWidth, Math.sqrt(s / m * (s / m) + m * m));
                }
                return new MinMaxWidth(0.0f, minMaxWidth.getAvailableWidth(), (float)resultMinWidth, (float)Math.sqrt(a * a + b * b));
            }
        }
        return minMaxWidth;
    }

    MinMaxWidth correctMinMaxWidth(MinMaxWidth minMaxWidth) {
        Float width = this.retrieveWidth(-1.0f);
        if (width != null && width.floatValue() >= 0.0f && width.floatValue() >= minMaxWidth.getChildrenMinWidth()) {
            minMaxWidth.setChildrenMaxWidth(width.floatValue());
            minMaxWidth.setChildrenMinWidth(width.floatValue());
        }
        return minMaxWidth;
    }

    private List<Point> clipPolygon(List<Point> points, Point clipLineBeg, Point clipLineEnd) {
        ArrayList<Point> filteredPoints = new ArrayList<Point>();
        boolean prevOnRightSide = false;
        Point filteringPoint = points.get(0);
        if (this.checkPointSide(filteringPoint, clipLineBeg, clipLineEnd) >= 0) {
            filteredPoints.add(filteringPoint);
            prevOnRightSide = true;
        }
        Point prevPoint = filteringPoint;
        for (int i = 1; i < points.size() + 1; ++i) {
            filteringPoint = points.get(i % points.size());
            if (this.checkPointSide(filteringPoint, clipLineBeg, clipLineEnd) >= 0) {
                if (!prevOnRightSide) {
                    filteredPoints.add(this.getIntersectionPoint(prevPoint, filteringPoint, clipLineBeg, clipLineEnd));
                }
                filteredPoints.add(filteringPoint);
                prevOnRightSide = true;
            } else if (prevOnRightSide) {
                filteredPoints.add(this.getIntersectionPoint(prevPoint, filteringPoint, clipLineBeg, clipLineEnd));
            }
            prevPoint = filteringPoint;
        }
        return filteredPoints;
    }

    private int checkPointSide(Point filteredPoint, Point clipLineBeg, Point clipLineEnd) {
        double y1;
        double x2;
        double y2;
        double x1 = filteredPoint.getX() - clipLineBeg.getX();
        double sgn = x1 * (y2 = clipLineEnd.getY() - clipLineBeg.getY()) - (x2 = clipLineEnd.getX() - clipLineBeg.getX()) * (y1 = filteredPoint.getY() - clipLineBeg.getY());
        if (Math.abs(sgn) < 0.001) {
            return 0;
        }
        if (sgn > 0.0) {
            return 1;
        }
        if (sgn < 0.0) {
            return -1;
        }
        return 0;
    }

    private Point getIntersectionPoint(Point lineBeg, Point lineEnd, Point clipLineBeg, Point clipLineEnd) {
        double A1 = lineBeg.getY() - lineEnd.getY();
        double A2 = clipLineBeg.getY() - clipLineEnd.getY();
        double B1 = lineEnd.getX() - lineBeg.getX();
        double B2 = clipLineEnd.getX() - clipLineBeg.getX();
        double C1 = lineBeg.getX() * lineEnd.getY() - lineBeg.getY() * lineEnd.getX();
        double C2 = clipLineBeg.getX() * clipLineEnd.getY() - clipLineBeg.getY() * clipLineEnd.getX();
        double M = B1 * A2 - B2 * A1;
        return new Point((B2 * C1 - B1 * C2) / M, (C2 * A1 - C1 * A2) / M);
    }
}

