/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.LineLayoutResult;
import com.itextpdf.layout.layout.MinMaxWidthLayoutResult;
import com.itextpdf.layout.margincollapse.MarginsCollapseHandler;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.property.Leading;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.renderer.AbstractWidthHandler;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.MaxMaxWidthHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphRenderer
extends BlockRenderer {
    protected float previousDescent = 0.0f;
    protected List<LineRenderer> lines = null;

    public ParagraphRenderer(Paragraph modelElement) {
        super(modelElement);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        this.overrideHeightProperties();
        boolean wasHeightClipped = false;
        int pageNumber = layoutContext.getArea().getPageNumber();
        boolean anythingPlaced = false;
        boolean firstLineInBox = true;
        LineRenderer currentRenderer = (LineRenderer)new LineRenderer().setParent(this);
        Rectangle parentBBox = layoutContext.getArea().getBBox().clone();
        Float blockWidth = this.retrieveWidth(parentBBox.getWidth());
        if (0 == this.childRenderers.size()) {
            anythingPlaced = true;
            currentRenderer = null;
        }
        boolean isPositioned = this.isPositioned();
        if (this.getProperty(55) != null) {
            parentBBox.moveDown(1000000.0f - parentBBox.getHeight()).setHeight(1000000.0f);
        }
        MarginsCollapseHandler marginsCollapseHandler = null;
        boolean marginsCollapsingEnabled = Boolean.TRUE.equals(this.getPropertyAsBoolean(89));
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler = new MarginsCollapseHandler(this, layoutContext.getMarginsCollapseInfo());
            marginsCollapseHandler.startMarginsCollapse(parentBBox);
        }
        Border[] borders = this.getBorders();
        float[] paddings = this.getPaddings();
        float additionalWidth = this.applyBordersPaddingsMargins(parentBBox, borders, paddings);
        if (blockWidth != null && (blockWidth.floatValue() < parentBBox.getWidth() || isPositioned)) {
            parentBBox.setWidth(blockWidth.floatValue());
        }
        MinMaxWidth minMaxWidth = new MinMaxWidth(additionalWidth, layoutContext.getArea().getBBox().getWidth());
        MaxMaxWidthHandler widthHandler = new MaxMaxWidthHandler(minMaxWidth);
        Float blockMaxHeight = this.retrieveMaxHeight();
        if (null != blockMaxHeight && parentBBox.getHeight() > blockMaxHeight.floatValue()) {
            float heightDelta = parentBBox.getHeight() - blockMaxHeight.floatValue();
            if (marginsCollapsingEnabled) {
                marginsCollapseHandler.processFixedHeightAdjustment(heightDelta);
            }
            parentBBox.moveUp(heightDelta).setHeight(blockMaxHeight.floatValue());
            wasHeightClipped = true;
        }
        List<Rectangle> areas = isPositioned ? Collections.singletonList(parentBBox) : this.initElementAreas(new LayoutArea(pageNumber, parentBBox));
        this.occupiedArea = new LayoutArea(pageNumber, new Rectangle(parentBBox.getX(), parentBBox.getY() + parentBBox.getHeight(), parentBBox.getWidth(), 0.0f));
        this.shrinkOccupiedAreaForAbsolutePosition();
        int currentAreaPos = 0;
        Rectangle layoutBox = areas.get(0).clone();
        this.lines = new ArrayList<LineRenderer>();
        for (IRenderer child : this.childRenderers) {
            currentRenderer.addChild(child);
        }
        float lastYLine = layoutBox.getY() + layoutBox.getHeight();
        Leading leading = (Leading)this.getProperty(33);
        float leadingValue = 0.0f;
        float lastLineHeight = 0.0f;
        if (marginsCollapsingEnabled && this.childRenderers.size() > 0) {
            marginsCollapseHandler.startChildMarginsHandling(null, layoutBox);
        }
        while (currentRenderer != null) {
            currentRenderer.setProperty(67, this.getPropertyAsFloat(67));
            currentRenderer.setProperty(69, this.getProperty(69));
            float lineIndent = anythingPlaced ? 0.0f : this.getPropertyAsFloat(18).floatValue();
            float childBBoxWidth = layoutBox.getWidth() - lineIndent;
            Rectangle childLayoutBox = new Rectangle(layoutBox.getX() + lineIndent, layoutBox.getY(), childBBoxWidth, layoutBox.getHeight());
            LineLayoutResult result = ((LineRenderer)currentRenderer.setParent(this)).layout(new LayoutContext(new LayoutArea(pageNumber, childLayoutBox)));
            float minChildWidth = 0.0f;
            float maxChildWidth = 0.0f;
            if (result instanceof MinMaxWidthLayoutResult) {
                minChildWidth = result.getNotNullMinMaxWidth(childBBoxWidth).getMinWidth();
                maxChildWidth = result.getNotNullMinMaxWidth(childBBoxWidth).getMaxWidth();
            }
            ((AbstractWidthHandler)widthHandler).updateMinChildWidth(minChildWidth + lineIndent);
            ((AbstractWidthHandler)widthHandler).updateMaxChildWidth(maxChildWidth + lineIndent);
            LineRenderer processedRenderer = null;
            if (result.getStatus() == 1) {
                processedRenderer = currentRenderer;
            } else if (result.getStatus() == 2) {
                processedRenderer = (LineRenderer)result.getSplitRenderer();
            }
            TextAlignment textAlignment = this.getProperty(70, TextAlignment.LEFT);
            if (result.getStatus() == 2 && textAlignment == TextAlignment.JUSTIFIED && !result.isSplitForcedByNewline() || textAlignment == TextAlignment.JUSTIFIED_ALL) {
                if (processedRenderer != null) {
                    processedRenderer.justify(layoutBox.getWidth() - lineIndent);
                }
            } else if (textAlignment != TextAlignment.LEFT && processedRenderer != null) {
                float deltaX = childBBoxWidth - processedRenderer.getOccupiedArea().getBBox().getWidth();
                switch (textAlignment) {
                    case RIGHT: {
                        processedRenderer.move(deltaX, 0.0f);
                        break;
                    }
                    case CENTER: {
                        processedRenderer.move(deltaX / 2.0f, 0.0f);
                    }
                }
            }
            float f = leadingValue = processedRenderer != null && leading != null ? processedRenderer.getLeadingValue(leading) : 0.0f;
            if (processedRenderer != null && processedRenderer.containsImage()) {
                leadingValue -= this.previousDescent;
            }
            boolean doesNotFit = result.getStatus() == 3;
            float deltaY = 0.0f;
            if (!doesNotFit) {
                lastLineHeight = processedRenderer.getOccupiedArea().getBBox().getHeight();
                deltaY = lastYLine - leadingValue - processedRenderer.getYLine();
                if (firstLineInBox) {
                    deltaY = -(leadingValue - lastLineHeight) / 2.0f;
                }
                boolean bl = doesNotFit = leading != null && processedRenderer.getOccupiedArea().getBBox().getY() + deltaY < layoutBox.getY();
            }
            if (doesNotFit) {
                if (currentAreaPos + 1 < areas.size()) {
                    layoutBox = areas.get(++currentAreaPos).clone();
                    lastYLine = layoutBox.getY() + layoutBox.getHeight();
                    firstLineInBox = true;
                    continue;
                }
                boolean keepTogether = this.isKeepTogether();
                if (keepTogether) {
                    return new MinMaxWidthLayoutResult(3, null, null, this, null == result.getCauseOfNothing() ? this : result.getCauseOfNothing());
                }
                if (marginsCollapsingEnabled) {
                    if (anythingPlaced) {
                        marginsCollapseHandler.endChildMarginsHandling(layoutBox);
                    }
                    marginsCollapseHandler.endMarginsCollapse(layoutBox);
                }
                ParagraphRenderer[] split = this.split();
                split[0].lines = this.lines;
                for (LineRenderer line : this.lines) {
                    split[0].childRenderers.addAll(line.getChildRenderers());
                }
                if (processedRenderer != null) {
                    split[1].childRenderers.addAll(processedRenderer.getChildRenderers());
                }
                if (result.getOverflowRenderer() != null) {
                    split[1].childRenderers.addAll(result.getOverflowRenderer().getChildRenderers());
                }
                if (this.hasProperty(84)) {
                    if (isPositioned) {
                        this.correctPositionedLayout(layoutBox);
                    }
                    split[1].setProperty(84, Float.valueOf(this.retrieveMaxHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
                }
                if (this.hasProperty(85)) {
                    split[1].setProperty(85, Float.valueOf(this.retrieveMinHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
                }
                if (this.hasProperty(27)) {
                    split[1].setProperty(27, Float.valueOf(this.retrieveHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
                }
                if (wasHeightClipped) {
                    split[0].getOccupiedArea().getBBox().moveDown(blockMaxHeight.floatValue() - this.occupiedArea.getBBox().getHeight()).setHeight(blockMaxHeight.floatValue());
                    Logger logger = LoggerFactory.getLogger(ParagraphRenderer.class);
                    logger.warn("Element content was clipped because some height properties are set.");
                }
                this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
                this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                this.applyMargins(this.occupiedArea.getBBox(), true);
                if (wasHeightClipped) {
                    return new MinMaxWidthLayoutResult(1, this.occupiedArea, split[0], null).setMinMaxWidth(minMaxWidth);
                }
                if (anythingPlaced) {
                    return new MinMaxWidthLayoutResult(2, this.occupiedArea, split[0], split[1]).setMinMaxWidth(minMaxWidth);
                }
                if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                    this.occupiedArea.setBBox(Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{this.occupiedArea.getBBox(), currentRenderer.getOccupiedArea().getBBox()}));
                    this.parent.setProperty(25, true);
                    this.lines.add(currentRenderer);
                    if (2 == result.getStatus()) {
                        IRenderer childNotRendered = result.getCauseOfNothing();
                        int firstNotRendered = currentRenderer.childRenderers.indexOf(childNotRendered);
                        currentRenderer.childRenderers.retainAll(currentRenderer.childRenderers.subList(0, firstNotRendered));
                        split[1].childRenderers.removeAll(split[1].childRenderers.subList(0, firstNotRendered));
                        return new MinMaxWidthLayoutResult(2, this.occupiedArea, this, split[1]).setMinMaxWidth(minMaxWidth);
                    }
                    return new MinMaxWidthLayoutResult(1, this.occupiedArea, null, null, this).setMinMaxWidth(minMaxWidth);
                }
                return new MinMaxWidthLayoutResult(3, null, null, this, null == result.getCauseOfNothing() ? this : result.getCauseOfNothing());
            }
            if (leading != null) {
                processedRenderer.move(0.0f, deltaY);
                lastYLine = processedRenderer.getYLine();
            }
            this.occupiedArea.setBBox(Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{this.occupiedArea.getBBox(), processedRenderer.getOccupiedArea().getBBox()}));
            layoutBox.setHeight(processedRenderer.getOccupiedArea().getBBox().getY() - layoutBox.getY());
            this.lines.add(processedRenderer);
            anythingPlaced = true;
            firstLineInBox = false;
            currentRenderer = (LineRenderer)result.getOverflowRenderer();
            this.previousDescent = processedRenderer.getMaxDescent();
        }
        if (marginsCollapsingEnabled) {
            if (this.childRenderers.size() > 0) {
                marginsCollapseHandler.endChildMarginsHandling(layoutBox);
            }
            marginsCollapseHandler.endMarginsCollapse(layoutBox);
        }
        float moveDown = Math.min((leadingValue - lastLineHeight) / 2.0f, this.occupiedArea.getBBox().getY() - layoutBox.getY());
        this.occupiedArea.getBBox().moveDown(moveDown);
        this.occupiedArea.getBBox().setHeight(this.occupiedArea.getBBox().getHeight() + moveDown);
        ParagraphRenderer overflowRenderer = null;
        Float blockMinHeight = this.retrieveMinHeight();
        if (null != blockMinHeight && blockMinHeight.floatValue() > this.occupiedArea.getBBox().getHeight()) {
            float blockBottom = this.occupiedArea.getBBox().getBottom() - (blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight());
            if (blockBottom >= layoutContext.getArea().getBBox().getBottom()) {
                this.occupiedArea.getBBox().setY(blockBottom).setHeight(blockMinHeight.floatValue());
            } else {
                this.occupiedArea.getBBox().increaseHeight(this.occupiedArea.getBBox().getBottom() - layoutContext.getArea().getBBox().getBottom()).setY(layoutContext.getArea().getBBox().getBottom());
                overflowRenderer = this.createOverflowRenderer(this.parent);
                overflowRenderer.setProperty(85, Float.valueOf(blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight()));
                if (this.hasProperty(27)) {
                    overflowRenderer.setProperty(27, Float.valueOf(this.retrieveHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
                }
            }
            this.applyVerticalAlignment();
        }
        if (isPositioned) {
            this.correctPositionedLayout(layoutBox);
        }
        this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
        this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
        this.applyMargins(this.occupiedArea.getBBox(), true);
        if (this.getProperty(55) != null) {
            this.applyRotationLayout(layoutContext.getArea().getBBox().clone());
            if (this.isNotFittingLayoutArea(layoutContext.getArea()) && !Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                return new MinMaxWidthLayoutResult(3, null, null, this, this);
            }
        }
        if (null == overflowRenderer) {
            return new MinMaxWidthLayoutResult(1, this.occupiedArea, null, null).setMinMaxWidth(minMaxWidth);
        }
        return new MinMaxWidthLayoutResult(2, this.occupiedArea, this, overflowRenderer).setMinMaxWidth(minMaxWidth);
    }

    @Override
    public IRenderer getNextRenderer() {
        return new ParagraphRenderer((Paragraph)this.modelElement);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        if ((property == 46 || property == 43) && this.parent instanceof CellRenderer) {
            return (T1)Float.valueOf(0.0f);
        }
        return super.getDefaultProperty(property);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.lines != null && this.lines.size() > 0) {
            for (int i = 0; i < this.lines.size(); ++i) {
                if (i > 0) {
                    sb.append("\n");
                }
                sb.append(this.lines.get(i).toString());
            }
        } else {
            for (IRenderer renderer : this.childRenderers) {
                sb.append(renderer.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public void drawChildren(DrawContext drawContext) {
        if (this.lines != null) {
            for (LineRenderer line : this.lines) {
                line.draw(drawContext);
            }
        }
    }

    @Override
    public void move(float dxRight, float dyUp) {
        this.occupiedArea.getBBox().moveRight(dxRight);
        this.occupiedArea.getBBox().moveUp(dyUp);
        for (LineRenderer line : this.lines) {
            line.move(dxRight, dyUp);
        }
    }

    public List<LineRenderer> getLines() {
        return this.lines;
    }

    @Override
    protected Float getFirstYLineRecursively() {
        if (this.lines == null || this.lines.size() == 0) {
            return null;
        }
        return this.lines.get(0).getFirstYLineRecursively();
    }

    @Deprecated
    protected ParagraphRenderer createOverflowRenderer() {
        return (ParagraphRenderer)this.getNextRenderer();
    }

    @Deprecated
    protected ParagraphRenderer createSplitRenderer() {
        return (ParagraphRenderer)this.getNextRenderer();
    }

    protected ParagraphRenderer createOverflowRenderer(IRenderer parent) {
        ParagraphRenderer overflowRenderer = this.createOverflowRenderer();
        overflowRenderer.parent = parent;
        this.fixOverflowRenderer(overflowRenderer);
        return overflowRenderer;
    }

    protected ParagraphRenderer createSplitRenderer(IRenderer parent) {
        ParagraphRenderer splitRenderer = this.createSplitRenderer();
        splitRenderer.parent = parent;
        splitRenderer.properties = new HashMap(this.properties);
        return splitRenderer;
    }

    @Override
    protected MinMaxWidth getMinMaxWidth(float availableWidth) {
        MinMaxWidthLayoutResult result = (MinMaxWidthLayoutResult)this.layout(new LayoutContext(new LayoutArea(1, new Rectangle(availableWidth, 1000000.0f))));
        return this.countRotationMinMaxWidth(this.correctMinMaxWidth(result.getNotNullMinMaxWidth(availableWidth)));
    }

    protected ParagraphRenderer[] split() {
        ParagraphRenderer splitRenderer = this.createSplitRenderer(this.parent);
        splitRenderer.occupiedArea = this.occupiedArea;
        splitRenderer.isLastRendererForModelElement = false;
        ParagraphRenderer overflowRenderer = this.createOverflowRenderer(this.parent);
        return new ParagraphRenderer[]{splitRenderer, overflowRenderer};
    }

    private void fixOverflowRenderer(ParagraphRenderer overflowRenderer) {
        float firstLineIndent = overflowRenderer.getPropertyAsFloat(18).floatValue();
        if (firstLineIndent != 0.0f) {
            overflowRenderer.setProperty(18, 0);
        }
    }
}

