/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.property.VerticalAlignment;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AccessibleAttributesApplier;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRenderer
extends AbstractRenderer {
    protected List<CellRenderer[]> rows = new ArrayList<CellRenderer[]>();
    protected Table.RowRange rowRange;
    protected TableRenderer headerRenderer;
    protected TableRenderer footerRenderer;
    protected boolean isOriginalNonSplitRenderer = true;
    private ArrayList<ArrayList<Border>> horizontalBorders;
    private ArrayList<ArrayList<Border>> verticalBorders;
    private float[] columnWidths = null;
    private List<Float> heights = new ArrayList<Float>();

    private TableRenderer() {
    }

    public TableRenderer(Table modelElement, Table.RowRange rowRange) {
        super(modelElement);
        this.setRowRange(rowRange);
    }

    public TableRenderer(Table modelElement) {
        this(modelElement, new Table.RowRange(0, modelElement.getNumberOfRows() - 1));
    }

    @Override
    public void addChild(IRenderer renderer) {
        if (renderer instanceof CellRenderer) {
            Cell cell = (Cell)renderer.getModelElement();
            this.rows.get((int)(cell.getRow() - this.rowRange.getStartRow() + cell.getRowspan() - 1))[cell.getCol()] = (CellRenderer)renderer;
        } else {
            Logger logger = LoggerFactory.getLogger(TableRenderer.class);
            logger.error("Only BlockRenderer with Cell layout element could be added");
        }
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        Table footerElement;
        boolean headerShouldBeApplied;
        LayoutArea area = layoutContext.getArea();
        Rectangle layoutBox = area.getBBox().clone();
        if (!((Table)this.modelElement).isComplete()) {
            this.setProperty(43, 0);
        }
        if (this.rowRange.getStartRow() != 0) {
            this.setProperty(46, 0);
        }
        this.heights.clear();
        this.childRenderers.clear();
        HashMap<Integer, Integer> rowMoves = new HashMap<Integer, Integer>();
        this.applyMargins(layoutBox, false);
        this.applyBorderBox(layoutBox, false);
        if (this.isPositioned()) {
            float x = this.getPropertyAsFloat(79).floatValue();
            float relativeX = this.isFixedLayout() ? 0.0f : layoutBox.getX();
            layoutBox.setX(relativeX + x);
        }
        Table tableModel = (Table)this.getModelElement();
        Float tableWidth = this.retrieveWidth(layoutBox.getWidth());
        if (tableWidth == null || tableWidth.floatValue() == 0.0f) {
            tableWidth = Float.valueOf(layoutBox.getWidth());
        }
        this.occupiedArea = new LayoutArea(area.getPageNumber(), new Rectangle(layoutBox.getX(), layoutBox.getY() + layoutBox.getHeight(), tableWidth.floatValue(), 0.0f));
        int numberOfColumns = ((Table)this.getModelElement()).getNumberOfColumns();
        this.horizontalBorders = new ArrayList();
        this.verticalBorders = new ArrayList();
        Table headerElement = tableModel.getHeader();
        boolean isFirstHeader = this.rowRange.getStartRow() == 0 && this.isOriginalNonSplitRenderer;
        boolean bl = headerShouldBeApplied = !this.rows.isEmpty() && (!this.isOriginalNonSplitRenderer || isFirstHeader && !tableModel.isSkipFirstHeader());
        if (headerElement != null && headerShouldBeApplied) {
            this.headerRenderer = (TableRenderer)headerElement.createRendererSubTree().setParent(this);
            LayoutResult result = this.headerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox)));
            if (result.getStatus() != 1) {
                return new LayoutResult(3, null, null, this, result.getCauseOfNothing());
            }
            float headerHeight = result.getOccupiedArea().getBBox().getHeight();
            layoutBox.decreaseHeight(headerHeight);
            this.occupiedArea.getBBox().moveDown(headerHeight).increaseHeight(headerHeight);
        }
        if ((footerElement = tableModel.getFooter()) != null) {
            this.footerRenderer = (TableRenderer)footerElement.createRendererSubTree().setParent(this);
            LayoutResult result = this.footerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox)));
            if (result.getStatus() != 1) {
                return new LayoutResult(3, null, null, this, result.getCauseOfNothing());
            }
            float footerHeight = result.getOccupiedArea().getBBox().getHeight();
            this.footerRenderer.move(0.0f, -(layoutBox.getHeight() - footerHeight));
            layoutBox.moveUp(footerHeight).decreaseHeight(footerHeight);
        }
        this.columnWidths = this.calculateScaledColumnWidths(tableModel, tableWidth.floatValue());
        LayoutResult[] splits = new LayoutResult[tableModel.getNumberOfColumns()];
        int[] targetOverflowRowIndex = new int[tableModel.getNumberOfColumns()];
        this.horizontalBorders.add(tableModel.getLastRowBottomBorder());
        for (int row = 0; row < this.rows.size(); ++row) {
            if (row == 1 && Boolean.TRUE.equals(this.getOwnProperty(26))) {
                this.deleteOwnProperty(26);
            }
            CellRenderer[] currentRow = this.rows.get(row);
            float rowHeight = 0.0f;
            boolean split = false;
            boolean hasContent = true;
            boolean cellWithBigRowspanAdded = false;
            ArrayList<CellRenderer> currChildRenderers = new ArrayList<CellRenderer>();
            ArrayDeque<CellRendererInfo> cellProcessingQueue = new ArrayDeque<CellRendererInfo>();
            for (int col = 0; col < currentRow.length; ++col) {
                if (currentRow[col] == null) continue;
                cellProcessingQueue.addLast(new CellRendererInfo(currentRow[col], col, row));
            }
            IRenderer firstCauseOfNothing = null;
            while (cellProcessingQueue.size() > 0) {
                int i;
                CellRenderer nextCell;
                CellRendererInfo currentCellInfo = (CellRendererInfo)cellProcessingQueue.pop();
                int col = currentCellInfo.column;
                CellRenderer cell = currentCellInfo.cellRenderer;
                if (cell != null) {
                    this.buildBordersArrays(cell, row, true);
                }
                if (row + 1 < this.rows.size() && (nextCell = this.rows.get(row + 1)[col]) != null) {
                    this.buildBordersArrays(nextCell, row + 1, true);
                }
                if (col + 1 < this.rows.get(row).length && (nextCell = this.rows.get(row)[col + 1]) != null) {
                    this.buildBordersArrays(nextCell, row, true);
                }
                targetOverflowRowIndex[col] = currentCellInfo.finishRowInd;
                boolean currentCellHasBigRowspan = row != currentCellInfo.finishRowInd;
                int colspan = cell.getPropertyAsInteger(16);
                int rowspan = cell.getPropertyAsInteger(60);
                float cellWidth = 0.0f;
                float colOffset = 0.0f;
                for (i = col; i < col + colspan; ++i) {
                    cellWidth += this.columnWidths[i];
                }
                for (i = 0; i < col; ++i) {
                    colOffset += this.columnWidths[i];
                }
                float rowspanOffset = 0.0f;
                for (int i2 = row - 1; i2 > currentCellInfo.finishRowInd - rowspan && i2 >= 0; --i2) {
                    rowspanOffset += this.heights.get(i2).floatValue();
                }
                float cellLayoutBoxHeight = rowspanOffset + (!currentCellHasBigRowspan || hasContent ? layoutBox.getHeight() : 0.0f);
                float cellLayoutBoxBottom = layoutBox.getY() + (!currentCellHasBigRowspan || hasContent ? 0.0f : layoutBox.getHeight());
                Rectangle cellLayoutBox = new Rectangle(layoutBox.getX() + colOffset, cellLayoutBoxBottom, cellWidth, cellLayoutBoxHeight);
                LayoutArea cellArea = new LayoutArea(layoutContext.getArea().getPageNumber(), cellLayoutBox);
                VerticalAlignment verticalAlignment = (VerticalAlignment)((Object)cell.getProperty(75));
                cell.setProperty(75, null);
                LayoutResult cellResult = cell.setParent(this).layout(new LayoutContext(cellArea));
                cell.setProperty(75, (Object)verticalAlignment);
                if (cellResult.getStatus() != 3) {
                    cell.getOccupiedArea().getBBox().setWidth(cellWidth);
                } else if (null == firstCauseOfNothing) {
                    firstCauseOfNothing = cellResult.getCauseOfNothing();
                }
                if (currentCellHasBigRowspan) {
                    if (cellResult.getStatus() == 2) {
                        splits[col] = cellResult;
                        currentRow[col] = (CellRenderer)cellResult.getSplitRenderer();
                    } else {
                        this.rows.get((int)currentCellInfo.finishRowInd)[col] = null;
                        currentRow[col] = cell;
                        rowMoves.put(col, currentCellInfo.finishRowInd);
                    }
                } else if (cellResult.getStatus() != 1) {
                    if (!split) {
                        if (this.footerRenderer != null && tableModel.isSkipLastFooter() && tableModel.isComplete()) {
                            LayoutArea potentialArea = new LayoutArea(area.getPageNumber(), layoutBox.clone());
                            float footerHeight = this.footerRenderer.getOccupiedArea().getBBox().getHeight();
                            potentialArea.getBBox().moveDown(footerHeight).increaseHeight(footerHeight);
                            if (this.canFitRowsInGivenArea(potentialArea, row, this.columnWidths, this.heights)) {
                                layoutBox.increaseHeight(footerHeight).moveDown(footerHeight);
                                cellProcessingQueue.clear();
                                for (int addCol = 0; addCol < currentRow.length; ++addCol) {
                                    if (currentRow[addCol] == null) continue;
                                    cellProcessingQueue.addLast(new CellRendererInfo(currentRow[addCol], addCol, row));
                                }
                                this.footerRenderer = null;
                                continue;
                            }
                        }
                        block7: for (int addCol = 0; addCol < currentRow.length; ++addCol) {
                            if (currentRow[addCol] == null) {
                                for (int addRow = row + 1; addRow < this.rows.size(); ++addRow) {
                                    if (this.rows.get(addRow)[addCol] == null) continue;
                                    CellRenderer addRenderer = this.rows.get(addRow)[addCol];
                                    verticalAlignment = (VerticalAlignment)((Object)addRenderer.getProperty(75));
                                    if (verticalAlignment != null && verticalAlignment.equals((Object)VerticalAlignment.BOTTOM)) {
                                        int i3;
                                        if (row + addRenderer.getPropertyAsInteger(60) - 1 < addRow) {
                                            cellProcessingQueue.addLast(new CellRendererInfo(addRenderer, addCol, addRow));
                                            cellWithBigRowspanAdded = true;
                                            continue block7;
                                        }
                                        this.horizontalBorders.get(row + 1).set(addCol, addRenderer.getBorders()[2]);
                                        if (addCol == 0) {
                                            for (i3 = row; i3 >= 0 && this.checkAndReplaceBorderInArray(this.verticalBorders, addCol, i3, addRenderer.getBorders()[3]); --i3) {
                                            }
                                            continue block7;
                                        }
                                        if (addCol != numberOfColumns - 1) continue block7;
                                        for (i3 = row; i3 >= 0 && this.checkAndReplaceBorderInArray(this.verticalBorders, addCol + 1, i3, addRenderer.getBorders()[1]); --i3) {
                                        }
                                        continue block7;
                                    }
                                    if (row + addRenderer.getPropertyAsInteger(60) - 1 < addRow) continue block7;
                                    cellProcessingQueue.addLast(new CellRendererInfo(addRenderer, addCol, addRow));
                                    cellWithBigRowspanAdded = true;
                                    continue block7;
                                }
                                continue;
                            }
                            if (cell.getModelElement().getRowspan() <= 1) continue;
                            cellWithBigRowspanAdded = true;
                        }
                    }
                    split = true;
                    if (cellResult.getStatus() == 3) {
                        hasContent = false;
                    }
                    splits[col] = cellResult;
                }
                currChildRenderers.add(cell);
                if (cellResult.getStatus() == 3) continue;
                rowHeight = Math.max(rowHeight, cell.getOccupiedArea().getBBox().getHeight() - rowspanOffset);
            }
            if (hasContent || cellWithBigRowspanAdded) {
                this.heights.add(Float.valueOf(rowHeight));
                for (int col = 0; col < currentRow.length; ++col) {
                    CellRenderer cell = currentRow[col];
                    if (cell == null) continue;
                    float height = 0.0f;
                    int rowspan = cell.getPropertyAsInteger(60);
                    for (int i = row; i > targetOverflowRowIndex[col] - rowspan && i >= 0; --i) {
                        height += this.heights.get(i).floatValue();
                    }
                    int rowN = row + 1;
                    if (!hasContent) {
                        --rowN;
                    }
                    if (this.horizontalBorders.get(rowN).get(col) == null) {
                        this.horizontalBorders.get(rowN).set(col, cell.getBorders()[2]);
                    }
                    float shift = height - cell.getOccupiedArea().getBBox().getHeight();
                    Rectangle bBox = cell.getOccupiedArea().getBBox();
                    bBox.moveDown(shift);
                    bBox.setHeight(height);
                    cell.applyVerticalAlignment();
                }
                this.occupiedArea.getBBox().moveDown(rowHeight);
                this.occupiedArea.getBBox().increaseHeight(rowHeight);
                layoutBox.decreaseHeight(rowHeight);
            }
            if (split) {
                int status;
                int col;
                TableRenderer[] splitResult = this.split(row, hasContent);
                int[] rowspans = new int[currentRow.length];
                boolean[] columnsWithCellToBeSplitted = new boolean[currentRow.length];
                for (int col2 = 0; col2 < currentRow.length; ++col2) {
                    if (splits[col2] != null) {
                        CellRenderer cellSplit = splits[col2].getStatus() != 1 ? (CellRenderer)splits[col2].getSplitRenderer() : currentRow[col2];
                        if (null != cellSplit) {
                            rowspans[col2] = cellSplit.getModelElement().getRowspan();
                        }
                        if (splits[col2].getStatus() != 3 && (hasContent || cellWithBigRowspanAdded)) {
                            this.childRenderers.add(cellSplit);
                        }
                        if (hasContent || cellWithBigRowspanAdded || splits[col2].getStatus() == 3) {
                            currentRow[col2] = null;
                            CellRenderer cellOverflow = (CellRenderer)splits[col2].getOverflowRenderer();
                            if (splits[col2].getStatus() != 3) {
                                cellOverflow.setBorders(cellOverflow.getBorders()[2], 0);
                            }
                            this.rows.get((int)targetOverflowRowIndex[col2])[col2] = (CellRenderer)cellOverflow.setParent(splitResult[1]);
                            continue;
                        }
                        this.rows.get((int)targetOverflowRowIndex[col2])[col2] = (CellRenderer)currentRow[col2].setParent(splitResult[1]);
                        continue;
                    }
                    if (!hasContent || currentRow[col2] == null) continue;
                    columnsWithCellToBeSplitted[col2] = true;
                }
                int minRowspan = Integer.MAX_VALUE;
                for (col = 0; col < rowspans.length; ++col) {
                    if (0 == rowspans[col]) continue;
                    minRowspan = Math.min(minRowspan, rowspans[col]);
                }
                for (col = 0; col < numberOfColumns; ++col) {
                    int i;
                    if (!columnsWithCellToBeSplitted[col]) continue;
                    if (1 == minRowspan) {
                        Cell overflowCell = currentRow[col].getModelElement();
                        currentRow[col].isLastRendererForModelElement = false;
                        this.childRenderers.add(currentRow[col]);
                        currentRow[col] = null;
                        this.rows.get((int)targetOverflowRowIndex[col])[col] = (CellRenderer)overflowCell.getRenderer().setParent(this);
                        continue;
                    }
                    this.childRenderers.add(currentRow[col]);
                    for (i = row; i < row + minRowspan && i + 1 < this.rows.size() && this.rows.get(i + 1)[col] != null; ++i) {
                        this.rows.get((int)i)[col] = this.rows.get(i + 1)[col];
                        this.rows.get((int)(i + 1))[col] = null;
                    }
                    if (i == row + minRowspan - 1 || null == this.rows.get(i)[col]) continue;
                    Cell overflowCell = this.rows.get(i)[col].getModelElement();
                    this.rows.get((int)i)[col].isLastRendererForModelElement = false;
                    this.rows.get((int)i)[col] = null;
                    this.rows.get((int)targetOverflowRowIndex[col])[col] = (CellRenderer)overflowCell.getRenderer().setParent(this);
                }
                if (row == this.rowRange.getFinishRow() && this.footerRenderer != null) {
                    this.footerRenderer.getOccupiedAreaBBox().setY(splitResult[0].getOccupiedAreaBBox().getY() - this.footerRenderer.getOccupiedAreaBBox().getHeight());
                    for (IRenderer renderer : this.footerRenderer.getChildRenderers()) {
                        renderer.move(0.0f, splitResult[0].getOccupiedAreaBBox().getY() - renderer.getOccupiedArea().getBBox().getY() - renderer.getOccupiedArea().getBBox().getHeight());
                    }
                } else {
                    this.adjustFooterAndFixOccupiedArea(layoutBox);
                }
                this.applyBorderBox(this.occupiedArea.getBBox(), true);
                this.applyMargins(this.occupiedArea.getBBox(), true);
                for (Map.Entry entry : rowMoves.entrySet()) {
                    if (null != splitResult[1].rows.get((Integer)entry.getValue() - splitResult[0].rows.size())[(Integer)entry.getKey()]) continue;
                    splitResult[1].rows.get((int)(((Integer)entry.getValue()).intValue() - splitResult[0].rows.size()))[((Integer)entry.getKey()).intValue()] = splitResult[1].rows.get(row - splitResult[0].rows.size())[(Integer)entry.getKey()];
                    splitResult[1].rows.get((int)(row - splitResult[0].rows.size()))[((Integer)entry.getKey()).intValue()] = null;
                }
                if (this.isKeepTogether() && !Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                    return new LayoutResult(3, this.occupiedArea, null, this, null == firstCauseOfNothing ? this : firstCauseOfNothing);
                }
                int n = status = this.childRenderers.isEmpty() && this.footerRenderer == null ? 3 : 2;
                if (status == 3 && Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                    return new LayoutResult(1, this.occupiedArea, null, null);
                }
                return new LayoutResult(status, this.occupiedArea, splitResult[0], splitResult[1], 3 == status ? firstCauseOfNothing : null);
            }
            this.childRenderers.addAll(currChildRenderers);
            currChildRenderers.clear();
        }
        if (this.isPositioned()) {
            float y = this.getPropertyAsFloat(80).floatValue();
            float relativeY = this.isFixedLayout() ? 0.0f : layoutBox.getY();
            this.move(0.0f, relativeY + y - this.occupiedArea.getBBox().getY());
        }
        this.applyBorderBox(this.occupiedArea.getBBox(), true);
        this.applyMargins(this.occupiedArea.getBBox(), true);
        if (tableModel.isSkipLastFooter() || !tableModel.isComplete()) {
            this.footerRenderer = null;
        }
        this.adjustFooterAndFixOccupiedArea(layoutBox);
        return new LayoutResult(1, this.occupiedArea, null, null);
    }

    @Override
    public void draw(DrawContext drawContext) {
        PdfDocument document = drawContext.getDocument();
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        boolean ignoreTag = false;
        PdfName role = null;
        if (isTagged) {
            role = ((IAccessibleElement)this.getModelElement()).getRole();
            boolean isHeaderOrFooter = PdfName.THead.equals((Object)role) || PdfName.TFoot.equals((Object)role);
            boolean ignoreHeaderFooterTag = document.getTagStructureContext().getTagStructureTargetVersion().compareTo(PdfVersion.PDF_1_5) < 0;
            boolean bl = ignoreTag = isHeaderOrFooter && ignoreHeaderFooterTag;
        }
        if (role != null && !role.equals((Object)PdfName.Artifact) && !ignoreTag) {
            boolean toRemoveConnectionsWithTag;
            TagStructureContext tagStructureContext = document.getTagStructureContext();
            TagTreePointer tagPointer = tagStructureContext.getAutoTaggingPointer();
            IAccessibleElement accessibleElement = (IAccessibleElement)this.getModelElement();
            if (!tagStructureContext.isElementConnectedToTag(accessibleElement)) {
                AccessibleAttributesApplier.applyLayoutAttributes(role, this, document);
            }
            Table modelElement = (Table)this.getModelElement();
            tagPointer.addTag(accessibleElement, true);
            super.draw(drawContext);
            tagPointer.moveToParent();
            boolean bl = toRemoveConnectionsWithTag = this.isLastRendererForModelElement && modelElement.isComplete();
            if (toRemoveConnectionsWithTag) {
                tagPointer.removeElementConnectionToTag(accessibleElement);
            }
        } else {
            super.draw(drawContext);
        }
    }

    @Override
    public void drawChildren(DrawContext drawContext) {
        boolean shouldHaveFooterOrHeaderTag;
        Table modelElement = (Table)this.getModelElement();
        if (this.headerRenderer != null) {
            boolean notToTagHeader;
            boolean firstHeader = this.rowRange.getStartRow() == 0 && this.isOriginalNonSplitRenderer && !modelElement.isSkipFirstHeader();
            boolean bl = notToTagHeader = drawContext.isTaggingEnabled() && !firstHeader;
            if (notToTagHeader) {
                drawContext.setTaggingEnabled(false);
                drawContext.getCanvas().openTag((CanvasTag)new CanvasArtifact());
            }
            this.headerRenderer.draw(drawContext);
            if (notToTagHeader) {
                drawContext.getCanvas().closeTag();
                drawContext.setTaggingEnabled(true);
            }
        }
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement && !this.childRenderers.isEmpty();
        TagTreePointer tagPointer = null;
        boolean bl = shouldHaveFooterOrHeaderTag = modelElement.getHeader() != null || modelElement.getFooter() != null;
        if (isTagged) {
            PdfName role = modelElement.getRole();
            if (role != null && !PdfName.Artifact.equals((Object)role)) {
                tagPointer = drawContext.getDocument().getTagStructureContext().getAutoTaggingPointer();
                boolean ignoreHeaderFooterTag = drawContext.getDocument().getTagStructureContext().getTagStructureTargetVersion().compareTo(PdfVersion.PDF_1_5) < 0;
                boolean bl2 = shouldHaveFooterOrHeaderTag = shouldHaveFooterOrHeaderTag && !ignoreHeaderFooterTag && (!modelElement.isSkipFirstHeader() || !modelElement.isSkipLastFooter());
                if (shouldHaveFooterOrHeaderTag) {
                    if (tagPointer.getKidsRoles().contains(PdfName.TBody)) {
                        tagPointer.moveToKid(PdfName.TBody);
                    } else {
                        tagPointer.addTag(PdfName.TBody);
                    }
                }
            } else {
                isTagged = false;
            }
        }
        for (IRenderer child : this.childRenderers) {
            if (isTagged) {
                int rowsNum;
                int cellRow;
                int adjustByHeaderRowsNum = 0;
                if (modelElement.getHeader() != null && !modelElement.isSkipFirstHeader() && !shouldHaveFooterOrHeaderTag) {
                    adjustByHeaderRowsNum = modelElement.getHeader().getNumberOfRows();
                }
                if ((cellRow = ((Cell)child.getModelElement()).getRow() + adjustByHeaderRowsNum) < (rowsNum = tagPointer.getKidsRoles().size())) {
                    tagPointer.moveToKid(cellRow);
                } else {
                    tagPointer.addTag(PdfName.TR);
                }
            }
            child.draw(drawContext);
            if (!isTagged) continue;
            tagPointer.moveToParent();
        }
        if (isTagged && shouldHaveFooterOrHeaderTag) {
            tagPointer.moveToParent();
        }
        this.drawBorders(drawContext);
        if (this.footerRenderer != null) {
            boolean notToTagFooter;
            boolean lastFooter = this.isLastRendererForModelElement && modelElement.isComplete() && !modelElement.isSkipLastFooter();
            boolean bl3 = notToTagFooter = drawContext.isTaggingEnabled() && !lastFooter;
            if (notToTagFooter) {
                drawContext.setTaggingEnabled(false);
                drawContext.getCanvas().openTag((CanvasTag)new CanvasArtifact());
            }
            this.footerRenderer.draw(drawContext);
            if (notToTagFooter) {
                drawContext.getCanvas().closeTag();
                drawContext.setTaggingEnabled(true);
            }
        }
    }

    @Override
    public IRenderer getNextRenderer() {
        TableRenderer nextTable = new TableRenderer();
        nextTable.modelElement = this.modelElement;
        return nextTable;
    }

    @Override
    public void move(float dxRight, float dyUp) {
        super.move(dxRight, dyUp);
        if (this.headerRenderer != null) {
            this.headerRenderer.move(dxRight, dyUp);
        }
        if (this.footerRenderer != null) {
            this.footerRenderer.move(dxRight, dyUp);
        }
    }

    protected float[] calculateScaledColumnWidths(Table tableModel, float tableWidth) {
        int i;
        float[] columnWidths = new float[tableModel.getNumberOfColumns()];
        float widthSum = 0.0f;
        for (i = 0; i < tableModel.getNumberOfColumns(); ++i) {
            columnWidths[i] = tableModel.getColumnWidth(i);
            widthSum += columnWidths[i];
        }
        i = 0;
        while (i < tableModel.getNumberOfColumns()) {
            int n = i++;
            columnWidths[n] = columnWidths[n] * (tableWidth / widthSum);
        }
        return columnWidths;
    }

    protected TableRenderer[] split(int row) {
        return this.split(row, false);
    }

    protected TableRenderer[] split(int row, boolean hasContent) {
        int i;
        TableRenderer splitRenderer = this.createSplitRenderer(new Table.RowRange(this.rowRange.getStartRow(), this.rowRange.getStartRow() + row));
        splitRenderer.rows = this.rows.subList(0, row);
        int rowN = row;
        if (hasContent || row == 0) {
            ++rowN;
        }
        splitRenderer.horizontalBorders = new ArrayList();
        for (i = 0; i <= rowN; ++i) {
            splitRenderer.horizontalBorders.add(this.horizontalBorders.get(i));
        }
        splitRenderer.verticalBorders = new ArrayList();
        for (i = 0; i < this.verticalBorders.size(); ++i) {
            splitRenderer.verticalBorders.add(new ArrayList());
            for (int j = 0; j < rowN; ++j) {
                if (this.verticalBorders.get(i).size() == 0) continue;
                splitRenderer.verticalBorders.get(i).add(this.verticalBorders.get(i).get(j));
            }
        }
        splitRenderer.heights = this.heights;
        splitRenderer.columnWidths = this.columnWidths;
        TableRenderer overflowRenderer = this.createOverflowRenderer(new Table.RowRange(this.rowRange.getStartRow() + row, this.rowRange.getFinishRow()));
        overflowRenderer.rows = this.rows.subList(row, this.rows.size());
        splitRenderer.occupiedArea = this.occupiedArea;
        return new TableRenderer[]{splitRenderer, overflowRenderer};
    }

    protected TableRenderer createSplitRenderer(Table.RowRange rowRange) {
        TableRenderer splitRenderer = (TableRenderer)this.getNextRenderer();
        splitRenderer.rowRange = rowRange;
        splitRenderer.parent = this.parent;
        splitRenderer.modelElement = this.modelElement;
        splitRenderer.childRenderers = this.childRenderers;
        splitRenderer.addAllProperties(this.getOwnProperties());
        splitRenderer.headerRenderer = this.headerRenderer;
        splitRenderer.footerRenderer = this.footerRenderer;
        splitRenderer.isLastRendererForModelElement = false;
        return splitRenderer;
    }

    protected TableRenderer createOverflowRenderer(Table.RowRange rowRange) {
        TableRenderer overflowRenderer = (TableRenderer)this.getNextRenderer();
        overflowRenderer.rowRange = rowRange;
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        overflowRenderer.isOriginalNonSplitRenderer = false;
        return overflowRenderer;
    }

    protected void drawBorders(DrawContext drawContext) {
        Border lastBorder;
        Border curBorder;
        Border prevBorder;
        int j;
        boolean isTagged;
        CellRenderer cell;
        if (this.occupiedArea.getBBox().getHeight() < 1.0E-4f) {
            return;
        }
        float startX = this.getOccupiedArea().getBBox().getX();
        float startY = this.getOccupiedArea().getBBox().getY() + this.getOccupiedArea().getBBox().getHeight();
        for (IRenderer child : this.childRenderers) {
            cell = (CellRenderer)child;
            if (cell.getModelElement().getRow() != this.rowRange.getStartRow()) continue;
            startY = cell.getOccupiedArea().getBBox().getY() + cell.getOccupiedArea().getBBox().getHeight();
            break;
        }
        for (IRenderer child : this.childRenderers) {
            cell = (CellRenderer)child;
            if (cell.getModelElement().getCol() != 0) continue;
            startX = cell.getOccupiedArea().getBBox().getX();
            break;
        }
        boolean bl = isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        if (isTagged) {
            drawContext.getCanvas().openTag((CanvasTag)new CanvasArtifact());
        }
        float y1 = startY;
        for (int i = 0; i < this.horizontalBorders.size(); ++i) {
            Border firstBorder;
            ArrayList<Border> borders = this.horizontalBorders.get(i);
            float x1 = startX;
            float x2 = x1 + this.columnWidths[0];
            if (i == 0) {
                Border firstBorder2;
                if (this.verticalBorders != null && this.verticalBorders.size() > 0 && this.verticalBorders.get(0).size() > 0 && this.verticalBorders.get(this.verticalBorders.size() - 1).size() > 0 && (firstBorder2 = this.verticalBorders.get(0).get(0)) != null) {
                    x1 -= firstBorder2.getWidth() / 2.0f;
                }
            } else if (i == this.horizontalBorders.size() - 1 && this.verticalBorders != null && this.verticalBorders.size() > 0 && this.verticalBorders.get(0).size() > 0 && this.verticalBorders.get(this.verticalBorders.size() - 1) != null && this.verticalBorders.get(this.verticalBorders.size() - 1).size() > 0 && this.verticalBorders.get(0) != null && (firstBorder = this.verticalBorders.get(0).get(this.verticalBorders.get(0).size() - 1)) != null) {
                x1 -= firstBorder.getWidth() / 2.0f;
            }
            for (j = 1; j < borders.size(); ++j) {
                prevBorder = borders.get(j - 1);
                curBorder = borders.get(j);
                if (prevBorder != null) {
                    if (!prevBorder.equals(curBorder)) {
                        prevBorder.drawCellBorder(drawContext.getCanvas(), x1, y1, x2, y1);
                        x1 = x2;
                    }
                } else {
                    x2 = x1 += this.columnWidths[j - 1];
                }
                if (curBorder == null) continue;
                x2 += this.columnWidths[j];
            }
            Border border = lastBorder = borders.size() > j - 1 ? borders.get(j - 1) : null;
            if (lastBorder != null) {
                if (this.verticalBorders != null && this.verticalBorders.get(j) != null && this.verticalBorders.get(j).size() > 0) {
                    if (i == 0) {
                        if (this.verticalBorders.get(j).get(i) != null) {
                            x2 += this.verticalBorders.get(j).get(i).getWidth() / 2.0f;
                        }
                    } else if (i == this.horizontalBorders.size() - 1 && this.verticalBorders.get(j).size() >= i - 1 && this.verticalBorders.get(j).get(i - 1) != null) {
                        x2 += this.verticalBorders.get(j).get(i - 1).getWidth() / 2.0f;
                    }
                }
                lastBorder.drawCellBorder(drawContext.getCanvas(), x1, y1, x2, y1);
            }
            if (i >= this.heights.size()) continue;
            y1 -= this.heights.get(i).floatValue();
        }
        float x1 = startX;
        for (int i = 0; i < this.verticalBorders.size(); ++i) {
            ArrayList<Border> borders = this.verticalBorders.get(i);
            float y2 = y1 = startY;
            if (!this.heights.isEmpty()) {
                y2 = y1 - this.heights.get(0).floatValue();
            }
            for (j = 1; j < borders.size(); ++j) {
                prevBorder = borders.get(j - 1);
                curBorder = borders.get(j);
                if (prevBorder != null) {
                    if (!prevBorder.equals(curBorder)) {
                        prevBorder.drawCellBorder(drawContext.getCanvas(), x1, y1, x1, y2);
                        y1 = y2;
                    }
                } else {
                    y2 = y1 -= this.heights.get(j - 1).floatValue();
                }
                if (curBorder == null) continue;
                y2 -= this.heights.get(j).floatValue();
            }
            if (borders.size() == 0) {
                x1 += this.columnWidths[i];
                continue;
            }
            lastBorder = borders.get(j - 1);
            if (lastBorder != null) {
                lastBorder.drawCellBorder(drawContext.getCanvas(), x1, y1, x1, y2);
            }
            if (i >= this.columnWidths.length) continue;
            x1 += this.columnWidths[i];
        }
        if (isTagged) {
            drawContext.getCanvas().closeTag();
        }
    }

    private void adjustFooterAndFixOccupiedArea(Rectangle layoutBox) {
        if (this.footerRenderer != null) {
            this.footerRenderer.move(0.0f, layoutBox.getHeight());
            float footerHeight = this.footerRenderer.getOccupiedArea().getBBox().getHeight();
            this.occupiedArea.getBBox().moveDown(footerHeight).increaseHeight(footerHeight);
        }
    }

    private boolean canFitRowsInGivenArea(LayoutArea layoutArea, int startRow, float[] columnWidths, List<Float> heights) {
        layoutArea = layoutArea.clone();
        heights = new ArrayList<Float>(heights);
        for (int row = startRow; row < this.rows.size(); ++row) {
            CellRenderer[] rowCells = this.rows.get(row);
            float rowHeight = 0.0f;
            for (int col = 0; col < rowCells.length; ++col) {
                int i;
                CellRenderer cell = rowCells[col];
                if (cell == null) continue;
                int colspan = cell.getPropertyAsInteger(16);
                int rowspan = cell.getPropertyAsInteger(60);
                float cellWidth = 0.0f;
                float colOffset = 0.0f;
                for (i = col; i < col + colspan; ++i) {
                    cellWidth += columnWidths[i];
                }
                for (i = 0; i < col; ++i) {
                    colOffset += columnWidths[i];
                }
                float rowspanOffset = 0.0f;
                for (int i2 = row - 1; i2 > row - rowspan && i2 >= 0; --i2) {
                    rowspanOffset += heights.get(i2).floatValue();
                }
                float cellLayoutBoxHeight = rowspanOffset + layoutArea.getBBox().getHeight();
                Rectangle cellLayoutBox = new Rectangle(layoutArea.getBBox().getX() + colOffset, layoutArea.getBBox().getY(), cellWidth, cellLayoutBoxHeight);
                LayoutArea cellArea = new LayoutArea(layoutArea.getPageNumber(), cellLayoutBox);
                LayoutResult cellResult = cell.setParent(this).layout(new LayoutContext(cellArea));
                if (cellResult.getStatus() != 1) {
                    return false;
                }
                rowHeight = Math.max(rowHeight, cellResult.getOccupiedArea().getBBox().getHeight());
            }
            heights.add(Float.valueOf(rowHeight));
            layoutArea.getBBox().moveUp(rowHeight).decreaseHeight(rowHeight);
        }
        return true;
    }

    private void buildBordersArrays(CellRenderer cell, int row, boolean hasContent) {
        int j;
        int i;
        int colspan = cell.getPropertyAsInteger(16);
        int rowspan = cell.getPropertyAsInteger(60);
        int colN = cell.getModelElement().getCol();
        Border[] cellBorders = cell.getBorders();
        if (row + 1 - rowspan < 0) {
            rowspan = row + 1;
        }
        if (row + 1 - rowspan != 0) {
            for (i = 0; i < colspan; ++i) {
                if (this.checkAndReplaceBorderInArray(this.horizontalBorders, row + 1 - rowspan, colN + i, cellBorders[0])) {
                    CellRenderer rend = this.rows.get(row - rowspan)[colN];
                    if (rend == null) continue;
                    rend.setBorders(cellBorders[0], 2);
                    continue;
                }
                cell.setBorders(this.horizontalBorders.get(row + 1 - rowspan).get(colN + i), 0);
            }
        } else {
            for (i = 0; i < colspan; ++i) {
                if (this.checkAndReplaceBorderInArray(this.horizontalBorders, 0, colN + i, cellBorders[0])) continue;
                cell.setBorders(this.horizontalBorders.get(0).get(colN + i), 0);
            }
        }
        for (i = 0; i < colspan; ++i) {
            if (hasContent) {
                ArrayList<Border> borders;
                if (row + 1 == this.horizontalBorders.size()) {
                    this.horizontalBorders.add(new ArrayList());
                }
                if ((borders = this.horizontalBorders.get(row + 1)).size() <= colN + i) {
                    for (int count = borders.size(); count < colN + i; ++count) {
                        borders.add(null);
                    }
                    borders.add(cellBorders[2]);
                    continue;
                }
                if (borders.size() == colN + i) {
                    borders.add(cellBorders[2]);
                    continue;
                }
                borders.set(colN + i, cellBorders[2]);
                continue;
            }
            if (row == this.horizontalBorders.size()) {
                this.horizontalBorders.add(new ArrayList());
            }
            this.horizontalBorders.get(row).add(colN + i, cellBorders[2]);
        }
        if (rowspan > 1) {
            int numOfColumns = ((Table)this.getModelElement()).getNumberOfColumns();
            for (int k = row - rowspan + 1; k <= row; ++k) {
                ArrayList<Border> borders = this.horizontalBorders.get(k);
                if (borders.size() >= numOfColumns) continue;
                for (int j2 = borders.size(); j2 < numOfColumns; ++j2) {
                    borders.add(null);
                }
            }
        }
        if (colN != 0) {
            for (j = row - rowspan + 1; j <= row; ++j) {
                CellRenderer rend;
                if (this.checkAndReplaceBorderInArray(this.verticalBorders, colN, j, cellBorders[3])) {
                    rend = this.rows.get(j)[colN - 1];
                    if (rend == null) continue;
                    rend.setBorders(cellBorders[3], 1);
                    continue;
                }
                rend = this.rows.get(j)[colN];
                if (rend == null) continue;
                rend.setBorders(this.verticalBorders.get(colN).get(row), 3);
            }
        } else {
            for (j = row - rowspan + 1; j <= row; ++j) {
                if (this.verticalBorders.isEmpty()) {
                    this.verticalBorders.add(new ArrayList());
                }
                if (this.verticalBorders.get(0).size() <= j) {
                    this.verticalBorders.get(0).add(cellBorders[3]);
                    continue;
                }
                this.verticalBorders.get(0).set(j, cellBorders[3]);
            }
        }
        for (i = row - rowspan + 1; i <= row; ++i) {
            this.checkAndReplaceBorderInArray(this.verticalBorders, colN + colspan, i, cellBorders[1]);
        }
        if (colspan > 1) {
            for (int k = colN; k <= colspan + colN; ++k) {
                ArrayList<Border> borders = this.verticalBorders.get(k);
                if (borders.size() >= row + rowspan) continue;
                for (int j3 = borders.size(); j3 < row + rowspan; ++j3) {
                    borders.add(null);
                }
            }
        }
    }

    private boolean checkAndReplaceBorderInArray(ArrayList<ArrayList<Border>> borderArray, int i, int j, Border borderToAdd) {
        Border neighbour;
        ArrayList<Border> borders;
        if (borderArray.size() <= i) {
            for (int count = borderArray.size(); count <= i; ++count) {
                borderArray.add(new ArrayList());
            }
        }
        if ((borders = borderArray.get(i)).isEmpty()) {
            for (int count = 0; count < j; ++count) {
                borders.add(null);
            }
            borders.add(borderToAdd);
            return true;
        }
        if (borders.size() == j) {
            borders.add(borderToAdd);
            return true;
        }
        if (borders.size() <= j) {
            for (int count = borders.size(); count <= j; ++count) {
                borders.add(count, null);
            }
        }
        if ((neighbour = borders.get(j)) == null) {
            borders.set(j, borderToAdd);
            return true;
        }
        if (neighbour != borderToAdd && borderToAdd != null && neighbour.getWidth() < borderToAdd.getWidth()) {
            borders.set(j, borderToAdd);
            return true;
        }
        return false;
    }

    private void setRowRange(Table.RowRange rowRange) {
        this.rowRange = rowRange;
        for (int row = rowRange.getStartRow(); row <= rowRange.getFinishRow(); ++row) {
            this.rows.add(new CellRenderer[((Table)this.modelElement).getNumberOfColumns()]);
        }
    }

    private static class CellRendererInfo {
        public CellRenderer cellRenderer;
        public int column;
        public int finishRowInd;

        public CellRendererInfo(CellRenderer cellRenderer, int column, int finishRow) {
            this.cellRenderer = cellRenderer;
            this.column = column;
            this.finishRowInd = finishRow;
        }
    }
}

