/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AreaBreakRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RootRenderer
extends AbstractRenderer {
    protected boolean immediateFlush = true;
    protected LayoutArea currentArea;
    protected int currentPageNumber;
    private IRenderer keepWithNextHangingRenderer;
    private LayoutResult keepWithNextHangingRendererLayoutResult;

    @Override
    public void addChild(IRenderer renderer) {
        super.addChild(renderer);
        if (this.currentArea == null) {
            this.updateCurrentArea(null);
        }
        if (this.currentArea != null && !this.childRenderers.isEmpty() && this.childRenderers.get(this.childRenderers.size() - 1) == renderer) {
            Logger logger;
            this.childRenderers.remove(this.childRenderers.size() - 1);
            this.processWaitingKeepWithNextElement(renderer);
            ArrayList<IRenderer> resultRenderers = new ArrayList<IRenderer>();
            LayoutResult result = null;
            LayoutArea storedArea = null;
            LayoutArea nextStoredArea = null;
            while (this.currentArea != null && renderer != null && (result = renderer.setParent(this).layout(new LayoutContext(this.currentArea.clone()))).getStatus() != 1) {
                if (result.getStatus() == 2) {
                    if (result.getOverflowRenderer() instanceof ImageRenderer) {
                        ((ImageRenderer)result.getOverflowRenderer()).autoScale(this.currentArea);
                    } else {
                        this.processRenderer(result.getSplitRenderer(), resultRenderers);
                        if (nextStoredArea != null) {
                            this.currentArea = nextStoredArea;
                            this.currentPageNumber = nextStoredArea.getPageNumber();
                            nextStoredArea = null;
                        } else {
                            this.updateCurrentArea(result);
                        }
                    }
                } else if (result.getStatus() == 3) {
                    if (result.getOverflowRenderer() instanceof ImageRenderer) {
                        if (this.currentArea.getBBox().getHeight() < ((ImageRenderer)result.getOverflowRenderer()).imageHeight && !this.currentArea.isEmptyArea()) {
                            this.updateCurrentArea(result);
                        }
                        ((ImageRenderer)result.getOverflowRenderer()).autoScale(this.currentArea);
                        result.getOverflowRenderer().setProperty(26, true);
                    } else {
                        if (this.currentArea.isEmptyArea() && !(renderer instanceof AreaBreakRenderer)) {
                            if (Boolean.TRUE.equals(result.getOverflowRenderer().getModelElement().getProperty(32))) {
                                result.getOverflowRenderer().getModelElement().setProperty(32, false);
                                logger = LoggerFactory.getLogger(RootRenderer.class);
                                logger.warn(MessageFormat.format("Element does not fit current area. {0}", "KeepTogether property will be ignored."));
                                if (storedArea != null) {
                                    nextStoredArea = this.currentArea;
                                    this.currentArea = storedArea;
                                    this.currentPageNumber = storedArea.getPageNumber();
                                }
                                storedArea = this.currentArea;
                            } else if (null != result.getCauseOfNothing() && Boolean.TRUE.equals(result.getCauseOfNothing().getProperty(32))) {
                                IRenderer theDeepestKeptTogether = result.getCauseOfNothing();
                                while (null == theDeepestKeptTogether.getModelElement() || null == theDeepestKeptTogether.getModelElement().getOwnProperty(32)) {
                                    theDeepestKeptTogether = ((AbstractRenderer)theDeepestKeptTogether).parent;
                                }
                                theDeepestKeptTogether.getModelElement().setProperty(32, false);
                                Logger logger2 = LoggerFactory.getLogger(RootRenderer.class);
                                logger2.warn(MessageFormat.format("Element does not fit current area. {0}", "KeepTogether property of inner element will be ignored."));
                            } else {
                                result.getOverflowRenderer().setProperty(26, true);
                                logger = LoggerFactory.getLogger(RootRenderer.class);
                                logger.warn(MessageFormat.format("Element does not fit current area. {0}", ""));
                            }
                            renderer = result.getOverflowRenderer();
                            continue;
                        }
                        storedArea = this.currentArea;
                        if (nextStoredArea != null) {
                            this.currentArea = nextStoredArea;
                            this.currentPageNumber = nextStoredArea.getPageNumber();
                            nextStoredArea = null;
                        } else {
                            this.updateCurrentArea(result);
                        }
                    }
                }
                renderer = result.getOverflowRenderer();
            }
            if (renderer != null && Boolean.TRUE.equals(renderer.getProperty(81))) {
                if (Boolean.TRUE.equals(renderer.getProperty(26))) {
                    logger = LoggerFactory.getLogger(RootRenderer.class);
                    logger.warn("Element was placed in a forced way. Keep with next property will be ignored");
                    this.updateCurrentAreaAndProcessRenderer(renderer, resultRenderers, result);
                } else {
                    this.keepWithNextHangingRenderer = renderer;
                    this.keepWithNextHangingRendererLayoutResult = result;
                }
            } else {
                this.updateCurrentAreaAndProcessRenderer(renderer, resultRenderers, result);
            }
        } else if (this.positionedRenderers.size() > 0 && this.positionedRenderers.get(this.positionedRenderers.size() - 1) == renderer) {
            Integer positionedPageNumber = (Integer)renderer.getProperty(51);
            if (positionedPageNumber == null) {
                positionedPageNumber = this.currentPageNumber;
            }
            renderer.setParent(this).layout(new LayoutContext(new LayoutArea(positionedPageNumber, this.currentArea.getBBox().clone())));
            if (this.immediateFlush) {
                this.flushSingleRenderer(renderer);
                this.positionedRenderers.remove(this.positionedRenderers.size() - 1);
            }
        }
    }

    public void flush() {
        for (IRenderer resultRenderer : this.childRenderers) {
            this.flushSingleRenderer(resultRenderer);
        }
        for (IRenderer resultRenderer : this.positionedRenderers) {
            this.flushSingleRenderer(resultRenderer);
        }
        this.childRenderers.clear();
        this.positionedRenderers.clear();
    }

    public void close() {
        if (this.keepWithNextHangingRenderer != null) {
            this.keepWithNextHangingRenderer.setProperty(81, false);
            IRenderer rendererToBeAdded = this.keepWithNextHangingRenderer;
            this.keepWithNextHangingRenderer = null;
            this.addChild(rendererToBeAdded);
        }
        if (!this.immediateFlush) {
            this.flush();
        }
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        throw new IllegalStateException("Layout is not supported for root renderers.");
    }

    public LayoutArea getCurrentArea() {
        if (this.currentArea == null) {
            this.updateCurrentArea(null);
        }
        return this.currentArea;
    }

    protected abstract void flushSingleRenderer(IRenderer var1);

    protected abstract LayoutArea updateCurrentArea(LayoutResult var1);

    private void processRenderer(IRenderer renderer, List<IRenderer> resultRenderers) {
        this.alignChildHorizontally(renderer, this.currentArea.getBBox().getWidth());
        if (this.immediateFlush) {
            this.flushSingleRenderer(renderer);
        } else {
            resultRenderers.add(renderer);
        }
    }

    private void updateCurrentAreaAndProcessRenderer(IRenderer renderer, List<IRenderer> resultRenderers, LayoutResult result) {
        if (this.currentArea != null) {
            this.currentArea.getBBox().setHeight(this.currentArea.getBBox().getHeight() - result.getOccupiedArea().getBBox().getHeight());
            this.currentArea.setEmptyArea(false);
            if (renderer != null) {
                this.processRenderer(renderer, resultRenderers);
            }
        }
        if (!this.immediateFlush) {
            this.childRenderers.addAll(resultRenderers);
        }
    }

    private void processWaitingKeepWithNextElement(IRenderer renderer) {
        if (this.keepWithNextHangingRenderer != null) {
            LayoutArea rest = this.currentArea.clone();
            rest.getBBox().setHeight(rest.getBBox().getHeight() - this.keepWithNextHangingRendererLayoutResult.getOccupiedArea().getBBox().getHeight());
            boolean ableToProcessKeepWithNext = false;
            if (renderer.setParent(this).layout(new LayoutContext(rest)).getStatus() != 3) {
                this.updateCurrentAreaAndProcessRenderer(this.keepWithNextHangingRenderer, new ArrayList<IRenderer>(), this.keepWithNextHangingRendererLayoutResult);
                ableToProcessKeepWithNext = true;
            } else {
                int i;
                float originalElementHeight = this.keepWithNextHangingRendererLayoutResult.getOccupiedArea().getBBox().getHeight();
                ArrayList<Float> trySplitHeightPoints = new ArrayList<Float>();
                float delta = 35.0f;
                for (i = 1; i <= 5 && originalElementHeight - delta * (float)i > originalElementHeight / 2.0f; ++i) {
                    trySplitHeightPoints.add(Float.valueOf(originalElementHeight - delta * (float)i));
                }
                for (i = 0; i < trySplitHeightPoints.size() && !ableToProcessKeepWithNext; ++i) {
                    float curElementSplitHeight = ((Float)trySplitHeightPoints.get(i)).floatValue();
                    LayoutArea firstElementSplitLayoutArea = this.currentArea.clone();
                    firstElementSplitLayoutArea.getBBox().setHeight(curElementSplitHeight).moveUp(this.currentArea.getBBox().getHeight() - curElementSplitHeight);
                    LayoutResult firstElementSplitLayoutResult = this.keepWithNextHangingRenderer.setParent(this).layout(new LayoutContext(firstElementSplitLayoutArea.clone()));
                    if (firstElementSplitLayoutResult.getStatus() != 2) continue;
                    LayoutArea storedArea = this.currentArea;
                    this.updateCurrentArea(firstElementSplitLayoutResult);
                    LayoutResult firstElementOverflowLayoutResult = firstElementSplitLayoutResult.getOverflowRenderer().layout(new LayoutContext(this.currentArea.clone()));
                    if (firstElementOverflowLayoutResult.getStatus() == 1) {
                        LayoutArea secondElementLayoutArea = this.currentArea.clone();
                        secondElementLayoutArea.getBBox().setHeight(secondElementLayoutArea.getBBox().getHeight() - firstElementOverflowLayoutResult.getOccupiedArea().getBBox().getHeight());
                        LayoutResult secondElementLayoutResult = renderer.setParent(this).layout(new LayoutContext(secondElementLayoutArea));
                        if (secondElementLayoutResult.getStatus() != 3) {
                            ableToProcessKeepWithNext = true;
                            this.currentArea = firstElementSplitLayoutArea;
                            this.currentPageNumber = firstElementSplitLayoutArea.getPageNumber();
                            this.updateCurrentAreaAndProcessRenderer(firstElementSplitLayoutResult.getSplitRenderer(), new ArrayList<IRenderer>(), firstElementSplitLayoutResult);
                            this.updateCurrentArea(firstElementSplitLayoutResult);
                            this.updateCurrentAreaAndProcessRenderer(firstElementSplitLayoutResult.getOverflowRenderer(), new ArrayList<IRenderer>(), firstElementOverflowLayoutResult);
                        }
                    }
                    if (ableToProcessKeepWithNext) continue;
                    this.currentArea = storedArea;
                    this.currentPageNumber = storedArea.getPageNumber();
                }
            }
            if (!ableToProcessKeepWithNext && !this.currentArea.isEmptyArea()) {
                LayoutArea storedArea = this.currentArea;
                this.updateCurrentArea(null);
                LayoutResult firstElementLayoutResult = this.keepWithNextHangingRenderer.setParent(this).layout(new LayoutContext(this.currentArea.clone()));
                if (firstElementLayoutResult.getStatus() == 1) {
                    LayoutArea secondElementLayoutArea = this.currentArea.clone();
                    secondElementLayoutArea.getBBox().setHeight(secondElementLayoutArea.getBBox().getHeight() - firstElementLayoutResult.getOccupiedArea().getBBox().getHeight());
                    LayoutResult secondElementLayoutResult = renderer.setParent(this).layout(new LayoutContext(secondElementLayoutArea));
                    if (secondElementLayoutResult.getStatus() != 3) {
                        ableToProcessKeepWithNext = true;
                        this.updateCurrentAreaAndProcessRenderer(this.keepWithNextHangingRenderer, new ArrayList<IRenderer>(), this.keepWithNextHangingRendererLayoutResult);
                    }
                }
                if (!ableToProcessKeepWithNext) {
                    this.currentArea = storedArea;
                    this.currentPageNumber = storedArea.getPageNumber();
                }
            }
            if (!ableToProcessKeepWithNext) {
                Logger logger = LoggerFactory.getLogger(RootRenderer.class);
                logger.warn("The renderer was not able to process keep with next property properly");
                this.updateCurrentAreaAndProcessRenderer(this.keepWithNextHangingRenderer, new ArrayList<IRenderer>(), this.keepWithNextHangingRendererLayoutResult);
            }
            this.keepWithNextHangingRenderer = null;
            this.keepWithNextHangingRendererLayoutResult = null;
        }
    }
}

