/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.LineLayoutResult;
import com.itextpdf.layout.property.Leading;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParagraphRenderer
extends BlockRenderer {
    protected float previousDescent = 0.0f;
    protected List<LineRenderer> lines = null;

    public ParagraphRenderer(Paragraph modelElement) {
        super(modelElement);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        Float blockWidth;
        int pageNumber = layoutContext.getArea().getPageNumber();
        boolean anythingPlaced = false;
        boolean firstLineInBox = true;
        LineRenderer currentRenderer = (LineRenderer)new LineRenderer().setParent(this);
        Rectangle parentBBox = layoutContext.getArea().getBBox().clone();
        if (0 == this.childRenderers.size()) {
            anythingPlaced = true;
            currentRenderer = null;
            this.setProperty(46, 0);
            this.setProperty(45, 0);
            this.setProperty(43, 0);
            this.setProperty(44, 0);
            this.setProperty(50, 0);
            this.setProperty(49, 0);
            this.setProperty(47, 0);
            this.setProperty(48, 0);
            this.setProperty(9, Border.NO_BORDER);
        }
        if (this.getProperty(55) != null) {
            parentBBox.moveDown(1000000.0f - parentBBox.getHeight()).setHeight(1000000.0f);
        }
        float[] margins = this.getMargins();
        this.applyMargins(parentBBox, margins, false);
        Border[] borders = this.getBorders();
        this.applyBorderBox(parentBBox, borders, false);
        boolean isPositioned = this.isPositioned();
        if (isPositioned) {
            float x = this.getPropertyAsFloat(79).floatValue();
            float relativeX = this.isFixedLayout() ? 0.0f : parentBBox.getX();
            parentBBox.setX(relativeX + x);
        }
        if ((blockWidth = this.retrieveWidth(parentBBox.getWidth())) != null && (blockWidth.floatValue() < parentBBox.getWidth() || isPositioned)) {
            parentBBox.setWidth(blockWidth.floatValue());
        }
        float[] paddings = this.getPaddings();
        this.applyPaddings(parentBBox, paddings, false);
        List<Rectangle> areas = isPositioned ? Collections.singletonList(parentBBox) : this.initElementAreas(new LayoutArea(pageNumber, parentBBox));
        this.occupiedArea = new LayoutArea(pageNumber, new Rectangle(parentBBox.getX(), parentBBox.getY() + parentBBox.getHeight(), parentBBox.getWidth(), 0.0f));
        int currentAreaPos = 0;
        Rectangle layoutBox = areas.get(0).clone();
        this.lines = new ArrayList<LineRenderer>();
        for (IRenderer child : this.childRenderers) {
            currentRenderer.addChild(child);
        }
        float lastYLine = layoutBox.getY() + layoutBox.getHeight();
        Leading leading = (Leading)this.getProperty(33);
        float leadingValue = 0.0f;
        float lastLineHeight = 0.0f;
        while (currentRenderer != null) {
            currentRenderer.setProperty(67, this.getPropertyAsFloat(67));
            currentRenderer.setProperty(69, this.getProperty(69));
            float lineIndent = anythingPlaced ? 0.0f : this.getPropertyAsFloat(18).floatValue();
            float availableWidth = layoutBox.getWidth() - lineIndent;
            Rectangle childLayoutBox = new Rectangle(layoutBox.getX() + lineIndent, layoutBox.getY(), availableWidth, layoutBox.getHeight());
            LineLayoutResult result = ((LineRenderer)currentRenderer.setParent(this)).layout(new LayoutContext(new LayoutArea(pageNumber, childLayoutBox)));
            LineRenderer processedRenderer = null;
            if (result.getStatus() == 1) {
                processedRenderer = currentRenderer;
            } else if (result.getStatus() == 2) {
                processedRenderer = (LineRenderer)result.getSplitRenderer();
            }
            TextAlignment textAlignment = this.getProperty(70, TextAlignment.LEFT);
            if (result.getStatus() == 2 && textAlignment == TextAlignment.JUSTIFIED && !result.isSplitForcedByNewline() || textAlignment == TextAlignment.JUSTIFIED_ALL) {
                if (processedRenderer != null) {
                    processedRenderer.justify(layoutBox.getWidth() - lineIndent);
                }
            } else if (textAlignment != TextAlignment.LEFT && processedRenderer != null) {
                float deltaX = availableWidth - processedRenderer.getOccupiedArea().getBBox().getWidth();
                switch (textAlignment) {
                    case RIGHT: {
                        processedRenderer.move(deltaX, 0.0f);
                        break;
                    }
                    case CENTER: {
                        processedRenderer.move(deltaX / 2.0f, 0.0f);
                    }
                }
            }
            float f = leadingValue = processedRenderer != null && leading != null ? processedRenderer.getLeadingValue(leading) : 0.0f;
            if (processedRenderer != null && processedRenderer.containsImage()) {
                leadingValue -= this.previousDescent;
            }
            boolean doesNotFit = result.getStatus() == 3;
            float deltaY = 0.0f;
            if (!doesNotFit) {
                lastLineHeight = processedRenderer.getOccupiedArea().getBBox().getHeight();
                deltaY = lastYLine - leadingValue - processedRenderer.getYLine();
                if (firstLineInBox) {
                    deltaY = -(leadingValue - lastLineHeight) / 2.0f;
                }
                boolean bl = doesNotFit = leading != null && processedRenderer.getOccupiedArea().getBBox().getY() + deltaY < layoutBox.getY();
            }
            if (doesNotFit) {
                if (currentAreaPos + 1 < areas.size()) {
                    layoutBox = areas.get(++currentAreaPos).clone();
                    lastYLine = layoutBox.getY() + layoutBox.getHeight();
                    firstLineInBox = true;
                    continue;
                }
                boolean keepTogether = this.isKeepTogether();
                if (keepTogether) {
                    return new LayoutResult(3, this.occupiedArea, null, this, null == result.getCauseOfNothing() ? this : result.getCauseOfNothing());
                }
                this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
                this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                this.applyMargins(this.occupiedArea.getBBox(), margins, true);
                ParagraphRenderer[] split = this.split();
                split[0].lines = this.lines;
                for (LineRenderer line : this.lines) {
                    split[0].childRenderers.addAll(line.getChildRenderers());
                }
                if (processedRenderer != null) {
                    split[1].childRenderers.addAll(processedRenderer.getChildRenderers());
                }
                if (result.getOverflowRenderer() != null) {
                    split[1].childRenderers.addAll(result.getOverflowRenderer().getChildRenderers());
                }
                if (anythingPlaced) {
                    return new LayoutResult(2, this.occupiedArea, split[0], split[1]);
                }
                if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                    this.occupiedArea.setBBox(Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{this.occupiedArea.getBBox(), currentRenderer.getOccupiedArea().getBBox()}));
                    this.parent.setProperty(25, true);
                    this.lines.add(currentRenderer);
                    if (2 == result.getStatus()) {
                        IRenderer childNotRendered = result.getCauseOfNothing();
                        int firstNotRendered = currentRenderer.childRenderers.indexOf(childNotRendered);
                        currentRenderer.childRenderers.retainAll(currentRenderer.childRenderers.subList(0, firstNotRendered));
                        split[1].childRenderers.removeAll(split[1].childRenderers.subList(0, firstNotRendered));
                        return new LayoutResult(2, this.occupiedArea, this, split[1]);
                    }
                    return new LayoutResult(1, this.occupiedArea, null, null, this);
                }
                return new LayoutResult(3, this.occupiedArea, null, this, null == result.getCauseOfNothing() ? this : result.getCauseOfNothing());
            }
            if (leading != null) {
                processedRenderer.move(0.0f, deltaY);
                lastYLine = processedRenderer.getYLine();
            }
            this.occupiedArea.setBBox(Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{this.occupiedArea.getBBox(), processedRenderer.getOccupiedArea().getBBox()}));
            layoutBox.setHeight(processedRenderer.getOccupiedArea().getBBox().getY() - layoutBox.getY());
            this.lines.add(processedRenderer);
            anythingPlaced = true;
            firstLineInBox = false;
            currentRenderer = (LineRenderer)result.getOverflowRenderer();
            this.previousDescent = processedRenderer.getMaxDescent();
        }
        if (!isPositioned) {
            float moveDown = Math.min((leadingValue - lastLineHeight) / 2.0f, this.occupiedArea.getBBox().getY() - layoutBox.getY());
            this.occupiedArea.getBBox().moveDown(moveDown);
            this.occupiedArea.getBBox().setHeight(this.occupiedArea.getBBox().getHeight() + moveDown);
        }
        Float blockHeight = this.getPropertyAsFloat(27);
        this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
        if (blockHeight != null && blockHeight.floatValue() > this.occupiedArea.getBBox().getHeight()) {
            this.occupiedArea.getBBox().moveDown(blockHeight.floatValue() - this.occupiedArea.getBBox().getHeight()).setHeight(blockHeight.floatValue());
            this.applyVerticalAlignment();
        }
        if (isPositioned) {
            float y = this.getPropertyAsFloat(80).floatValue();
            float relativeY = this.isFixedLayout() ? 0.0f : layoutBox.getY();
            this.move(0.0f, relativeY + y - this.occupiedArea.getBBox().getY());
        }
        this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
        this.applyMargins(this.occupiedArea.getBBox(), margins, true);
        if (this.getProperty(55) != null) {
            this.applyRotationLayout(layoutContext.getArea().getBBox().clone());
            if (this.isNotFittingLayoutArea(layoutContext.getArea()) && !Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                return new LayoutResult(3, this.occupiedArea, null, this, this);
            }
        }
        return new LayoutResult(1, this.occupiedArea, null, null);
    }

    @Override
    public IRenderer getNextRenderer() {
        return new ParagraphRenderer((Paragraph)this.modelElement);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        if ((property == 46 || property == 43) && this.parent instanceof CellRenderer) {
            return (T1)Float.valueOf(0.0f);
        }
        return super.getDefaultProperty(property);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.lines != null && this.lines.size() > 0) {
            for (LineRenderer lineRenderer : this.lines) {
                sb.append(lineRenderer.toString()).append("\n");
            }
        } else {
            for (IRenderer renderer : this.childRenderers) {
                sb.append(renderer.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public void drawChildren(DrawContext drawContext) {
        if (this.lines != null) {
            for (LineRenderer line : this.lines) {
                line.draw(drawContext);
            }
        }
    }

    @Override
    public void move(float dxRight, float dyUp) {
        this.occupiedArea.getBBox().moveRight(dxRight);
        this.occupiedArea.getBBox().moveUp(dyUp);
        for (LineRenderer line : this.lines) {
            line.move(dxRight, dyUp);
        }
    }

    @Override
    protected Float getFirstYLineRecursively() {
        if (this.lines == null || this.lines.size() == 0) {
            return null;
        }
        return this.lines.get(0).getFirstYLineRecursively();
    }

    @Deprecated
    protected ParagraphRenderer createOverflowRenderer() {
        return (ParagraphRenderer)this.getNextRenderer();
    }

    @Deprecated
    protected ParagraphRenderer createSplitRenderer() {
        return (ParagraphRenderer)this.getNextRenderer();
    }

    protected ParagraphRenderer createOverflowRenderer(IRenderer parent) {
        ParagraphRenderer overflowRenderer = this.createOverflowRenderer();
        overflowRenderer.parent = parent;
        this.fixOverflowRenderer(overflowRenderer);
        return overflowRenderer;
    }

    protected ParagraphRenderer createSplitRenderer(IRenderer parent) {
        ParagraphRenderer splitRenderer = this.createSplitRenderer();
        splitRenderer.parent = parent;
        return splitRenderer;
    }

    protected ParagraphRenderer[] split() {
        ParagraphRenderer splitRenderer = this.createSplitRenderer(this.parent);
        splitRenderer.occupiedArea = this.occupiedArea.clone();
        splitRenderer.isLastRendererForModelElement = false;
        ParagraphRenderer overflowRenderer = this.createOverflowRenderer(this.parent);
        return new ParagraphRenderer[]{splitRenderer, overflowRenderer};
    }

    private void fixOverflowRenderer(ParagraphRenderer overflowRenderer) {
        float firstLineIndent = overflowRenderer.getPropertyAsFloat(18).floatValue();
        if (firstLineIndent != 0.0f) {
            overflowRenderer.setProperty(18, 0);
        }
    }
}

