/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.xobject;

import com.itextpdf.io.colors.IccProfile;
import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageType;
import com.itextpdf.io.image.PngChromaticities;
import com.itextpdf.io.image.PngImageData;
import com.itextpdf.io.image.RawImageData;
import com.itextpdf.io.image.RawImageHelper;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.canvas.wmf.WmfImageData;
import com.itextpdf.kernel.pdf.colorspace.PdfCieBasedCs;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.colorspace.PdfSpecialCs;
import com.itextpdf.kernel.pdf.filters.DoNothingFilter;
import com.itextpdf.kernel.pdf.filters.FilterHandlers;
import com.itextpdf.kernel.pdf.filters.IFilterHandler;
import com.itextpdf.kernel.pdf.xobject.ImagePdfBytesInfo;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.LoggerFactory;

public class PdfImageXObject
extends PdfXObject {
    private float width;
    private float height;
    private boolean mask;
    private boolean softMask;

    public PdfImageXObject(ImageData image) {
        this(image, null);
    }

    public PdfImageXObject(ImageData image, PdfImageXObject imageMask) {
        this(PdfImageXObject.createPdfStream(PdfImageXObject.checkImageType(image), imageMask));
        this.mask = image.isMask();
        this.softMask = image.isSoftMask();
    }

    public PdfImageXObject(PdfStream pdfStream) {
        super(pdfStream);
        if (!pdfStream.isFlushed()) {
            this.initWidthField();
            this.initHeightField();
        }
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void flush() {
        super.flush();
    }

    public PdfImageXObject copyTo(PdfDocument document) {
        PdfImageXObject image = new PdfImageXObject((PdfStream)((PdfStream)this.getPdfObject()).copyTo(document));
        image.mask = this.mask;
        image.softMask = this.softMask;
        return image;
    }

    public BufferedImage getBufferedImage() throws IOException {
        byte[] img = this.getImageBytes();
        return ImageIO.read(new ByteArrayInputStream(img));
    }

    public byte[] getImageBytes() {
        return this.getImageBytes(true);
    }

    public byte[] getImageBytes(boolean decoded) {
        byte[] bytes = ((PdfStream)this.getPdfObject()).getBytes(false);
        if (decoded) {
            HashMap<PdfName, IFilterHandler> filters = new HashMap<PdfName, IFilterHandler>(FilterHandlers.getDefaultFilterHandlers());
            filters.put(PdfName.JBIG2Decode, new DoNothingFilter());
            bytes = PdfReader.decodeBytes(bytes, (PdfDictionary)this.getPdfObject(), filters);
            ImageType imageType = this.identifyImageType();
            if (imageType == ImageType.TIFF || imageType == ImageType.PNG) {
                try {
                    bytes = new ImagePdfBytesInfo((int)this.width, (int)this.height, ((PdfStream)this.getPdfObject()).getAsNumber(PdfName.BitsPerComponent).intValue(), ((PdfStream)this.getPdfObject()).get(PdfName.ColorSpace), ((PdfStream)this.getPdfObject()).getAsArray(PdfName.Decode)).decodeTiffAndPngBytes(bytes);
                }
                catch (IOException e) {
                    throw new RuntimeException("IO exception in PdfImageXObject", e);
                }
            }
        }
        return bytes;
    }

    public ImageType identifyImageType() {
        PdfObject filter = ((PdfStream)this.getPdfObject()).get(PdfName.Filter);
        PdfArray filters = new PdfArray();
        if (filter != null) {
            if (filter.getType() == 6) {
                filters.add(filter);
            } else if (filter.getType() == 1) {
                filters = (PdfArray)filter;
            }
        }
        for (int i = filters.size() - 1; i >= 0; --i) {
            PdfName filterName = (PdfName)filters.get(i);
            if (PdfName.DCTDecode.equals(filterName)) {
                return ImageType.JPEG;
            }
            if (PdfName.JBIG2Decode.equals(filterName)) {
                return ImageType.JBIG2;
            }
            if (!PdfName.JPXDecode.equals(filterName)) continue;
            return ImageType.JPEG2000;
        }
        ImagePdfBytesInfo imageInfo = new ImagePdfBytesInfo((int)this.width, (int)this.height, ((PdfStream)this.getPdfObject()).getAsNumber(PdfName.BitsPerComponent).intValue(), ((PdfStream)this.getPdfObject()).get(PdfName.ColorSpace), ((PdfStream)this.getPdfObject()).getAsArray(PdfName.Decode));
        if (imageInfo.getPngColorType() < 0) {
            return ImageType.TIFF;
        }
        return ImageType.PNG;
    }

    public String identifyImageFileExtension() {
        ImageType bytesType = this.identifyImageType();
        switch (bytesType) {
            case PNG: {
                return "png";
            }
            case JPEG: {
                return "jpg";
            }
            case JPEG2000: {
                return "jp2";
            }
            case TIFF: {
                return "tif";
            }
            case JBIG2: {
                return "jbig2";
            }
        }
        throw new IllegalStateException("Should have never happened. This type of image is not allowed for ImageXObject");
    }

    public PdfImageXObject put(PdfName key, PdfObject value) {
        ((PdfStream)this.getPdfObject()).put(key, value);
        return this;
    }

    private float initWidthField() {
        PdfNumber wNum = ((PdfStream)this.getPdfObject()).getAsNumber(PdfName.Width);
        if (wNum != null) {
            this.width = wNum.floatValue();
        }
        return this.width;
    }

    private float initHeightField() {
        PdfNumber hNum = ((PdfStream)this.getPdfObject()).getAsNumber(PdfName.Height);
        if (hNum != null) {
            this.height = hNum.floatValue();
        }
        return this.height;
    }

    private static PdfStream createPdfStream(ImageData image, PdfImageXObject imageMask) {
        int[] transparency;
        ImageData mask;
        IccProfile iccProfile;
        if (image.getOriginalType() == ImageType.RAW) {
            RawImageHelper.updateImageAttributes((RawImageData)((RawImageData)image), null);
        }
        PdfStream stream = new PdfStream(image.getData());
        String filter = image.getFilter();
        if (filter != null && "JPXDecode".equals(filter) && image.getColorEncodingComponentsNumber() <= 0) {
            stream.setCompressionLevel(0);
            image.setBpc(0);
        }
        stream.put(PdfName.Type, PdfName.XObject);
        stream.put(PdfName.Subtype, PdfName.Image);
        PdfDictionary decodeParms = PdfImageXObject.createDictionaryFromMap(stream, image.getDecodeParms());
        if (decodeParms != null) {
            stream.put(PdfName.DecodeParms, decodeParms);
        }
        if (!(image instanceof PngImageData)) {
            PdfName colorSpace;
            switch (image.getColorEncodingComponentsNumber()) {
                case 1: {
                    colorSpace = PdfName.DeviceGray;
                    break;
                }
                case 3: {
                    colorSpace = PdfName.DeviceRGB;
                    break;
                }
                default: {
                    colorSpace = PdfName.DeviceCMYK;
                }
            }
            stream.put(PdfName.ColorSpace, colorSpace);
        }
        if (image.getBpc() != 0) {
            stream.put(PdfName.BitsPerComponent, new PdfNumber(image.getBpc()));
        }
        if (image.getFilter() != null) {
            stream.put(PdfName.Filter, new PdfName(image.getFilter()));
        }
        if (image.getColorEncodingComponentsNumber() == -1) {
            stream.remove(PdfName.ColorSpace);
        }
        PdfDictionary additional = null;
        if (image instanceof PngImageData) {
            PngImageData pngImage = (PngImageData)image;
            if (pngImage.isIndexed()) {
                PdfArray colorspace = new PdfArray();
                colorspace.add(PdfName.Indexed);
                colorspace.add(PdfImageXObject.getColorSpaceInfo(pngImage));
                if (pngImage.getColorPalette() != null && pngImage.getColorPalette().length > 0) {
                    colorspace.add(new PdfNumber(pngImage.getColorPalette().length / 3 - 1));
                }
                if (pngImage.getColorPalette() != null) {
                    colorspace.add(new PdfString(PdfEncodings.convertToString((byte[])pngImage.getColorPalette(), null)));
                }
                stream.put(PdfName.ColorSpace, colorspace);
            } else {
                stream.put(PdfName.ColorSpace, PdfImageXObject.getColorSpaceInfo(pngImage));
            }
        }
        if ((additional = PdfImageXObject.createDictionaryFromMap(stream, image.getImageAttributes())) != null) {
            stream.putAll(additional);
        }
        if ((iccProfile = image.getProfile()) != null) {
            PdfStream iccProfileStream = PdfCieBasedCs.IccBased.getIccProfileStream(iccProfile);
            PdfArray iccBasedColorSpace = new PdfArray();
            iccBasedColorSpace.add(PdfName.ICCBased);
            iccBasedColorSpace.add(iccProfileStream);
            PdfObject colorSpaceObject = stream.get(PdfName.ColorSpace);
            boolean iccProfileShouldBeApplied = true;
            if (colorSpaceObject != null) {
                PdfColorSpace cs = PdfColorSpace.makeColorSpace(colorSpaceObject);
                if (cs == null) {
                    LoggerFactory.getLogger(PdfImageXObject.class).error("Image has incorrect or unsupported color space, that will be overridden by one based on embedded icc profile.");
                } else if (cs instanceof PdfSpecialCs.Indexed) {
                    PdfColorSpace baseCs = ((PdfSpecialCs.Indexed)cs).getBaseCs();
                    if (baseCs == null) {
                        LoggerFactory.getLogger(PdfImageXObject.class).error("Image has incorrect or unsupported base color space in indexed color space, it will be overridden by one based on embedded icc profile.");
                    } else if (baseCs.getNumberOfComponents() != iccProfile.getNumComponents()) {
                        LoggerFactory.getLogger(PdfImageXObject.class).error("Image has icc profile with incompatible number of color components compared to base color space in image indexed color space. The icc profile will be ignored.");
                        iccProfileShouldBeApplied = false;
                    } else {
                        iccProfileStream.put(PdfName.Alternate, (PdfObject)baseCs.getPdfObject());
                    }
                    if (iccProfileShouldBeApplied) {
                        ((PdfArray)colorSpaceObject).set(1, iccBasedColorSpace);
                        iccProfileShouldBeApplied = false;
                    }
                } else if (cs.getNumberOfComponents() != iccProfile.getNumComponents()) {
                    LoggerFactory.getLogger(PdfImageXObject.class).error("Image has icc profile with incompatible number of color components compared to image color space. The icc profile will be ignored.");
                    iccProfileShouldBeApplied = false;
                } else {
                    iccProfileStream.put(PdfName.Alternate, colorSpaceObject);
                }
            }
            if (iccProfileShouldBeApplied) {
                stream.put(PdfName.ColorSpace, iccBasedColorSpace);
            }
        }
        if (image.isMask() && (image.getBpc() == 1 || image.getBpc() > 255)) {
            stream.put(PdfName.ImageMask, PdfBoolean.TRUE);
        }
        if (imageMask != null) {
            if (imageMask.softMask) {
                stream.put(PdfName.SMask, (PdfObject)imageMask.getPdfObject());
            } else if (imageMask.mask) {
                stream.put(PdfName.Mask, (PdfObject)imageMask.getPdfObject());
            }
        }
        if ((mask = image.getImageMask()) != null) {
            if (mask.isSoftMask()) {
                stream.put(PdfName.SMask, (PdfObject)new PdfImageXObject(image.getImageMask()).getPdfObject());
            } else if (mask.isMask()) {
                stream.put(PdfName.Mask, (PdfObject)new PdfImageXObject(image.getImageMask()).getPdfObject());
            }
        }
        if (image.getDecode() != null) {
            stream.put(PdfName.Decode, new PdfArray(image.getDecode()));
        }
        if (image.isMask() && image.isInverted()) {
            stream.put(PdfName.Decode, new PdfArray(new float[]{1.0f, 0.0f}));
        }
        if (image.isInterpolation()) {
            stream.put(PdfName.Interpolate, PdfBoolean.TRUE);
        }
        if ((transparency = image.getTransparency()) != null && !image.isMask() && imageMask == null) {
            PdfArray t = new PdfArray();
            for (int transparencyItem : transparency) {
                t.add(new PdfNumber(transparencyItem));
            }
            stream.put(PdfName.Mask, t);
        }
        stream.put(PdfName.Width, new PdfNumber(image.getWidth()));
        stream.put(PdfName.Height, new PdfNumber(image.getHeight()));
        return stream;
    }

    private static PdfDictionary createDictionaryFromMap(PdfStream stream, Map<String, Object> parms) {
        if (parms != null) {
            PdfDictionary dictionary = new PdfDictionary();
            for (Map.Entry<String, Object> entry : parms.entrySet()) {
                Object value = entry.getValue();
                String key = entry.getKey();
                if (value instanceof Integer) {
                    dictionary.put(new PdfName(key), new PdfNumber((Integer)value));
                    continue;
                }
                if (value instanceof Float) {
                    dictionary.put(new PdfName(key), new PdfNumber(((Float)value).floatValue()));
                    continue;
                }
                if (value instanceof String) {
                    if (value.equals("Mask")) {
                        dictionary.put(PdfName.Mask, new PdfLiteral((String)value));
                        continue;
                    }
                    String str = (String)value;
                    if (str.indexOf(47) == 0) {
                        dictionary.put(new PdfName(key), new PdfName(str.substring(1)));
                        continue;
                    }
                    dictionary.put(new PdfName(key), new PdfString(str));
                    continue;
                }
                if (value instanceof byte[]) {
                    PdfStream globalsStream = new PdfStream();
                    globalsStream.getOutputStream().writeBytes((byte[])value);
                    dictionary.put(PdfName.JBIG2Globals, globalsStream);
                    continue;
                }
                if (value instanceof Boolean) {
                    dictionary.put(new PdfName(key), PdfBoolean.valueOf((Boolean)value));
                    continue;
                }
                if (value instanceof Object[]) {
                    dictionary.put(new PdfName(key), PdfImageXObject.createArray(stream, (Object[])value));
                    continue;
                }
                if (value instanceof float[]) {
                    dictionary.put(new PdfName(key), new PdfArray((float[])value));
                    continue;
                }
                if (!(value instanceof int[])) continue;
                dictionary.put(new PdfName(key), new PdfArray((int[])value));
            }
            return dictionary;
        }
        return null;
    }

    private static PdfArray createArray(PdfStream stream, Object[] objects) {
        PdfArray array = new PdfArray();
        for (Object obj : objects) {
            if (obj instanceof String) {
                String str = (String)obj;
                if (str.indexOf(47) == 0) {
                    array.add(new PdfName(str.substring(1)));
                    continue;
                }
                array.add(new PdfString(str));
                continue;
            }
            if (obj instanceof Integer) {
                array.add(new PdfNumber((Integer)obj));
                continue;
            }
            if (obj instanceof Float) {
                array.add(new PdfNumber(((Float)obj).floatValue()));
                continue;
            }
            if (obj instanceof Object[]) {
                array.add(PdfImageXObject.createArray(stream, (Object[])obj));
                continue;
            }
            array.add(PdfImageXObject.createDictionaryFromMap(stream, (Map)obj));
        }
        return array;
    }

    private static ImageData checkImageType(ImageData image) {
        if (image instanceof WmfImageData) {
            throw new PdfException("Cannot create PdfImageXObject instance by WmfImage. Use PdfFormXObject constructor instead.");
        }
        return image;
    }

    private static PdfObject getColorSpaceInfo(PngImageData pngImageData) {
        if (pngImageData.getProfile() != null) {
            if (pngImageData.isGrayscaleImage()) {
                return PdfName.DeviceGray;
            }
            return PdfName.DeviceRGB;
        }
        if (pngImageData.getGamma() == 1.0f && !pngImageData.isHasCHRM()) {
            if (pngImageData.isGrayscaleImage()) {
                return PdfName.DeviceGray;
            }
            return PdfName.DeviceRGB;
        }
        PdfArray array = new PdfArray();
        PdfDictionary map = new PdfDictionary();
        if (pngImageData.isGrayscaleImage()) {
            if (pngImageData.getGamma() == 1.0f) {
                return PdfName.DeviceGray;
            }
            array.add(PdfName.CalGray);
            map.put(PdfName.Gamma, new PdfNumber(pngImageData.getGamma()));
            map.put(PdfName.WhitePoint, new PdfArray(new int[]{1, 1, 1}));
        } else {
            float[] wp = new float[]{1.0f, 1.0f, 1.0f};
            array.add(PdfName.CalRGB);
            float gamma = pngImageData.getGamma();
            if (gamma != 1.0f) {
                float[] gm = new float[]{gamma, gamma, gamma};
                map.put(PdfName.Gamma, new PdfArray(gm));
            }
            if (pngImageData.isHasCHRM()) {
                PngChromaticitiesHelper helper = new PngChromaticitiesHelper();
                helper.constructMatrix(pngImageData);
                wp = helper.wp;
                map.put(PdfName.Matrix, new PdfArray(helper.matrix));
            }
            map.put(PdfName.WhitePoint, new PdfArray(wp));
        }
        array.add(map);
        return array;
    }

    private static class PngChromaticitiesHelper {
        float[] matrix = new float[9];
        float[] wp = new float[3];

        private PngChromaticitiesHelper() {
        }

        public void constructMatrix(PngImageData pngImageData) {
            PngChromaticities pngChromaticities = pngImageData.getPngChromaticities();
            float z = pngChromaticities.getYW() * ((pngChromaticities.getXG() - pngChromaticities.getXB()) * pngChromaticities.getYR() - (pngChromaticities.getXR() - pngChromaticities.getXB()) * pngChromaticities.getYG() + (pngChromaticities.getXR() - pngChromaticities.getXG()) * pngChromaticities.getYB());
            float YA = pngChromaticities.getYR() * ((pngChromaticities.getXG() - pngChromaticities.getXB()) * pngChromaticities.getYW() - (pngChromaticities.getXW() - pngChromaticities.getXB()) * pngChromaticities.getYG() + (pngChromaticities.getXW() - pngChromaticities.getXG()) * pngChromaticities.getYB()) / z;
            float XA = YA * pngChromaticities.getXR() / pngChromaticities.getYR();
            float ZA = YA * ((1.0f - pngChromaticities.getXR()) / pngChromaticities.getYR() - 1.0f);
            float YB = -pngChromaticities.getYG() * ((pngChromaticities.getXR() - pngChromaticities.getXB()) * pngChromaticities.getYW() - (pngChromaticities.getXW() - pngChromaticities.getXB()) * pngChromaticities.getYR() + (pngChromaticities.getXW() - pngChromaticities.getXR()) * pngChromaticities.getYB()) / z;
            float XB = YB * pngChromaticities.getXG() / pngChromaticities.getYG();
            float ZB = YB * ((1.0f - pngChromaticities.getXG()) / pngChromaticities.getYG() - 1.0f);
            float YC = pngChromaticities.getYB() * ((pngChromaticities.getXR() - pngChromaticities.getXG()) * pngChromaticities.getYW() - (pngChromaticities.getXW() - pngChromaticities.getXG()) * pngChromaticities.getYW() + (pngChromaticities.getXW() - pngChromaticities.getXR()) * pngChromaticities.getYG()) / z;
            float XC = YC * pngChromaticities.getXB() / pngChromaticities.getYB();
            float ZC = YC * ((1.0f - pngChromaticities.getXB()) / pngChromaticities.getYB() - 1.0f);
            float XW = XA + XB + XC;
            float YW = 1.0f;
            float ZW = ZA + ZB + ZC;
            float[] wpa = new float[]{XW, YW, ZW};
            this.wp = Arrays.copyOf(wpa, 3);
            float[] matrix = new float[]{XA, YA, ZA, XB, YB, ZB, XC, YC, ZC};
            this.matrix = Arrays.copyOf(matrix, 9);
        }
    }
}

