/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.annot;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNameTree;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfUAConformance;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.BorderStyleUtil;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.navigation.PdfDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfLinkAnnotation
extends PdfAnnotation {
    private static final Logger logger = LoggerFactory.getLogger(PdfLinkAnnotation.class);
    public static final PdfName None = PdfName.N;
    public static final PdfName Invert = PdfName.I;
    public static final PdfName Outline = PdfName.O;
    public static final PdfName Push = PdfName.P;

    protected PdfLinkAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfLinkAnnotation(Rectangle rect) {
        super(rect);
    }

    @Override
    public PdfName getSubtype() {
        return PdfName.Link;
    }

    public PdfObject getDestinationObject() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.Dest);
    }

    public PdfLinkAnnotation setDestination(PdfObject destination) {
        if (((PdfDictionary)this.getPdfObject()).containsKey(PdfName.A)) {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.A);
            logger.warn("Destinations are not permitted for link annotations that already have actions. The old action will be removed.");
        }
        if (destination.isArray() && ((PdfArray)destination).get(0).isNumber()) {
            LoggerFactory.getLogger(PdfLinkAnnotation.class).warn("When destination's not associated with a Remote or Embedded Go-To action, it shall specify page dictionary instead of page number. Otherwise destination might be considered invalid");
        }
        return (PdfLinkAnnotation)this.put(PdfName.Dest, destination);
    }

    public PdfLinkAnnotation setDestination(PdfDestination destination) {
        return this.setDestination((PdfObject)destination.getPdfObject());
    }

    public PdfLinkAnnotation removeDestination() {
        ((PdfDictionary)this.getPdfObject()).remove(PdfName.Dest);
        return this;
    }

    public PdfDictionary getAction() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.A);
    }

    public PdfLinkAnnotation setAction(PdfDictionary action) {
        return (PdfLinkAnnotation)this.put(PdfName.A, action);
    }

    public PdfLinkAnnotation setAction(PdfAction action) {
        if (this.getDestinationObject() != null) {
            this.removeDestination();
            logger.warn("Action was set for a link annotation containing destination. The old destination will be cleared.");
        }
        return (PdfLinkAnnotation)this.put(PdfName.A, (PdfObject)action.getPdfObject());
    }

    public PdfLinkAnnotation removeAction() {
        ((PdfDictionary)this.getPdfObject()).remove(PdfName.A);
        return this;
    }

    public PdfName getHighlightMode() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.H);
    }

    public PdfLinkAnnotation setHighlightMode(PdfName hlMode) {
        return (PdfLinkAnnotation)this.put(PdfName.H, hlMode);
    }

    public PdfDictionary getUriActionObject() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.PA);
    }

    public PdfLinkAnnotation setUriAction(PdfDictionary action) {
        return (PdfLinkAnnotation)this.put(PdfName.PA, action);
    }

    public PdfLinkAnnotation setUriAction(PdfAction action) {
        return (PdfLinkAnnotation)this.put(PdfName.PA, (PdfObject)action.getPdfObject());
    }

    public PdfArray getQuadPoints() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.QuadPoints);
    }

    public PdfLinkAnnotation setQuadPoints(PdfArray quadPoints) {
        return (PdfLinkAnnotation)this.put(PdfName.QuadPoints, quadPoints);
    }

    public PdfDictionary getBorderStyle() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.BS);
    }

    public PdfLinkAnnotation setBorderStyle(PdfDictionary borderStyle) {
        return (PdfLinkAnnotation)this.put(PdfName.BS, borderStyle);
    }

    public PdfLinkAnnotation setBorderStyle(PdfName style) {
        return this.setBorderStyle(BorderStyleUtil.setStyle(this.getBorderStyle(), style));
    }

    public PdfLinkAnnotation setDashPattern(PdfArray dashPattern) {
        return this.setBorderStyle(BorderStyleUtil.setDashPattern(this.getBorderStyle(), dashPattern));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getRoleBasedOnDestination(PdfDocument document) {
        if (document != null && PdfUAConformance.PDF_UA_1 == document.getConformance().getUAConformance()) {
            return "Link";
        }
        PdfObject dest = null;
        PdfDictionary action = this.getAction();
        if (action != null) {
            PdfName actionType = action.getAsName(PdfName.S);
            if (!PdfName.GoTo.equals(actionType)) return "Link";
            dest = action.get(PdfName.SD);
            if (dest == null) {
                dest = action.get(PdfName.D);
            }
        } else {
            dest = this.getDestinationObject();
        }
        if (!PdfLinkAnnotation.isNonIntraDocumentDestination(dest, document, 0)) return "Reference";
        return "Link";
    }

    private static boolean isNonIntraDocumentDestination(PdfObject destination, PdfDocument document, int counter) {
        if (counter > 50) {
            return false;
        }
        ++counter;
        if (destination == null) {
            return false;
        }
        if (destination.getType() == 1) {
            PdfArray destArray = (PdfArray)destination;
            if (destArray.isEmpty()) {
                return false;
            }
            PdfObject firstObj = destArray.get(0);
            return firstObj.isNumber();
        }
        if (document == null) {
            return false;
        }
        if (destination.getType() == 6) {
            return PdfLinkAnnotation.isNonIntraDocumentDestination((PdfName)destination, document, counter);
        }
        if (destination.getType() == 10) {
            return PdfLinkAnnotation.isNonIntraDocumentDestination((PdfString)destination, document, counter);
        }
        return true;
    }

    private static boolean isNonIntraDocumentDestination(PdfName namedDestination, PdfDocument document, int counter) {
        PdfCatalog catalog = document.getCatalog();
        PdfDictionary dests = ((PdfDictionary)catalog.getPdfObject()).getAsDictionary(PdfName.Dests);
        if (dests != null) {
            PdfObject actualDestinationObject = dests.get(namedDestination);
            if (actualDestinationObject instanceof PdfDictionary) {
                return PdfLinkAnnotation.isNonIntraDocumentDestination((PdfDictionary)actualDestinationObject, document, counter);
            }
            return PdfLinkAnnotation.isNonIntraDocumentDestination(actualDestinationObject, document, counter);
        }
        return true;
    }

    private static boolean isNonIntraDocumentDestination(PdfString stringDestination, PdfDocument document, int counter) {
        PdfCatalog catalog = document.getCatalog();
        PdfNameTree dests = catalog.getNameTree(PdfName.Dests);
        PdfObject actualDestinationObject = dests.getEntry(stringDestination);
        if (actualDestinationObject instanceof PdfDictionary) {
            return PdfLinkAnnotation.isNonIntraDocumentDestination((PdfDictionary)actualDestinationObject, document, counter);
        }
        return PdfLinkAnnotation.isNonIntraDocumentDestination(actualDestinationObject, document, counter);
    }

    private static boolean isNonIntraDocumentDestination(PdfDictionary destDictionary, PdfDocument document, int counter) {
        boolean isSdPresent;
        boolean bl = isSdPresent = destDictionary.get(PdfName.SD) != null;
        if (isSdPresent && !PdfLinkAnnotation.isNonIntraDocumentDestination(destDictionary.get(PdfName.SD), document, counter)) {
            return false;
        }
        return isSdPresent || PdfLinkAnnotation.isNonIntraDocumentDestination(destDictionary.get(PdfName.D), document, counter);
    }
}

