/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.crypto.securityhandler;

import com.itextpdf.kernel.crypto.AesGcmDecryptor;
import com.itextpdf.kernel.crypto.IDecryptor;
import com.itextpdf.kernel.crypto.OutputStreamAesGcmEncryption;
import com.itextpdf.kernel.crypto.OutputStreamEncryption;
import com.itextpdf.kernel.crypto.securityhandler.PubSecHandlerUsingAes256;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.security.IExternalDecryptionProcess;
import java.io.OutputStream;
import java.security.Key;
import java.security.cert.Certificate;

public class PubSecHandlerUsingAesGcm
extends PubSecHandlerUsingAes256 {
    protected byte[] noncePart = null;
    protected int inObjectNonceCounter = 0;

    public PubSecHandlerUsingAesGcm(PdfDictionary encryptionDictionary, Certificate[] certs, int[] permissions, boolean encryptMetadata, boolean embeddedFilesOnly) {
        super(encryptionDictionary, certs, permissions, encryptMetadata, embeddedFilesOnly);
    }

    public PubSecHandlerUsingAesGcm(PdfDictionary encryptionDictionary, Key certificateKey, Certificate certificate, String certificateKeyProvider, IExternalDecryptionProcess externalDecryptionProcess, boolean encryptMetadata) {
        super(encryptionDictionary, certificateKey, certificate, certificateKeyProvider, externalDecryptionProcess, encryptMetadata);
    }

    @Override
    public void setHashKeyForNextObject(int objNumber, int objGeneration) {
        this.inObjectNonceCounter = 0;
        this.noncePart = new byte[]{0, 0, (byte)objGeneration, (byte)(objNumber >>> 24), (byte)(objNumber >>> 16), (byte)(objNumber >>> 8), (byte)objNumber};
    }

    @Override
    public OutputStreamEncryption getEncryptionStream(OutputStream os) {
        int ctr = this.inObjectNonceCounter;
        this.noncePart[0] = (byte)(ctr >>> 8);
        this.noncePart[1] = (byte)ctr;
        return new OutputStreamAesGcmEncryption(os, this.nextObjectKey, this.noncePart);
    }

    @Override
    public IDecryptor getDecryptor() {
        return new AesGcmDecryptor(this.nextObjectKey, 0, this.nextObjectKeySize);
    }

    @Override
    protected void setPubSecSpecificHandlerDicEntries(PdfDictionary encryptionDictionary, boolean encryptMetadata, boolean embeddedFilesOnly) {
        int version = 6;
        PdfName filter = PdfName.AESV4;
        this.setEncryptionDictEntries(encryptionDictionary, encryptMetadata, embeddedFilesOnly, version, filter);
    }

    @Override
    protected void initMd5MessageDigest() {
    }
}

