/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.font.FontEncoding;
import com.itextpdf.io.font.FontMetrics;
import com.itextpdf.io.font.FontNames;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.cmap.CMapToUnicode;
import com.itextpdf.io.font.constants.FontDescriptorFlags;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.ArrayUtil;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.font.FontUtil;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfString;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PdfSimpleFont<T extends FontProgram>
extends PdfFont {
    protected FontEncoding fontEncoding;
    protected boolean forceWidthsOutput = false;
    protected byte[] usedGlyphs = new byte[256];
    protected CMapToUnicode toUnicode;

    protected PdfSimpleFont(PdfDictionary fontDictionary) {
        super(fontDictionary);
        this.toUnicode = FontUtil.processToUnicode(fontDictionary.get(PdfName.ToUnicode));
    }

    protected PdfSimpleFont() {
    }

    @Override
    public boolean isBuiltWith(String fontProgram, String encoding) {
        return this.getFontProgram().isBuiltWith(fontProgram) && this.fontEncoding.isBuiltWith(encoding);
    }

    @Override
    public GlyphLine createGlyphLine(String content) {
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>(content.length());
        if (this.fontEncoding.isFontSpecific()) {
            for (int i = 0; i < content.length(); ++i) {
                Glyph glyph = this.fontProgram.getGlyphByCode((int)content.charAt(i));
                if (glyph == null) continue;
                glyphs.add(glyph);
            }
        } else {
            for (int i = 0; i < content.length(); ++i) {
                Glyph glyph = this.getGlyph(content.charAt(i));
                if (glyph == null) continue;
                glyphs.add(glyph);
            }
        }
        return new GlyphLine(glyphs);
    }

    @Override
    public int appendGlyphs(String text, int from, int to, List<Glyph> glyphs) {
        int processed = 0;
        if (this.fontEncoding.isFontSpecific()) {
            Glyph glyph;
            for (int i = from; i <= to && (glyph = this.fontProgram.getGlyphByCode(text.charAt(i) & 0xFF)) != null; ++i) {
                glyphs.add(glyph);
                ++processed;
            }
        } else {
            for (int i = from; i <= to; ++i) {
                Glyph glyph = this.getGlyph(text.charAt(i));
                if (glyph != null && (this.containsGlyph(glyph.getUnicode()) || this.isAppendableGlyph(glyph))) {
                    glyphs.add(glyph);
                    ++processed;
                    continue;
                }
                if (glyph == null && TextUtil.isWhitespaceOrNonPrintable((int)text.charAt(i))) {
                    ++processed;
                    continue;
                }
                break;
            }
        }
        return processed;
    }

    @Override
    public int appendAnyGlyph(String text, int from, List<Glyph> glyphs) {
        Glyph glyph = this.fontEncoding.isFontSpecific() ? this.fontProgram.getGlyphByCode((int)text.charAt(from)) : this.getGlyph(text.charAt(from));
        if (glyph != null) {
            glyphs.add(glyph);
        }
        return 1;
    }

    private boolean isAppendableGlyph(Glyph glyph) {
        return glyph.getCode() > 0 || TextUtil.isWhitespaceOrNonPrintable((int)glyph.getUnicode());
    }

    public FontEncoding getFontEncoding() {
        return this.fontEncoding;
    }

    public CMapToUnicode getToUnicode() {
        return this.toUnicode;
    }

    @Override
    public byte[] convertToBytes(String text) {
        byte[] bytes;
        for (byte b : bytes = this.fontEncoding.convertToBytes(text)) {
            this.usedGlyphs[b & 0xFF] = 1;
        }
        return bytes;
    }

    @Override
    public byte[] convertToBytes(GlyphLine glyphLine) {
        if (glyphLine != null) {
            int i;
            byte[] bytes = new byte[glyphLine.size()];
            int ptr = 0;
            if (this.fontEncoding.isFontSpecific()) {
                for (i = 0; i < glyphLine.size(); ++i) {
                    bytes[ptr++] = (byte)glyphLine.get(i).getCode();
                }
            } else {
                for (i = 0; i < glyphLine.size(); ++i) {
                    if (!this.fontEncoding.canEncode(glyphLine.get(i).getUnicode())) continue;
                    bytes[ptr++] = (byte)this.fontEncoding.convertToByte(glyphLine.get(i).getUnicode());
                }
            }
            for (byte b : bytes = ArrayUtil.shortenArray((byte[])bytes, (int)ptr)) {
                this.usedGlyphs[b & 0xFF] = 1;
            }
            return bytes;
        }
        return EMPTY_BYTES;
    }

    @Override
    public byte[] convertToBytes(Glyph glyph) {
        byte[] bytes = new byte[1];
        if (this.fontEncoding.isFontSpecific()) {
            bytes[0] = (byte)glyph.getCode();
        } else if (this.fontEncoding.canEncode(glyph.getUnicode())) {
            bytes[0] = (byte)this.fontEncoding.convertToByte(glyph.getUnicode());
        } else {
            return EMPTY_BYTES;
        }
        this.usedGlyphs[bytes[0] & 0xFF] = 1;
        return bytes;
    }

    @Override
    public void writeText(GlyphLine text, int from, int to, PdfOutputStream stream) {
        int i;
        byte[] bytes = new byte[to - from + 1];
        int ptr = 0;
        if (this.fontEncoding.isFontSpecific()) {
            for (i = from; i <= to; ++i) {
                bytes[ptr++] = (byte)text.get(i).getCode();
            }
        } else {
            for (i = from; i <= to; ++i) {
                Glyph glyph = text.get(i);
                if (!this.fontEncoding.canEncode(glyph.getUnicode())) continue;
                bytes[ptr++] = (byte)this.fontEncoding.convertToByte(glyph.getUnicode());
            }
        }
        for (byte b : bytes = ArrayUtil.shortenArray((byte[])bytes, (int)ptr)) {
            this.usedGlyphs[b & 0xFF] = 1;
        }
        StreamUtil.writeEscapedString((OutputStream)((Object)stream), (byte[])bytes);
    }

    @Override
    public void writeText(String text, PdfOutputStream stream) {
        StreamUtil.writeEscapedString((OutputStream)((Object)stream), (byte[])this.convertToBytes(text));
    }

    @Override
    public String decode(PdfString content) {
        return this.decodeIntoGlyphLine(content).toString();
    }

    @Override
    public GlyphLine decodeIntoGlyphLine(PdfString content) {
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>(content.getValue().length());
        this.appendDecodedCodesToGlyphsList(glyphs, content);
        return new GlyphLine(glyphs);
    }

    @Override
    public boolean appendDecodedCodesToGlyphsList(List<Glyph> list, PdfString characterCodes) {
        byte[] contentBytes;
        boolean allCodesDecoded = true;
        FontEncoding enc = this.getFontEncoding();
        for (byte b : contentBytes = characterCodes.getValueBytes()) {
            int code = b & 0xFF;
            Glyph glyph = this.getFontProgram().getGlyphByCode(code);
            int uni = enc.getUnicode(code);
            if (glyph == null && uni > -1) {
                glyph = this.getGlyph(uni);
            }
            if (glyph != null) {
                char[] chars;
                CMapToUnicode toUnicodeCMap = this.getToUnicode();
                if (toUnicodeCMap != null && (chars = toUnicodeCMap.lookup(code)) != null && !Arrays.equals(chars, glyph.getChars())) {
                    glyph = new Glyph(glyph);
                    glyph.setChars(chars);
                }
                list.add(glyph);
                continue;
            }
            Logger logger = LoggerFactory.getLogger(this.getClass());
            if (logger.isWarnEnabled()) {
                logger.warn(MessageFormatUtil.format((String)"Could not find glyph with the following code: {0}", (Object[])new Object[]{code}));
            }
            allCodesDecoded = false;
        }
        return allCodesDecoded;
    }

    @Override
    public float getContentWidth(PdfString content) {
        float width = 0.0f;
        GlyphLine glyphLine = this.decodeIntoGlyphLine(content);
        for (int i = glyphLine.start; i < glyphLine.end; ++i) {
            width += (float)glyphLine.get(i).getWidth();
        }
        return width;
    }

    public boolean isForceWidthsOutput() {
        return this.forceWidthsOutput;
    }

    public void setForceWidthsOutput(boolean forceWidthsOutput) {
        this.forceWidthsOutput = forceWidthsOutput;
    }

    protected void flushFontData(String fontName, PdfName subtype) {
        PdfDictionary fontDescriptor;
        int k;
        int lastChar;
        int firstChar;
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, subtype);
        if (fontName != null && fontName.length() > 0) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BaseFont, new PdfName(fontName));
        }
        for (firstChar = 0; firstChar <= 255 && this.usedGlyphs[firstChar] == 0; ++firstChar) {
        }
        for (lastChar = 255; lastChar >= firstChar && this.usedGlyphs[lastChar] == 0; --lastChar) {
        }
        if (firstChar > 255) {
            firstChar = 255;
            lastChar = 255;
        }
        if (!this.isSubset() || !this.isEmbedded()) {
            firstChar = 0;
            lastChar = this.usedGlyphs.length - 1;
            for (k = 0; k < this.usedGlyphs.length; ++k) {
                this.usedGlyphs[k] = this.fontEncoding.canDecode(k) ? (byte)1 : (!this.fontEncoding.hasDifferences() && this.fontProgram.getGlyphByCode(k) != null ? (byte)1 : 0);
            }
        }
        if (this.fontEncoding.hasDifferences()) {
            for (k = firstChar; k <= lastChar; ++k) {
                if (".notdef".equals(this.fontEncoding.getDifference(k))) continue;
                firstChar = k;
                break;
            }
            for (k = lastChar; k >= firstChar; --k) {
                if (".notdef".equals(this.fontEncoding.getDifference(k))) continue;
                lastChar = k;
                break;
            }
            PdfDictionary enc = new PdfDictionary();
            enc.put(PdfName.Type, PdfName.Encoding);
            PdfArray diff = new PdfArray();
            boolean gap = true;
            for (int k2 = firstChar; k2 <= lastChar; ++k2) {
                if (this.usedGlyphs[k2] != 0) {
                    if (gap) {
                        diff.add(new PdfNumber(k2));
                        gap = false;
                    }
                    diff.add(new PdfName(this.fontEncoding.getDifference(k2)));
                    continue;
                }
                gap = true;
            }
            enc.put(PdfName.Differences, diff);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Encoding, enc);
        } else if (!this.fontEncoding.isFontSpecific()) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Encoding, "Cp1252".equals(this.fontEncoding.getBaseEncoding()) ? PdfName.WinAnsiEncoding : PdfName.MacRomanEncoding);
        }
        if (this.isForceWidthsOutput() || !this.isBuiltInFont() || this.fontEncoding.hasDifferences()) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.FirstChar, new PdfNumber(firstChar));
            ((PdfDictionary)this.getPdfObject()).put(PdfName.LastChar, new PdfNumber(lastChar));
            PdfArray wd = this.buildWidthsArray(firstChar, lastChar);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Widths, wd);
        }
        PdfDictionary pdfDictionary = fontDescriptor = !this.isBuiltInFont() ? this.getFontDescriptor(fontName) : null;
        if (fontDescriptor != null) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.FontDescriptor, fontDescriptor);
            if (fontDescriptor.getIndirectReference() != null) {
                fontDescriptor.flush();
            }
        }
    }

    protected boolean isBuiltInFont() {
        return false;
    }

    @Override
    protected PdfDictionary getFontDescriptor(String fontName) {
        assert (fontName != null && fontName.length() > 0);
        FontMetrics fontMetrics = this.fontProgram.getFontMetrics();
        FontNames fontNames = this.fontProgram.getFontNames();
        PdfDictionary fontDescriptor = new PdfDictionary();
        this.makeObjectIndirect(fontDescriptor);
        fontDescriptor.put(PdfName.Type, PdfName.FontDescriptor);
        fontDescriptor.put(PdfName.FontName, new PdfName(fontName));
        fontDescriptor.put(PdfName.Ascent, new PdfNumber(fontMetrics.getTypoAscender()));
        fontDescriptor.put(PdfName.CapHeight, new PdfNumber(fontMetrics.getCapHeight()));
        fontDescriptor.put(PdfName.Descent, new PdfNumber(fontMetrics.getTypoDescender()));
        fontDescriptor.put(PdfName.FontBBox, new PdfArray(ArrayUtil.cloneArray((int[])fontMetrics.getBbox())));
        fontDescriptor.put(PdfName.ItalicAngle, new PdfNumber(fontMetrics.getItalicAngle()));
        fontDescriptor.put(PdfName.StemV, new PdfNumber(fontMetrics.getStemV()));
        if (fontMetrics.getXHeight() > 0) {
            fontDescriptor.put(PdfName.XHeight, new PdfNumber(fontMetrics.getXHeight()));
        }
        if (fontMetrics.getStemH() > 0) {
            fontDescriptor.put(PdfName.StemH, new PdfNumber(fontMetrics.getStemH()));
        }
        if (fontNames.getFontWeight() > 0) {
            fontDescriptor.put(PdfName.FontWeight, new PdfNumber(fontNames.getFontWeight()));
        }
        if (fontNames.getFamilyName() != null && fontNames.getFamilyName().length > 0 && fontNames.getFamilyName()[0].length >= 4) {
            fontDescriptor.put(PdfName.FontFamily, new PdfString(fontNames.getFamilyName()[0][3]));
        }
        this.addFontStream(fontDescriptor);
        int flags = this.fontProgram.getPdfFontFlags();
        flags &= ~(FontDescriptorFlags.Symbolic | FontDescriptorFlags.Nonsymbolic);
        fontDescriptor.put(PdfName.Flags, new PdfNumber(flags |= this.fontEncoding.isFontSpecific() ? FontDescriptorFlags.Symbolic : FontDescriptorFlags.Nonsymbolic));
        return fontDescriptor;
    }

    protected PdfArray buildWidthsArray(int firstChar, int lastChar) {
        PdfArray wd = new PdfArray();
        for (int k = firstChar; k <= lastChar; ++k) {
            if (this.usedGlyphs[k] == 0) {
                wd.add(new PdfNumber(0));
                continue;
            }
            int uni = this.fontEncoding.getUnicode(k);
            Glyph glyph = uni > -1 ? this.getGlyph(uni) : this.fontProgram.getGlyphByCode(k);
            wd.add(new PdfNumber(glyph != null ? glyph.getWidth() : 0));
        }
        return wd;
    }

    protected abstract void addFontStream(PdfDictionary var1);

    protected void setFontProgram(T fontProgram) {
        this.fontProgram = fontProgram;
    }
}

